/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j;

import java.awt.geom.Rectangle2D;

public class BarcodeDimension {
    private final double width;
    private final double height;
    private final double widthPlusQuiet;
    private final double heightPlusQuiet;
    private final double xOffset;
    private final double yOffset;

    public BarcodeDimension(double w, double h) {
        this.width = w;
        this.height = h;
        this.widthPlusQuiet = this.width;
        this.heightPlusQuiet = this.height;
        this.xOffset = 0.0;
        this.yOffset = 0.0;
    }

    public BarcodeDimension(double w, double h, double wpq, double hpq, double xoffset, double yoffset) {
        this.width = w;
        this.height = h;
        this.widthPlusQuiet = wpq;
        this.heightPlusQuiet = hpq;
        this.xOffset = xoffset;
        this.yOffset = yoffset;
    }

    public static int normalizeOrientation(int orientation) {
        switch (orientation) {
            case 0: {
                return 0;
            }
            case -270: 
            case 90: {
                return 90;
            }
            case -180: 
            case 180: {
                return 180;
            }
            case -90: 
            case 270: {
                return 270;
            }
        }
        throw new IllegalArgumentException("Orientation must be 0, 90, 180, 270, -90, -180 or -270");
    }

    public double getHeight() {
        return this.height;
    }

    public double getHeight(int orientation) {
        if ((orientation = BarcodeDimension.normalizeOrientation(orientation)) % 180 != 0) {
            return this.getWidth();
        }
        return this.getHeight();
    }

    public double getHeightPlusQuiet() {
        return this.heightPlusQuiet;
    }

    public double getHeightPlusQuiet(int orientation) {
        if ((orientation = BarcodeDimension.normalizeOrientation(orientation)) % 180 != 0) {
            return this.getWidthPlusQuiet();
        }
        return this.getHeightPlusQuiet();
    }

    public double getWidth() {
        return this.width;
    }

    public double getWidth(int orientation) {
        if ((orientation = BarcodeDimension.normalizeOrientation(orientation)) % 180 != 0) {
            return this.getHeight();
        }
        return this.getWidth();
    }

    public double getWidthPlusQuiet() {
        return this.widthPlusQuiet;
    }

    public double getWidthPlusQuiet(int orientation) {
        if ((orientation = BarcodeDimension.normalizeOrientation(orientation)) % 180 != 0) {
            return this.getHeightPlusQuiet();
        }
        return this.getWidthPlusQuiet();
    }

    public double getXOffset() {
        return this.xOffset;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public Rectangle2D getBoundingRect() {
        return new Rectangle2D.Double(0.0, 0.0, this.getWidthPlusQuiet(), this.getHeightPlusQuiet());
    }

    public Rectangle2D getContentRect() {
        return new Rectangle2D.Double(this.getXOffset(), this.getYOffset(), this.getWidth(), this.getHeight());
    }

    public String toString() {
        return super.toString() + "[width=" + this.getWidth() + "(" + this.getWidthPlusQuiet() + "),height=" + this.getHeight() + "(" + this.getHeightPlusQuiet() + ")]";
    }
}

