/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.attach;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public abstract class HotSpotVirtualMachine
extends VirtualMachine {
    private static final int JNI_ENOMEM = -4;
    private static final int ATTACH_ERROR_BADJAR = 100;
    private static final int ATTACH_ERROR_NOTONCP = 101;
    private static final int ATTACH_ERROR_STARTFAIL = 102;
    private static long defaultAttachTimeout = 5000L;
    private volatile long attachTimeout;

    HotSpotVirtualMachine(AttachProvider provider, String id) {
        super(provider, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAgentLibrary(String agentLibrary, boolean isAbsolute, String options) throws AgentLoadException, AgentInitializationException, IOException {
        InputStream in = this.execute("load", agentLibrary, isAbsolute ? "true" : "false", options);
        try {
            int result = this.readInt(in);
            if (result != 0) {
                throw new AgentInitializationException("Agent_OnAttach failed", result);
            }
        }
        finally {
            in.close();
        }
    }

    public void loadAgentLibrary(String agentLibrary, String options) throws AgentLoadException, AgentInitializationException, IOException {
        this.loadAgentLibrary(agentLibrary, false, options);
    }

    public void loadAgentPath(String agentLibrary, String options) throws AgentLoadException, AgentInitializationException, IOException {
        this.loadAgentLibrary(agentLibrary, true, options);
    }

    public void loadAgent(String agent, String options) throws AgentLoadException, AgentInitializationException, IOException {
        String args = agent;
        if (options != null) {
            args = args + "=" + options;
        }
        try {
            this.loadAgentLibrary("instrument", args);
        }
        catch (AgentLoadException x) {
            throw new InternalError("instrument library is missing in target VM");
        }
        catch (AgentInitializationException x) {
            int rc = x.returnValue();
            switch (rc) {
                case -4: {
                    throw new AgentLoadException("Insuffient memory");
                }
                case 100: {
                    throw new AgentLoadException("Agent JAR not found or no Agent-Class attribute");
                }
                case 101: {
                    throw new AgentLoadException("Unable to add JAR file to system class path");
                }
                case 102: {
                    throw new AgentInitializationException("Agent JAR loaded but agent failed to initialize");
                }
            }
            throw new AgentLoadException("Failed to load agent - unknown reason: " + rc);
        }
    }

    public Properties getSystemProperties() throws IOException {
        InputStream in = null;
        Properties props = new Properties();
        try {
            in = this.executeCommand("properties", new Object[0]);
            props.load(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return props;
    }

    public Properties getAgentProperties() throws IOException {
        InputStream in = null;
        Properties props = new Properties();
        try {
            in = this.executeCommand("agentProperties", new Object[0]);
            props.load(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return props;
    }

    public void localDataDump() throws IOException {
        this.executeCommand("datadump", new Object[0]).close();
    }

    public InputStream remoteDataDump(Object ... args) throws IOException {
        return this.executeCommand("threaddump", args);
    }

    public InputStream dumpHeap(Object ... args) throws IOException {
        return this.executeCommand("dumpheap", args);
    }

    public InputStream heapHisto(Object ... args) throws IOException {
        return this.executeCommand("inspectheap", args);
    }

    public InputStream setFlag(String name, String value) throws IOException {
        return this.executeCommand("setflag", name, value);
    }

    public InputStream printFlag(String name) throws IOException {
        return this.executeCommand("printflag", name);
    }

    public InputStream executeJCmd(String command) throws IOException {
        return this.executeCommand("jcmd", command);
    }

    abstract InputStream execute(String var1, Object ... var2) throws AgentLoadException, IOException;

    private InputStream executeCommand(String cmd, Object ... args) throws IOException {
        try {
            return this.execute(cmd, args);
        }
        catch (AgentLoadException x) {
            throw new InternalError("Should not get here");
        }
    }

    int readInt(InputStream in) throws IOException {
        int value;
        int n;
        StringBuilder sb = new StringBuilder();
        byte[] buf = new byte[1];
        do {
            if ((n = in.read(buf, 0, 1)) <= 0) continue;
            char c = (char)buf[0];
            if (c == '\n') break;
            sb.append(c);
        } while (n > 0);
        if (sb.length() == 0) {
            throw new IOException("Premature EOF");
        }
        try {
            value = Integer.parseInt(sb.toString());
        }
        catch (NumberFormatException x) {
            throw new IOException("Non-numeric value found - int expected");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long attachTimeout() {
        if (this.attachTimeout == 0L) {
            HotSpotVirtualMachine hotSpotVirtualMachine = this;
            synchronized (hotSpotVirtualMachine) {
                if (this.attachTimeout == 0L) {
                    try {
                        String s = System.getProperty("sun.tools.attach.attachTimeout");
                        this.attachTimeout = Long.parseLong(s);
                    }
                    catch (SecurityException se) {
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (this.attachTimeout <= 0L) {
                        this.attachTimeout = defaultAttachTimeout;
                    }
                }
            }
        }
        return this.attachTimeout;
    }
}

