/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.attach.spi;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttachProvider {
    private static final Object lock = new Object();
    private static List<AttachProvider> providers;

    protected AttachProvider() {
    }

    public abstract String name();

    public abstract String type();

    public abstract VirtualMachine attachVirtualMachine(String var1) throws AttachNotSupportedException, IOException;

    public VirtualMachine attachVirtualMachine(VirtualMachineDescriptor vmd) throws AttachNotSupportedException, IOException {
        if (vmd.provider() != this) {
            throw new AttachNotSupportedException("provider mismatch");
        }
        return this.attachVirtualMachine(vmd.id());
    }

    public abstract List<VirtualMachineDescriptor> listVirtualMachines();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AttachProvider> providers() {
        Object object = lock;
        synchronized (object) {
            if (providers == null) {
                providers = new ArrayList<AttachProvider>();
                ServiceLoader<AttachProvider> providerLoader = ServiceLoader.load(AttachProvider.class, AttachProvider.class.getClassLoader());
                for (AttachProvider aProviderLoader : providerLoader) {
                    try {
                        providers.add(aProviderLoader);
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        System.err.println(t);
                    }
                }
            }
            return Collections.unmodifiableList(providers);
        }
    }
}

