/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.agent.support;

import org.powermock.core.MockRepository;
import org.powermock.modules.agent.PowerMockClassRedefiner;
import org.powermock.modules.agent.support.SimpleClassCache;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.proxyframework.RegisterProxyFramework;
import org.powermock.tests.utils.impl.MockPolicyInitializerImpl;
import org.powermock.tests.utils.impl.PrepareForTestExtractorImpl;
import org.powermock.tests.utils.impl.StaticConstructorSuppressExtractorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerMockAgentTestInitializer {
    private static final String JAVA = "java.";
    private static final SimpleClassCache CACHE = new SimpleClassCache(100);

    public static void initialize(Class<?> testClass) {
        MockRepository.clear();
        PrepareForTestExtractorImpl testClassesExtractor = new PrepareForTestExtractorImpl();
        StaticConstructorSuppressExtractorImpl suppressExtractor = new StaticConstructorSuppressExtractorImpl();
        String[] classesToPrepare = testClassesExtractor.getTestClasses(testClass);
        String[] classesToSuppress = suppressExtractor.getTestClasses(testClass);
        PowerMockAgentTestInitializer.redefine(classesToPrepare);
        PowerMockAgentTestInitializer.redefine(classesToSuppress);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        PowerMockAgentTestInitializer.registerProxyframework(contextClassLoader);
        new MockPolicyInitializerImpl(testClass).initialize(contextClassLoader);
    }

    private static void redefine(String[] classes) {
        for (String classToRedefine : classes) {
            if (!CACHE.addIfNotCached(classToRedefine) || classToRedefine.startsWith(JAVA)) continue;
            PowerMockClassRedefiner.redefine(classToRedefine);
        }
    }

    private static void registerProxyframework(ClassLoader classLoader) {
        Class<?> proxyFrameworkClass = null;
        try {
            proxyFrameworkClass = Class.forName("org.powermock.api.extension.proxyframework.ProxyFrameworkImpl", false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Extension API error: org.powermock.api.extension.proxyframework.ProxyFrameworkImpl could not be located in classpath.");
        }
        Class<?> proxyFrameworkRegistrar = null;
        try {
            proxyFrameworkRegistrar = Class.forName(RegisterProxyFramework.class.getName(), false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            Whitebox.invokeMethod(proxyFrameworkRegistrar, (String)"registerProxyFramework", (Object[])new Object[]{Whitebox.newInstance(proxyFrameworkClass)});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

