/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.classloading;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.powermock.api.support.ClassLoaderUtil;
import org.powermock.api.support.SafeExceptionRethrower;
import org.powermock.classloading.spi.DeepClonerSPI;
import org.powermock.classloading.spi.DoNotClone;
import org.powermock.core.ListMap;
import org.powermock.reflect.Whitebox;
import sun.misc.Unsafe;

public class DeepCloner
implements DeepClonerSPI {
    private final ClassLoader targetCL;
    private final Map<Object, Object> referenceMap = new ListMap();
    private final Class<DoNotClone> doNotClone;

    public DeepCloner(ClassLoader classLoader) {
        this.targetCL = classLoader;
        this.doNotClone = this.getDoNotClone(this.targetCL);
    }

    public DeepCloner() {
        this(Thread.currentThread().getContextClassLoader());
    }

    private Class<DoNotClone> getDoNotClone(ClassLoader targetCL) {
        return ClassLoaderUtil.loadClass(DoNotClone.class, (ClassLoader)targetCL);
    }

    public <T> T clone(T objectToClone) {
        return this.clone(objectToClone, true);
    }

    public <T> T clone(T objectToClone, boolean includeStandardJavaType) {
        DeepCloner.assertObjectNotNull(objectToClone);
        return this.performClone(ClassLoaderUtil.loadClass(DeepCloner.getType(objectToClone), (ClassLoader)this.targetCL), objectToClone, includeStandardJavaType);
    }

    private static <T> Class<T> getType(T object) {
        if (object == null) {
            return null;
        }
        return (Class)(object instanceof Class ? object : object.getClass());
    }

    private static boolean isClass(Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof Class;
    }

    private static void assertObjectNotNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Object to clone cannot be null");
        }
    }

    private <T> T performClone(Class<T> targetClass, Object source, boolean shouldCloneStandardJavaTypes) {
        Object target = null;
        if (targetClass.isArray() && !DeepCloner.isClass(source)) {
            return (T)this.instantiateArray(this.targetCL, targetClass, source, shouldCloneStandardJavaTypes);
        }
        if (this.isJavaReflectMethod(targetClass)) {
            return (T)this.cloneJavaReflectMethod(source);
        }
        if (targetClass.isPrimitive() || this.isSunClass(targetClass) || this.isJavaReflectClass(targetClass)) {
            return (T)source;
        }
        if (this.isSerializableCandidate(targetClass, source)) {
            return (T)this.serializationClone(source);
        }
        if (targetClass.isEnum()) {
            return (T)this.cloneEnum(this.targetCL, source);
        }
        if (DeepCloner.isClass(source)) {
            return (T)ClassLoaderUtil.loadClass(DeepCloner.getType(source), (ClassLoader)this.targetCL);
        }
        Object object = target = DeepCloner.isClass(source) ? source : Whitebox.newInstance(targetClass);
        if (target != null) {
            this.referenceMap.put(source, target);
            this.cloneFields(this.targetCL, targetClass, source, target, this.referenceMap, shouldCloneStandardJavaTypes);
        }
        return (T)target;
    }

    private Object cloneJavaReflectMethod(Object source) {
        Method sourceMethod = (Method)source;
        Class<?> declaringClass = sourceMethod.getDeclaringClass();
        Class targetClassLoadedWithTargetCL = ClassLoaderUtil.loadClass(declaringClass, (ClassLoader)this.targetCL);
        Method targetMethod = null;
        try {
            targetMethod = targetClassLoadedWithTargetCL.getDeclaredMethod(sourceMethod.getName(), sourceMethod.getParameterTypes());
        }
        catch (Exception e) {
            SafeExceptionRethrower.safeRethrow((Throwable)e);
        }
        if (sourceMethod.isAccessible()) {
            targetMethod.setAccessible(true);
        }
        return targetMethod;
    }

    private boolean isJavaReflectMethod(Class<?> cls) {
        return cls.getName().equals(Method.class.getName());
    }

    private boolean isSunClass(Class<?> cls) {
        return cls.getName().startsWith("sun.");
    }

    private boolean isJavaReflectClass(Class<?> cls) {
        return cls.getName().startsWith("java.lang.reflect");
    }

    private <T> boolean isSerializableCandidate(Class<T> targetClass, Object source) {
        return DeepCloner.isStandardJavaType(targetClass) && (DeepCloner.isSerializable(targetClass) || DeepCloner.isImpliticlySerializable(targetClass)) && !Map.class.isAssignableFrom(source.getClass()) && !Iterable.class.isAssignableFrom(source.getClass());
    }

    private static boolean isImpliticlySerializable(Class<?> cls) {
        return cls.isPrimitive();
    }

    private static boolean isSerializable(Class<?> cls) {
        return Serializable.class.isAssignableFrom(cls);
    }

    private Object serializationClone(Object source) {
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(source);
            oos.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
            ois = new ObjectInputStream(bin);
            Object object = ois.readObject();
            this.close(oos);
            this.close(ois);
            return object;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.close(oos);
                this.close(ois);
                throw throwable;
            }
        }
    }

    private void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Object cloneEnum(ClassLoader targetCL, Object source) {
        Class enumClassLoadedByTargetCL = ClassLoaderUtil.loadClass(DeepCloner.getType(source), (ClassLoader)targetCL);
        Enum target = DeepCloner.getEnumValue(source, enumClassLoadedByTargetCL);
        return target;
    }

    private <T> void cloneFields(ClassLoader targetCL, Class<T> targetClass, Object source, Object target, Map<Object, Object> referenceMap, boolean cloneStandardJavaTypes) {
        for (Class<T> currentTargetClass = targetClass; currentTargetClass != null; currentTargetClass = currentTargetClass.getSuperclass()) {
            for (Field field : currentTargetClass.getDeclaredFields()) {
                if (field.getAnnotation(this.doNotClone) != null) continue;
                field.setAccessible(true);
                try {
                    boolean needsUnsafeWrite;
                    Object instantiatedValue;
                    Field declaredField = Whitebox.getField(DeepCloner.getType(source), (String)field.getName());
                    declaredField.setAccessible(true);
                    Object object = declaredField.get(source);
                    if (object == source) {
                        instantiatedValue = target;
                    } else if (referenceMap.containsKey(object)) {
                        instantiatedValue = referenceMap.get(object);
                    } else if (object == null && !DeepCloner.isIterable(object)) {
                        instantiatedValue = object;
                    } else {
                        Class type = DeepCloner.getType(object);
                        if (type.getName().equals("void")) {
                            type = (Class)Class.class.cast(Class.class);
                        }
                        Class typeLoadedByCL = ClassLoaderUtil.loadClass(type, (ClassLoader)targetCL);
                        instantiatedValue = type.isEnum() ? DeepCloner.getEnumValue(object, typeLoadedByCL) : this.performClone(typeLoadedByCL, object, cloneStandardJavaTypes);
                    }
                    boolean bl = needsUnsafeWrite = field.isEnumConstant() || DeepCloner.isStaticFinalModifier(field);
                    if (needsUnsafeWrite) {
                        UnsafeFieldWriter.write(field, target, instantiatedValue);
                        continue;
                    }
                    field.set(target, instantiatedValue);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static <T> boolean isStandardJavaType(Class<T> targetClass) {
        return targetClass.getName().startsWith("java.");
    }

    private static boolean isStaticFinalModifier(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isFinal(modifiers) && Modifier.isStatic(modifiers) || field.getDeclaringClass().equals(Character.class) && field.getName().equals("MIN_RADIX");
    }

    private static boolean isIterable(Object object) {
        return object != null && DeepCloner.isIterable(object.getClass());
    }

    private static boolean isIterable(Class<?> cls) {
        return Iterable.class.isAssignableFrom(cls);
    }

    private static Enum getEnumValue(Object enumValueOfSourceClassloader, Class<Object> enumTypeLoadedByTargetCL) {
        return Enum.valueOf(enumTypeLoadedByTargetCL, ((Enum)enumValueOfSourceClassloader).toString());
    }

    private Object instantiateArray(ClassLoader targetCL, Class<?> arrayClass, Object objectToClone, boolean cloneStandardJavaTypes) {
        int arrayLength = Array.getLength(objectToClone);
        Object array = Array.newInstance(arrayClass.getComponentType(), arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            Object object = Array.get(objectToClone, i);
            Object performClone = object == null ? null : this.performClone(ClassLoaderUtil.loadClass(DeepCloner.getType(object), (ClassLoader)targetCL), object, cloneStandardJavaTypes);
            Array.set(array, i, performClone);
        }
        return array;
    }

    private static class UnsafeFieldWriter {
        private static final Unsafe unsafe;
        private static final Exception exception;

        private UnsafeFieldWriter() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void write(Field field, Object object, Object value) {
            if (exception != null) {
                throw new RuntimeException("Could not set field " + object.getClass() + "." + field.getName(), exception);
            }
            try {
                long offset = DeepCloner.isStaticFinalModifier(field) ? unsafe.staticFieldOffset(field) : unsafe.objectFieldOffset(field);
                Class<?> type = field.getType();
                if (type.isPrimitive()) {
                    if (type.equals(Integer.TYPE)) {
                        unsafe.putInt(object, offset, (Integer)value);
                        return;
                    } else if (type.equals(Long.TYPE)) {
                        unsafe.putLong(object, offset, (Long)value);
                        return;
                    } else if (type.equals(Short.TYPE)) {
                        unsafe.putShort(object, offset, (Short)value);
                        return;
                    } else if (type.equals(Character.TYPE)) {
                        unsafe.putChar(object, offset, ((Character)value).charValue());
                        return;
                    } else if (type.equals(Byte.TYPE)) {
                        unsafe.putByte(object, offset, (Byte)value);
                        return;
                    } else if (type.equals(Float.TYPE)) {
                        unsafe.putFloat(object, offset, ((Float)value).floatValue());
                        return;
                    } else if (type.equals(Double.TYPE)) {
                        unsafe.putDouble(object, offset, (Double)value);
                        return;
                    } else {
                        if (!type.equals(Boolean.TYPE)) throw new RuntimeException("Could not set field " + object.getClass() + "." + field.getName() + ": Unknown type " + type);
                        unsafe.putBoolean(object, offset, (Boolean)value);
                    }
                    return;
                } else {
                    unsafe.putObject(object, offset, value);
                }
                return;
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Could not set field " + object.getClass() + "." + field.getName(), e);
            }
        }

        static {
            Unsafe u = null;
            Exception ex = null;
            try {
                Class<?> objectStreamClass = Class.forName("sun.misc.Unsafe");
                Field unsafeField = objectStreamClass.getDeclaredField("theUnsafe");
                unsafeField.setAccessible(true);
                u = (Unsafe)unsafeField.get(null);
            }
            catch (Exception e) {
                ex = e;
            }
            exception = ex;
            unsafe = u;
        }
    }
}

