/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.classloading;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.powermock.api.support.ClassLoaderUtil;
import org.powermock.api.support.SafeExceptionRethrower;
import org.powermock.classloading.ClassloaderExecutor;
import org.powermock.classloading.spi.DeepClonerSPI;
import org.powermock.reflect.Whitebox;

public abstract class AbstractClassloaderExecutor
implements ClassloaderExecutor {
    @Override
    public <T> T execute(Callable<T> callable) {
        this.assertArgumentNotNull(callable, "callable");
        return (T)this.execute(callable, Whitebox.getMethod(callable.getClass(), (String)"call", (Class[])new Class[0]), new Object[0]);
    }

    @Override
    public void execute(Runnable runnable) {
        this.assertArgumentNotNull(runnable, "runnable");
        this.execute(runnable, Whitebox.getMethod(runnable.getClass(), (String)"run", (Class[])new Class[0]), new Object[0]);
    }

    private void assertArgumentNotNull(Object object, String argumentName) {
        if (object == null) {
            throw new IllegalArgumentException(argumentName + " cannot be null.");
        }
    }

    protected abstract Object execute(Object var1, Method var2, Object ... var3);

    Object executeWithClassLoader(Object instance, Method method, ClassLoader classloader, Object[] arguments) {
        DeepClonerSPI deepCloner = this.createDeepCloner(classloader);
        Object objectLoadedWithClassloader = deepCloner.clone(instance);
        Object[] argumentsLoadedByClassLoader = this.cloneArguments(arguments, deepCloner);
        return this.invokeWithClassLoader(classloader, method, objectLoadedWithClassloader, argumentsLoadedByClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeWithClassLoader(ClassLoader classloader, Method method, Object objectLoadedWithClassloader, Object[] argumentsLoadedByClassLoader) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classloader);
            Object result = this.getResult(method, objectLoadedWithClassloader, argumentsLoadedByClassLoader);
            Object object = this.cloneResult(result);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private Object cloneResult(Object result) {
        return result == null ? null : this.createDeepCloner(this.getClass().getClassLoader()).clone(result);
    }

    private Object getResult(Method method, Object objectLoadedWithClassloader, Object[] argumentsLoadedByClassLoader) {
        Object result = null;
        try {
            result = Whitebox.invokeMethod((Object)objectLoadedWithClassloader, (String)method.getName(), (Object[])argumentsLoadedByClassLoader);
        }
        catch (Exception e) {
            SafeExceptionRethrower.safeRethrow((Throwable)e);
        }
        return result;
    }

    private Object[] cloneArguments(Object[] arguments, DeepClonerSPI deepCloner) {
        Object[] argumentsLoadedByClassLoader = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Object argument = arguments[i];
            argumentsLoadedByClassLoader[i] = deepCloner.clone(argument);
        }
        return argumentsLoadedByClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeepClonerSPI createDeepCloner(ClassLoader classLoader) {
        Class deepClonerClass = ClassLoaderUtil.loadClass((String)"org.powermock.classloading.DeepCloner");
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(deepClonerClass.getClass().getClassLoader());
            DeepClonerSPI deepClonerSPI = this.doCreateDeepCloner(classLoader, deepClonerClass);
            return deepClonerSPI;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentCL);
        }
    }

    private DeepClonerSPI doCreateDeepCloner(ClassLoader classLoader, Class<DeepClonerSPI> deepClonerClass) {
        Constructor constructor = Whitebox.getConstructor(deepClonerClass, (Class[])new Class[]{ClassLoader.class});
        try {
            return (DeepClonerSPI)constructor.newInstance(classLoader);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate DeepCloner. The DeepCloner implementation must have a one-arg constructor taking a Classloader as parameter.", e);
        }
    }
}

