/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.Codec;
import io.r2dbc.postgresql.codec.CodecMetadata;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.VectorCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.util.Collections;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class VectorFloatCodec
implements Codec<float[]>,
CodecMetadata {
    private final ByteBufAllocator byteBufAllocator;
    private final int oid;

    VectorFloatCodec(ByteBufAllocator byteBufAllocator, int oid) {
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.oid = oid;
    }

    @Override
    public EncodedParameter encodeNull() {
        return new EncodedParameter(Format.FORMAT_BINARY, this.oid, (Publisher<? extends ByteBuf>)EncodedParameter.NULL_VALUE);
    }

    @Override
    public Class<?> type() {
        return float[].class;
    }

    @Override
    public Iterable<? extends PostgresTypeIdentifier> getDataTypes() {
        return Collections.singleton(AbstractCodec.getDataType(this.oid));
    }

    @Override
    public boolean canDecode(int dataType, Format format, Class<?> type) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return dataType == this.oid && type == float[].class;
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof float[];
    }

    @Override
    public boolean canEncodeNull(Class<?> type) {
        return false;
    }

    @Override
    public float[] decode(@Nullable ByteBuf buffer, int dataType, Format format, Class<? extends float[]> type) {
        if (buffer == null) {
            return null;
        }
        return VectorCodec.decode(buffer, format);
    }

    @Override
    public EncodedParameter encode(Object value) {
        return this.encode(value, this.oid);
    }

    @Override
    public EncodedParameter encode(Object value, int dataType) {
        Assert.requireNonNull(value, "value must not be null");
        float[] vec = (float[])value;
        return new EncodedParameter(Format.FORMAT_BINARY, dataType, (Publisher<? extends ByteBuf>)Mono.fromSupplier(() -> {
            ByteBuf buffer = this.byteBufAllocator.buffer(VectorCodec.estimateBufferSize(vec.length));
            VectorCodec.encodeBinary(buffer, vec);
            return buffer;
        }));
    }
}

