/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.frontend;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.message.frontend.FrontendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class SASLInitialResponse
implements FrontendMessage {
    private final @Nullable ByteBuffer initialResponse;
    private final String name;

    public SASLInitialResponse(@Nullable ByteBuffer initialResponse, String name) {
        this.initialResponse = initialResponse;
        this.name = Assert.requireNonNull(name, "name must not be null");
    }

    @Override
    public Publisher<ByteBuf> encode(ByteBufAllocator byteBufAllocator) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        return Mono.fromSupplier(() -> {
            ByteBuf out = byteBufAllocator.ioBuffer();
            FrontendMessageUtils.writeByte(out, 112);
            FrontendMessageUtils.writeLengthPlaceholder(out);
            FrontendMessageUtils.writeCStringUTF8(out, this.name);
            if (this.initialResponse == null) {
                FrontendMessageUtils.writeInt(out, -1);
            } else {
                FrontendMessageUtils.writeInt(out, this.initialResponse.remaining());
                FrontendMessageUtils.writeBytes(out, this.initialResponse);
            }
            return FrontendMessageUtils.writeSize(out);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SASLInitialResponse that = (SASLInitialResponse)o;
        return Objects.equals(this.initialResponse, that.initialResponse) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.initialResponse, this.name);
    }

    public String toString() {
        return "SASLInitialResponse{initialResponse=" + this.initialResponse + ", name='" + this.name + '\'' + '}';
    }
}

