/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.backend;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.message.backend.AuthenticationMessage;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufferUtils;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class AuthenticationMD5Password
implements AuthenticationMessage {
    private final ByteBuffer salt;

    public AuthenticationMD5Password(ByteBuf salt) {
        Assert.requireNonNull(salt, "salt must not be null");
        this.salt = ByteBufferUtils.toByteBuffer(salt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationMD5Password that = (AuthenticationMD5Password)o;
        return Objects.equals(this.salt, that.salt);
    }

    public ByteBuffer getSalt() {
        return this.salt;
    }

    public int hashCode() {
        return Objects.hash(this.salt);
    }

    public String toString() {
        return "AuthenticationMD5Password{salt=" + this.salt + '}';
    }

    static AuthenticationMD5Password decode(ByteBuf in) {
        Assert.requireNonNull(in, "in must not be null");
        return new AuthenticationMD5Password(in.readSlice(4));
    }
}

