/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.api.ErrorDetails;
import io.r2dbc.postgresql.api.PostgresqlException;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.message.backend.ErrorResponse;
import io.r2dbc.spi.R2dbcBadGrammarException;
import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import io.r2dbc.spi.R2dbcRollbackException;
import io.r2dbc.spi.R2dbcTransientException;
import reactor.core.publisher.SynchronousSink;

final class ExceptionFactory {
    public static final ExceptionFactory INSTANCE = new ExceptionFactory("");
    private final String sql;

    private ExceptionFactory(String sql) {
        this.sql = sql;
    }

    static ExceptionFactory withSql(String sql) {
        return new ExceptionFactory(sql);
    }

    private static R2dbcException createException(ErrorResponse response, String sql) {
        return ExceptionFactory.createException(new ErrorDetails(response.getFields()), sql);
    }

    private static R2dbcException createException(ErrorDetails errorDetails, String sql) {
        String codeClass;
        switch (errorDetails.getCode()) {
            case "42501": {
                return new PostgresqlPermissionDeniedException(errorDetails);
            }
            case "40000": 
            case "40001": {
                return new PostgresqlRollbackException(errorDetails);
            }
            case "28000": 
            case "28P01": {
                return new PostgresqlAuthenticationFailure(errorDetails);
            }
        }
        switch (codeClass = errorDetails.getCode().length() > 2 ? errorDetails.getCode().substring(0, 2) : "99") {
            case "03": 
            case "42": 
            case "22": 
            case "26": {
                return new PostgresqlBadGrammarException(errorDetails, sql);
            }
            case "08": {
                return new PostgresqlNonTransientResourceException(errorDetails);
            }
            case "21": 
            case "23": 
            case "27": {
                return new PostgresqlDataIntegrityViolationException(errorDetails);
            }
            case "28": {
                return new PostgresqlPermissionDeniedException(errorDetails);
            }
            case "40": {
                return new PostgresqlTransientException(errorDetails);
            }
        }
        return new PostgresqlNonTransientResourceException(errorDetails);
    }

    public R2dbcException createException(ErrorDetails errorDetails) {
        return ExceptionFactory.createException(errorDetails, this.sql);
    }

    void handleErrorResponse(BackendMessage message, SynchronousSink<BackendMessage> sink) {
        if (message instanceof ErrorResponse) {
            sink.error((Throwable)ExceptionFactory.createException((ErrorResponse)message, this.sql));
        } else {
            sink.next((Object)message);
        }
    }

    static final class PostgresqlAuthenticationFailure
    extends R2dbcPermissionDeniedException
    implements PostgresqlException {
        private final ErrorDetails errorDetails;

        PostgresqlAuthenticationFailure(ErrorDetails errorDetails) {
            super(errorDetails.getMessage(), errorDetails.getCode());
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class PostgresqlTransientException
    extends R2dbcTransientException
    implements PostgresqlException {
        private final ErrorDetails errorDetails;

        PostgresqlTransientException(ErrorDetails errorDetails) {
            super(errorDetails.getMessage(), errorDetails.getCode());
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class PostgresqlRollbackException
    extends R2dbcRollbackException
    implements PostgresqlException {
        private final ErrorDetails errorDetails;

        PostgresqlRollbackException(ErrorDetails errorDetails) {
            super(errorDetails.getMessage(), errorDetails.getCode());
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class PostgresqlPermissionDeniedException
    extends R2dbcPermissionDeniedException
    implements PostgresqlException {
        private final ErrorDetails errorDetails;

        PostgresqlPermissionDeniedException(ErrorDetails errorDetails) {
            super(errorDetails.getMessage(), errorDetails.getCode());
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class PostgresqlNonTransientResourceException
    extends R2dbcNonTransientResourceException
    implements PostgresqlException {
        private final ErrorDetails errorDetails;

        PostgresqlNonTransientResourceException(ErrorDetails errorDetails) {
            super(errorDetails.getMessage(), errorDetails.getCode());
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class PostgresqlDataIntegrityViolationException
    extends R2dbcDataIntegrityViolationException
    implements PostgresqlException {
        private final ErrorDetails errorDetails;

        PostgresqlDataIntegrityViolationException(ErrorDetails errorDetails) {
            super(errorDetails.getMessage(), errorDetails.getCode());
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class PostgresqlBadGrammarException
    extends R2dbcBadGrammarException
    implements PostgresqlException {
        private final ErrorDetails errorDetails;

        PostgresqlBadGrammarException(ErrorDetails errorDetails, String offendingSql) {
            super(errorDetails.getMessage(), errorDetails.getCode(), 0, offendingSql);
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }
}

