/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.util.UUID;
import reactor.util.annotation.Nullable;

final class UuidCodec
extends AbstractCodec<UUID> {
    private final ByteBufAllocator byteBufAllocator;

    UuidCodec(ByteBufAllocator byteBufAllocator) {
        super(UUID.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    EncodedParameter doEncode(UUID value) {
        return this.doEncode(value, (PostgresTypeIdentifier)PostgresqlObjectId.UUID);
    }

    @Override
    public EncodedParameter doEncode(UUID value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return UuidCodec.create(Format.FORMAT_TEXT, dataType, () -> ByteBufUtils.encode(this.byteBufAllocator, value.toString()));
    }

    @Override
    public EncodedParameter encodeNull() {
        return UuidCodec.createNull(Format.FORMAT_TEXT, PostgresqlObjectId.UUID);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.UUID == type;
    }

    @Override
    UUID doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends UUID> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        if (format == Format.FORMAT_BINARY) {
            return new UUID(buffer.readLong(), buffer.readLong());
        }
        String str = ByteBufUtils.decode(buffer);
        return UUID.fromString(str);
    }
}

