/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractNumericCodec;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.math.BigDecimal;
import java.math.BigInteger;
import reactor.util.annotation.Nullable;

final class BigIntegerCodec
extends AbstractNumericCodec<BigInteger> {
    public BigIntegerCodec(ByteBufAllocator byteBufAllocator) {
        super(BigInteger.class, byteBufAllocator);
    }

    @Override
    BigInteger doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends BigInteger> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return this.decodeNumber(buffer, dataType, format, BigInteger.class, it -> it instanceof BigDecimal ? ((BigDecimal)it).toBigInteger() : BigInteger.valueOf(it.longValue()));
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return PostgresqlObjectId.NUMERIC;
    }
}

