/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.datetime;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.pojava.datetime.DateTime;
import org.pojava.datetime.DateTimeConfig;
import org.pojava.datetime.IDateTimeConfig;
import org.pojava.datetime.LocalConfig;

public class Tm {
    private static final int HOUR = 3600000;
    private static final long DAY = 86400000L;
    private static final long YEAR = 31536000000L;
    private static final long QUADYEAR = 126230400000L;
    private static final long CENT = 3155673600000L;
    private static final long QUADCENT = 12622780800000L;
    private static final long[] MONTH = new long[]{0L, 2678400000L, 5270400000L, 7948800000L, 10540800000L, 13219200000L, 15897600000L, 18489600000L, 21168000000L, 23760000000L, 26438400000L, 29116800000L, 31536000000L};
    private static final long GREG_EPOCH_UTC = -11670912000000L;
    private static final long START_OF_AD = -62135740800000L;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int nanosecond;
    private int weekday;
    private TimeZone tz;

    public Tm(DateTime dt) {
        this.init(dt, dt.timeZone());
    }

    public Tm(DateTime dt, TimeZone tz) {
        this.init(dt, tz);
    }

    public Tm(long millis) {
        IDateTimeConfig config = DateTimeConfig.getGlobalDefault();
        this.init(new DateTime(millis, config), config.getOutputTimeZone());
    }

    public Tm(long millis, TimeZone tz) {
        IDateTimeConfig globalDefault = DateTimeConfig.getGlobalDefault();
        if (tz == null) {
            tz = globalDefault.getOutputTimeZone();
        }
        LocalConfig config = LocalConfig.instanceOverridingOutputTimeZone(globalDefault, tz);
        this.init(new DateTime(millis, (IDateTimeConfig)config), tz);
    }

    private void initYeOlde(long millis) {
        GregorianCalendar cal = new GregorianCalendar(this.tz);
        cal.setTimeInMillis(millis);
        this.year = cal.get(1);
        this.month = 1 + cal.get(2);
        this.day = cal.get(5);
        this.hour = cal.get(11);
        this.minute = cal.get(12);
        this.second = cal.get(13);
        this.weekday = cal.get(7);
        if (millis < -62135740800000L) {
            this.year = -this.year;
        }
    }

    private void init(DateTime dt, TimeZone timeZone) {
        this.tz = timeZone != null ? timeZone : dt.config().getOutputTimeZone();
        long millis = dt.toMillis();
        long duration = millis - -11670912000000L + (long)timeZone.getOffset(dt.toMillis());
        this.nanosecond = dt.getNanos();
        this.weekday = Tm.calcWeekday(millis, timeZone);
        if (millis < -11670912000000L - (long)this.tz.getRawOffset()) {
            this.initYeOlde(millis);
            return;
        }
        long quadCents = duration / 12622780800000L;
        long cents = Math.min(3L, (duration -= quadCents * 12622780800000L) / 3155673600000L);
        long quadYears = (duration -= cents * 3155673600000L) / 126230400000L;
        this.year = Math.min(3, (int)((duration -= quadYears * 126230400000L) / 31536000000L));
        this.year = (int)((long)this.year + (1600L + quadCents * 400L + cents * 100L + quadYears * 4L));
        this.month = (int)((duration -= (long)this.year * 31536000000L) / 2592000000L);
        if (MONTH[this.month] <= duration) {
            ++this.month;
        }
        if (this.month > 0) {
            duration -= MONTH[this.month - 1];
        }
        this.day = (int)(duration / 86400000L);
        this.hour = (int)(duration -= (long)this.day * 86400000L) / 3600000;
        this.minute = (int)(duration -= 1L * (long)this.hour * 3600000L) / 60000;
        this.second = (int)(duration -= (long)this.minute * 60000L) / 1000;
        ++this.day;
        this.month += 2;
        if (this.month > 12) {
            ++this.year;
            if (this.month == 15) {
                this.day = 29;
                this.month = 2;
            } else {
                this.month -= 12;
            }
        }
    }

    public static int calcWeekday(long millis, TimeZone timeZone) {
        long leftover = 0L;
        long offset = (long)DateTimeConfig.getGlobalDefault().getEpochDOW() * 86400000L + 62899200000000L;
        leftover = offset + millis + (long)timeZone.getOffset(millis);
        leftover %= 604800000L;
        leftover /= 86400000L;
        return (int)(++leftover);
    }

    public static long calcTime(int year, int month, int day) {
        IDateTimeConfig config = DateTimeConfig.getGlobalDefault();
        return Tm.calcTime(year, month, day, 0, 0, 0, 0, config.getOutputTimeZone());
    }

    public static long calcTime(int year, int month, int day, int hour, int min, int sec, int milli) {
        IDateTimeConfig config = DateTimeConfig.getGlobalDefault();
        return Tm.calcTime(year, month, day, hour, min, sec, milli, config.getOutputTimeZone());
    }

    public static long calcTime(int year, int month, int day, int hour, int min, int sec, int milli, TimeZone tz) {
        Calendar cal = Calendar.getInstance(tz);
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, min);
        cal.set(13, sec);
        cal.set(14, milli);
        return cal.getTimeInMillis();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getMillisecond() {
        return this.nanosecond / 1000000;
    }

    public int getNanosecond() {
        return this.nanosecond;
    }

    public int getWeekday() {
        return this.weekday;
    }
}

