/*
 * Decompiled with CFR 0.152.
 */
package play.core.j;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import play.api.http.MediaRange;
import play.api.mvc.RequestHeader;
import play.core.j.JavaHelpers$;
import play.i18n.Lang;
import play.i18n.Messages;
import play.libs.typedmap.TypedEntry;
import play.libs.typedmap.TypedKey;
import play.libs.typedmap.TypedMap;
import play.mvc.Http;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class RequestHeaderImpl
implements Http.RequestHeader {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(RequestHeaderImpl.class.getDeclaredField("headers$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RequestHeaderImpl.class.getDeclaredField("getHeaders$lzy1"));
    private final RequestHeader header;
    private volatile Object getHeaders$lzy1;
    private volatile Object headers$lzy1;

    public RequestHeaderImpl(RequestHeader header) {
        this.header = header;
    }

    @Override
    public RequestHeader asScala() {
        return this.header;
    }

    @Override
    public String uri() {
        return this.header.uri();
    }

    @Override
    public String method() {
        return this.header.method();
    }

    @Override
    public String version() {
        return this.header.version();
    }

    @Override
    public String remoteAddress() {
        return this.header.remoteAddress();
    }

    @Override
    public boolean secure() {
        return this.header.secure();
    }

    @Override
    public TypedMap attrs() {
        return new TypedMap(this.header.attrs());
    }

    @Override
    public Http.RequestHeader withAttrs(TypedMap newAttrs) {
        return this.header.withAttrs(newAttrs.asScala()).asJava();
    }

    @Override
    public <A> Http.RequestHeader addAttr(TypedKey<A> key, A value) {
        return this.withAttrs(this.attrs().put(key, value));
    }

    @Override
    public Http.RequestHeader addAttrs(TypedEntry<?> e1) {
        return this.withAttrs(this.attrs().putAll(e1));
    }

    @Override
    public Http.RequestHeader addAttrs(TypedEntry<?> e1, TypedEntry<?> e2) {
        return this.withAttrs(this.attrs().putAll(e1, e2));
    }

    @Override
    public Http.RequestHeader addAttrs(TypedEntry<?> e1, TypedEntry<?> e2, TypedEntry<?> e3) {
        return this.withAttrs(this.attrs().putAll(e1, e2, e3));
    }

    @Override
    public Http.RequestHeader addAttrs(List<TypedEntry<?>> entries) {
        return this.withAttrs(this.attrs().putAll(entries));
    }

    @Override
    public Http.RequestHeader removeAttr(TypedKey<?> key) {
        return this.withAttrs(this.attrs().remove(key));
    }

    @Override
    public Http.Request withBody(Http.RequestBody body) {
        return new Http.RequestImpl(this.header.withBody(body));
    }

    @Override
    public String host() {
        return this.header.host();
    }

    @Override
    public String path() {
        return this.header.path();
    }

    @Override
    public List<Lang> acceptLanguages() {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.header.acceptLanguages().map((Function1 & Serializable)_$5 -> new Lang((play.api.i18n.Lang)_$5))).asJava();
    }

    @Override
    public java.util.Map<String, String[]> queryString() {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)this.header.queryString().view().mapValues((Function1 & Serializable)_$6 -> (String[])_$6.toArray(ClassTag$.MODULE$.apply(String.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    @Override
    public List<MediaRange> acceptedTypes() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.header.acceptedTypes()).asJava();
    }

    @Override
    public boolean accepts(String mediaType) {
        return this.header.accepts(mediaType);
    }

    @Override
    public Http.Cookies cookies() {
        return JavaHelpers$.MODULE$.cookiesToJavaCookies(this.header.cookies());
    }

    @Override
    public Optional<List<X509Certificate>> clientCertificateChain() {
        Option option = OptionConverters$.MODULE$.RichOption(this.header.clientCertificateChain().map((Function1 & Serializable)_$7 -> CollectionConverters$.MODULE$.SeqHasAsJava((Seq)_$7).asJava()));
        return OptionConverters.RichOption$.MODULE$.toJava$extension(option);
    }

    @Override
    public String getQueryString(String key) {
        if (this.queryString().containsKey(key) && this.queryString().get(key).length > 0) {
            return this.queryString().get(key)[0];
        }
        return null;
    }

    @Override
    public Optional<String> queryString(String key) {
        Option option = OptionConverters$.MODULE$.RichOption(this.header.getQueryString(key));
        return OptionConverters.RichOption$.MODULE$.toJava$extension(option);
    }

    @Override
    public Optional<Http.Cookie> cookie(String name) {
        return this.cookies().get(name);
    }

    @Override
    public Optional<Http.Cookie> getCookie(String name) {
        return this.cookie(name);
    }

    @Override
    public boolean hasBody() {
        return this.header.hasBody();
    }

    @Override
    public Optional<String> contentType() {
        Option option = OptionConverters$.MODULE$.RichOption(this.header.contentType());
        return OptionConverters.RichOption$.MODULE$.toJava$extension(option);
    }

    @Override
    public Optional<String> charset() {
        Option option = OptionConverters$.MODULE$.RichOption(this.header.charset());
        return OptionConverters.RichOption$.MODULE$.toJava$extension(option);
    }

    @Override
    public Http.RequestHeader withTransientLang(Lang lang) {
        return this.addAttr(Messages.Attrs.CurrentLang, lang);
    }

    @Override
    public Http.RequestHeader withTransientLang(String code) {
        return this.withTransientLang(Lang.forCode(code));
    }

    @Override
    public Http.RequestHeader withTransientLang(Locale locale) {
        return this.withTransientLang(new Lang(locale));
    }

    @Override
    public Http.RequestHeader withoutTransientLang() {
        return this.removeAttr(Messages.Attrs.CurrentLang);
    }

    public String toString() {
        return this.header.toString();
    }

    @Override
    public Http.Headers getHeaders() {
        Object object = this.getHeaders$lzy1;
        if (object instanceof Http.Headers) {
            return (Http.Headers)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Http.Headers)this.getHeaders$lzyINIT1();
    }

    private Object getHeaders$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.getHeaders$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Http.Headers headers = null;
                    try {
                        headers = this.headers();
                        object2 = headers == null ? LazyVals.NullValue$.MODULE$ : headers;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.getHeaders$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return headers;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Http.Headers headers() {
        Object object = this.headers$lzy1;
        if (object instanceof Http.Headers) {
            return (Http.Headers)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Http.Headers)this.headers$lzyINIT1();
    }

    private Object headers$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.headers$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Http.Headers headers = null;
                    try {
                        headers = this.header.headers().asJava();
                        object2 = headers == null ? LazyVals.NullValue$.MODULE$ : headers;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.headers$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return headers;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }
}

