/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import java.io.Serializable;
import javax.inject.Inject;
import play.api.Environment;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.OptionalSourceMapper;
import play.api.UsefulException;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpErrorHandlerExceptions$;
import play.api.http.JsonHttpErrorHandler$;
import play.api.http.Status$;
import play.api.http.Writeable$;
import play.api.libs.json.JsArray$;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsObject$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsString$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.core.SourceMapper;
import play.libs.exception.ExceptionUtils;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeq;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public class JsonHttpErrorHandler
implements HttpErrorHandler {
    private final Environment environment;
    private final Option<SourceMapper> sourceMapper;
    private final Logger logger;

    public static Option<SourceMapper> $lessinit$greater$default$2() {
        return JsonHttpErrorHandler$.MODULE$.$lessinit$greater$default$2();
    }

    public JsonHttpErrorHandler(Environment environment, Option<SourceMapper> sourceMapper) {
        this.environment = environment;
        this.sourceMapper = sourceMapper;
        this.logger = Logger$.MODULE$.apply(this.getClass());
    }

    @Inject
    public JsonHttpErrorHandler(Environment environment, OptionalSourceMapper optionalSourceMapper) {
        this(environment, optionalSourceMapper.sourceMapper());
    }

    private final JsObject error(JsObject content) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)content, (Writes)JsObject$.MODULE$.writes()));
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    @Override
    public Future<Result> onClientError(RequestHeader request, int statusCode, String message) {
        if (Status$.MODULE$.isClientError(statusCode)) {
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"requestId");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToLong((long)request.id()), (Writes)Writes$.MODULE$.LongWrites()));
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"message");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)message, (Writes)Writes$.MODULE$.StringWrites()));
            return Future$.MODULE$.successful((Object)Results$.MODULE$.Status(statusCode).apply(this.error(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), Writeable$.MODULE$.writeableOf_JsValue()));
        }
        throw new IllegalArgumentException("onClientError invoked with non client error status code " + statusCode + ": " + message);
    }

    @Override
    public Future<Result> onServerError(RequestHeader request, Throwable exception) {
        Future future;
        try {
            Mode mode = this.environment.mode();
            Mode.Prod$ prod$ = Mode.Prod$.MODULE$;
            boolean isProd = !(mode != null ? !mode.equals(prod$) : prod$ != null);
            UsefulException usefulException = HttpErrorHandlerExceptions$.MODULE$.throwableToUsefulException(this.sourceMapper, isProd, exception);
            this.logServerError(request, usefulException);
            future = Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(isProd ? this.prodServerError(request, usefulException) : this.devServerError(request, usefulException), Writeable$.MODULE$.writeableOf_JsValue()));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.logger.error(JsonHttpErrorHandler::onServerError$$anonfun$3, () -> JsonHttpErrorHandler.onServerError$$anonfun$4(e), MarkerContext$.MODULE$.NoMarker());
                future = Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(this.fatalErrorJson(request, e), Writeable$.MODULE$.writeableOf_JsValue()));
            }
            throw throwable;
        }
        return future;
    }

    public JsValue fatalErrorJson(RequestHeader request, Throwable exception) {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    public JsValue devServerError(RequestHeader request, UsefulException exception) {
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)exception.id, (Writes)Writes$.MODULE$.StringWrites()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"requestId");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToLong((long)request.id()), (Writes)Writes$.MODULE$.LongWrites()));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"exception");
        Object[] objectArray2 = new Tuple2[3];
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"title");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)exception.title, (Writes)Writes$.MODULE$.StringWrites()));
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"description");
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)exception.description, (Writes)Writes$.MODULE$.StringWrites()));
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"stacktrace");
        objectArray2[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.formatDevServerErrorException(exception.cause), Writes$.MODULE$.jsValueWrites()));
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)), (Writes)JsObject$.MODULE$.writes()));
        return this.error(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    public JsValue formatDevServerErrorException(Throwable exception) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])ExceptionUtils.getStackFrames(exception));
        return JsArray$.MODULE$.apply((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)s -> JsString$.MODULE$.apply(s.trim()), ClassTag$.MODULE$.apply(JsString.class))));
    }

    public JsValue prodServerError(RequestHeader request, UsefulException exception) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)exception.id, (Writes)Writes$.MODULE$.StringWrites()));
        return this.error(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    public void logServerError(RequestHeader request, UsefulException usefulException) {
        this.logger.error(() -> JsonHttpErrorHandler.logServerError$$anonfun$3(usefulException, request), () -> JsonHttpErrorHandler.logServerError$$anonfun$4(usefulException), MarkerContext$.MODULE$.NoMarker());
    }

    private static final String onServerError$$anonfun$3() {
        return "Error while handling error";
    }

    private static final Throwable onServerError$$anonfun$4(Throwable e$2) {
        return e$2;
    }

    private static final String logServerError$$anonfun$3(UsefulException usefulException$3, RequestHeader request$2) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |\n        |! @%s - Internal server error, for (%s) [%s] ->\n        | "))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{usefulException$3.id, request$2.method(), request$2.uri()}));
    }

    private static final Throwable logServerError$$anonfun$4(UsefulException usefulException$4) {
        return usefulException$4;
    }
}

