/*
 * Decompiled with CFR 0.152.
 */
package play.api;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.stream.Materializer;
import play.api.Application;
import play.api.ApplicationStoppedReason$;
import play.api.Configuration;
import play.api.Environment;
import play.api.http.HttpConfiguration;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpRequestHandler;
import play.api.inject.ApplicationLifecycle;
import play.api.inject.Injector;
import play.api.internal.libs.concurrent.CoordinatedShutdownSupport$;
import play.api.libs.concurrent.CoordinatedShutdownProvider;
import play.api.mvc.request.RequestFactory;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

@Singleton
public class DefaultApplication
implements Application {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DefaultApplication.class.getDeclaredField("globalApplicationEnabled$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DefaultApplication.class.getDeclaredField("httpConfiguration$lzy1"));
    private volatile Object httpConfiguration$lzy1;
    private volatile Object globalApplicationEnabled$lzy1;
    private final Environment environment;
    private final Injector injector;
    private final Configuration configuration;
    private final RequestFactory requestFactory;
    private final HttpRequestHandler requestHandler;
    private final HttpErrorHandler errorHandler;
    private final ActorSystem actorSystem;
    private final Materializer materializer;
    private final CoordinatedShutdown coordinatedShutdown;

    @Inject
    public DefaultApplication(Environment environment, ApplicationLifecycle applicationLifecycle, Injector injector, Configuration configuration, RequestFactory requestFactory, HttpRequestHandler requestHandler, HttpErrorHandler errorHandler, ActorSystem actorSystem, Materializer materializer, CoordinatedShutdown coordinatedShutdown) {
        this.environment = environment;
        this.injector = injector;
        this.configuration = configuration;
        this.requestFactory = requestFactory;
        this.requestHandler = requestHandler;
        this.errorHandler = errorHandler;
        this.actorSystem = actorSystem;
        this.materializer = materializer;
        this.coordinatedShutdown = coordinatedShutdown;
        Application.$init$(this);
    }

    @Override
    public HttpConfiguration httpConfiguration() {
        Object object = this.httpConfiguration$lzy1;
        if (object instanceof HttpConfiguration) {
            return (HttpConfiguration)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (HttpConfiguration)this.httpConfiguration$lzyINIT1();
    }

    private Object httpConfiguration$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.httpConfiguration$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    HttpConfiguration httpConfiguration = null;
                    try {
                        httpConfiguration = Application.httpConfiguration$(this);
                        object2 = httpConfiguration == null ? LazyVals.NullValue$.MODULE$ : httpConfiguration;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.httpConfiguration$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return httpConfiguration;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public boolean globalApplicationEnabled() {
        Object object = this.globalApplicationEnabled$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.globalApplicationEnabled$lzyINIT1());
    }

    private Object globalApplicationEnabled$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.globalApplicationEnabled$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)Application.globalApplicationEnabled$(this));
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.globalApplicationEnabled$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Environment environment() {
        return this.environment;
    }

    @Override
    public Injector injector() {
        return this.injector;
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    @Override
    public RequestFactory requestFactory() {
        return this.requestFactory;
    }

    @Override
    public HttpRequestHandler requestHandler() {
        return this.requestHandler;
    }

    @Override
    public HttpErrorHandler errorHandler() {
        return this.errorHandler;
    }

    @Override
    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    @Override
    public Materializer materializer() {
        return this.materializer;
    }

    @Override
    public CoordinatedShutdown coordinatedShutdown() {
        return this.coordinatedShutdown;
    }

    public DefaultApplication(Environment environment, ApplicationLifecycle applicationLifecycle, Injector injector, Configuration configuration, RequestFactory requestFactory, HttpRequestHandler requestHandler, HttpErrorHandler errorHandler, ActorSystem actorSystem, Materializer materializer) {
        this(environment, applicationLifecycle, injector, configuration, requestFactory, requestHandler, errorHandler, actorSystem, materializer, new CoordinatedShutdownProvider(actorSystem, applicationLifecycle).get());
    }

    @Override
    public File path() {
        return this.environment().rootPath();
    }

    @Override
    public ClassLoader classloader() {
        return this.environment().classLoader();
    }

    @Override
    public Future<?> stop() {
        return CoordinatedShutdownSupport$.MODULE$.asyncShutdown(this.actorSystem(), ApplicationStoppedReason$.MODULE$);
    }
}

