/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.Assets$Asset$;
import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.mvc.ResponseHeader$;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.runtime.ModuleSerializationProxy;

public final class Assets$
implements Serializable {
    private static final Logger logger;
    private static final DateTimeFormatter standardDateParserWithoutTZ;
    private static final DateTimeFormatter alternativeDateFormatWithTZOffset;
    private static final Pattern dateRecognizer;
    public static final Assets$Asset$ Asset;
    public static final Assets$ MODULE$;

    private Assets$() {
    }

    static {
        MODULE$ = new Assets$();
        logger = Logger$.MODULE$.apply(MODULE$.getClass());
        standardDateParserWithoutTZ = DateTimeFormatter.ofPattern(ResponseHeader$.MODULE$.basicDateFormatPattern()).withLocale(Locale.ENGLISH).withZone(ZoneOffset.UTC);
        alternativeDateFormatWithTZOffset = DateTimeFormatter.ofPattern("EEE MMM dd yyyy HH:mm:ss 'GMT'Z").withLocale(Locale.ENGLISH);
        dateRecognizer = Pattern.compile("^(((\\w\\w\\w, \\d\\d \\w\\w\\w \\d\\d\\d\\d \\d\\d:\\d\\d:\\d\\d)(( GMT)?))|(\\w\\w\\w \\w\\w\\w \\d\\d \\d\\d\\d\\d \\d\\d:\\d\\d:\\d\\d GMT.\\d\\d\\d\\d))(\\b.*)");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Assets$.class);
    }

    public DateTimeFormatter standardDateParserWithoutTZ() {
        return standardDateParserWithoutTZ;
    }

    public DateTimeFormatter alternativeDateFormatWithTZOffset() {
        return alternativeDateFormatWithTZOffset;
    }

    public Option<Date> parseModifiedDate(String date) {
        Matcher matcher = dateRecognizer.matcher(date);
        if (matcher.matches()) {
            Some some;
            String standardDate = matcher.group(3);
            try {
                if (standardDate != null) {
                    some = Some$.MODULE$.apply((Object)Date.from(ZonedDateTime.parse(standardDate, this.standardDateParserWithoutTZ()).toInstant()));
                } else {
                    String alternativeDate = matcher.group(6);
                    some = Some$.MODULE$.apply((Object)Date.from(ZonedDateTime.parse(alternativeDate, this.alternativeDateFormatWithTZOffset()).toInstant()));
                }
            }
            catch (IllegalArgumentException e) {
                logger.debug(() -> this.parseModifiedDate$$anonfun$1(date), () -> this.parseModifiedDate$$anonfun$2(e), MarkerContext$.MODULE$.NoMarker());
                some = None$.MODULE$;
            }
            catch (DateTimeParseException e) {
                logger.debug(() -> this.parseModifiedDate$$anonfun$3(date), () -> this.parseModifiedDate$$anonfun$4(e), MarkerContext$.MODULE$.NoMarker());
                some = None$.MODULE$;
            }
            return some;
        }
        logger.debug(() -> this.parseModifiedDate$$anonfun$5(date), MarkerContext$.MODULE$.NoMarker());
        return None$.MODULE$;
    }

    private final String parseModifiedDate$$anonfun$1(String date$1) {
        return "An invalid date was received: couldn't parse: " + date$1;
    }

    private final Throwable parseModifiedDate$$anonfun$2(IllegalArgumentException e$1) {
        return e$1;
    }

    private final String parseModifiedDate$$anonfun$3(String date$2) {
        return "An invalid date was received: couldn't parse: " + date$2;
    }

    private final Throwable parseModifiedDate$$anonfun$4(DateTimeParseException e$2) {
        return e$2;
    }

    private final String parseModifiedDate$$anonfun$5(String date$3) {
        return "An invalid date was received: unrecognized format: " + date$3;
    }
}

