/*
 * Decompiled with CFR 0.152.
 */
package play.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.Environment;
import play.api.OptionalSourceMapper;
import play.api.UsefulException;
import play.api.http.HttpErrorHandlerExceptions;
import play.api.http.Status$;
import play.http.HttpErrorHandler;
import play.libs.Json;
import play.libs.exception.ExceptionUtils;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;

public class JsonHttpErrorHandler
implements HttpErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(JsonHttpErrorHandler.class);
    private final Environment environment;
    private final OptionalSourceMapper sourceMapper;

    @Inject
    public JsonHttpErrorHandler(Environment environment, OptionalSourceMapper optionalSourceMapper) {
        this.environment = environment;
        this.sourceMapper = optionalSourceMapper;
    }

    @Override
    public CompletionStage<Result> onClientError(Http.RequestHeader requestHeader, int n, String string) {
        if (!Status$.MODULE$.isClientError(n)) {
            throw new IllegalArgumentException("onClientError invoked with non client error status code " + n + ": " + string);
        }
        ObjectNode objectNode = Json.newObject();
        objectNode.put("requestId", requestHeader.asScala().id());
        objectNode.put("message", string);
        return CompletableFuture.completedFuture(Results.status(n, this.error((JsonNode)objectNode)));
    }

    @Override
    public CompletionStage<Result> onServerError(Http.RequestHeader requestHeader, Throwable throwable) {
        try {
            UsefulException usefulException = this.throwableToUsefulException(throwable);
            this.logServerError(requestHeader, usefulException);
            switch (this.environment.mode()) {
                case PROD: {
                    return CompletableFuture.completedFuture(Results.internalServerError(this.prodServerError(requestHeader, usefulException)));
                }
            }
            return CompletableFuture.completedFuture(Results.internalServerError(this.devServerError(requestHeader, usefulException)));
        }
        catch (Exception exception) {
            logger.error("Error while handling error", (Throwable)exception);
            return CompletableFuture.completedFuture(Results.internalServerError(this.fatalErrorJson(requestHeader, exception)));
        }
    }

    protected JsonNode fatalErrorJson(Http.RequestHeader requestHeader, Throwable throwable) {
        return Json.newObject();
    }

    protected final UsefulException throwableToUsefulException(Throwable throwable) {
        return HttpErrorHandlerExceptions.throwableToUsefulException(this.sourceMapper.sourceMapper(), this.environment.isProd(), throwable);
    }

    protected void logServerError(Http.RequestHeader requestHeader, UsefulException usefulException) {
        logger.error(String.format("\n\n! @%s - Internal server error, for (%s) [%s] ->\n", usefulException.id, requestHeader.method(), requestHeader.uri()), (Throwable)usefulException);
    }

    protected JsonNode devServerError(Http.RequestHeader requestHeader, UsefulException usefulException) {
        ObjectNode objectNode = Json.newObject();
        objectNode.put("title", usefulException.title);
        objectNode.put("description", usefulException.description);
        objectNode.set("stacktrace", this.formatDevServerErrorException(usefulException.cause));
        ObjectNode objectNode2 = Json.newObject();
        objectNode2.put("id", usefulException.id);
        objectNode2.put("requestId", requestHeader.asScala().id());
        objectNode2.set("exception", (JsonNode)objectNode);
        return this.error((JsonNode)objectNode2);
    }

    protected JsonNode formatDevServerErrorException(Throwable throwable) {
        ArrayNode arrayNode = Json.newArray();
        for (String string : ExceptionUtils.getStackFrames(throwable)) {
            arrayNode.add(string.trim());
        }
        return arrayNode;
    }

    protected JsonNode prodServerError(Http.RequestHeader requestHeader, UsefulException usefulException) {
        ObjectNode objectNode = Json.newObject();
        objectNode.put("id", usefulException.id);
        return this.error((JsonNode)objectNode);
    }

    private JsonNode error(JsonNode jsonNode) {
        ObjectNode objectNode = Json.newObject();
        objectNode.set("error", jsonNode);
        return objectNode;
    }
}

