/*
 * Decompiled with CFR 0.152.
 */
package play.api.mvc;

import java.util.Locale;
import java.util.Optional;
import play.api.http.HeaderNames$;
import play.api.i18n.Lang;
import play.api.i18n.Lang$;
import play.api.i18n.Messages$Attrs$;
import play.api.libs.typedmap.TypedEntry;
import play.api.libs.typedmap.TypedKey;
import play.api.libs.typedmap.TypedMap;
import play.api.mvc.AnyContentAsEmpty$;
import play.api.mvc.Headers;
import play.api.mvc.Request$;
import play.api.mvc.RequestHeader;
import play.api.mvc.RequestImpl;
import play.api.mvc.request.RemoteConnection;
import play.api.mvc.request.RequestTarget;
import play.mvc.Http;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;

public interface Request<A>
extends RequestHeader {
    public static <A> Request<A> apply(RequestHeader requestHeader, A a) {
        return Request$.MODULE$.apply(requestHeader, a);
    }

    public /* synthetic */ boolean play$api$mvc$Request$$super$hasBody();

    public static boolean hasBody$(Request $this) {
        return $this.hasBody();
    }

    @Override
    default public boolean hasBody() {
        if (this.headers().get(HeaderNames$.MODULE$.CONTENT_LENGTH()).isDefined() || this.headers().get(HeaderNames$.MODULE$.TRANSFER_ENCODING()).isDefined()) {
            return this.play$api$mvc$Request$$super$hasBody();
        }
        return !Request.isEmptyBody$1(this.body());
    }

    public A body();

    public static Request map$(Request $this, Function1 f) {
        return $this.map(f);
    }

    default public <B> Request<B> map(Function1<A, B> f) {
        return this.withBody(f.apply(this.body()));
    }

    public static Request withConnection$(Request $this, RemoteConnection newConnection) {
        return $this.withConnection(newConnection);
    }

    @Override
    default public Request<A> withConnection(RemoteConnection newConnection) {
        return new RequestImpl<A>(newConnection, this.method(), this.target(), this.version(), this.headers(), this.attrs(), this.body());
    }

    public static Request withMethod$(Request $this, String newMethod) {
        return $this.withMethod(newMethod);
    }

    @Override
    default public Request<A> withMethod(String newMethod) {
        return new RequestImpl<A>(this.connection(), newMethod, this.target(), this.version(), this.headers(), this.attrs(), this.body());
    }

    public static Request withTarget$(Request $this, RequestTarget newTarget) {
        return $this.withTarget(newTarget);
    }

    @Override
    default public Request<A> withTarget(RequestTarget newTarget) {
        return new RequestImpl<A>(this.connection(), this.method(), newTarget, this.version(), this.headers(), this.attrs(), this.body());
    }

    public static Request withVersion$(Request $this, String newVersion) {
        return $this.withVersion(newVersion);
    }

    @Override
    default public Request<A> withVersion(String newVersion) {
        return new RequestImpl<A>(this.connection(), this.method(), this.target(), newVersion, this.headers(), this.attrs(), this.body());
    }

    public static Request withHeaders$(Request $this, Headers newHeaders) {
        return $this.withHeaders(newHeaders);
    }

    @Override
    default public Request<A> withHeaders(Headers newHeaders) {
        return new RequestImpl<A>(this.connection(), this.method(), this.target(), this.version(), newHeaders, this.attrs(), this.body());
    }

    public static Request withAttrs$(Request $this, TypedMap newAttrs) {
        return $this.withAttrs(newAttrs);
    }

    @Override
    default public Request<A> withAttrs(TypedMap newAttrs) {
        return new RequestImpl<A>(this.connection(), this.method(), this.target(), this.version(), this.headers(), newAttrs, this.body());
    }

    public static Request addAttr$(Request $this, TypedKey key, Object value) {
        return $this.addAttr(key, (B)value);
    }

    default public <B> Request<A> addAttr(TypedKey<B> key, B value) {
        return this.withAttrs(this.attrs().updated(key, value));
    }

    public static Request addAttrs$(Request $this, TypedEntry e1) {
        return $this.addAttrs(e1);
    }

    @Override
    default public Request<A> addAttrs(TypedEntry<?> e1) {
        return this.withAttrs(this.attrs().updated(e1));
    }

    public static Request addAttrs$(Request $this, TypedEntry e1, TypedEntry e2) {
        return $this.addAttrs(e1, e2);
    }

    @Override
    default public Request<A> addAttrs(TypedEntry<?> e1, TypedEntry<?> e2) {
        return this.withAttrs(this.attrs().updated(e1, e2));
    }

    public static Request addAttrs$(Request $this, TypedEntry e1, TypedEntry e2, TypedEntry e3) {
        return $this.addAttrs(e1, e2, e3);
    }

    @Override
    default public Request<A> addAttrs(TypedEntry<?> e1, TypedEntry<?> e2, TypedEntry<?> e3) {
        return this.withAttrs(this.attrs().updated(e1, e2, e3));
    }

    public static Request addAttrs$(Request $this, Seq entries) {
        return $this.addAttrs(entries);
    }

    @Override
    default public Request<A> addAttrs(Seq<TypedEntry<?>> entries) {
        return this.withAttrs(this.attrs().updated(entries));
    }

    public static Request removeAttr$(Request $this, TypedKey key) {
        return $this.removeAttr(key);
    }

    @Override
    default public Request<A> removeAttr(TypedKey<?> key) {
        return this.withAttrs(this.attrs().removed(key));
    }

    public static Request withTransientLang$(Request $this, Lang lang) {
        return $this.withTransientLang(lang);
    }

    @Override
    default public Request<A> withTransientLang(Lang lang) {
        return this.addAttr((TypedKey)Messages$Attrs$.MODULE$.CurrentLang(), (B)lang);
    }

    public static Request withTransientLang$(Request $this, String code) {
        return $this.withTransientLang(code);
    }

    @Override
    default public Request<A> withTransientLang(String code) {
        return this.withTransientLang(Lang$.MODULE$.apply(code));
    }

    public static Request withTransientLang$(Request $this, Locale locale) {
        return $this.withTransientLang(locale);
    }

    @Override
    default public Request<A> withTransientLang(Locale locale) {
        return this.withTransientLang(Lang$.MODULE$.apply(locale));
    }

    public static Request withoutTransientLang$(Request $this) {
        return $this.withoutTransientLang();
    }

    @Override
    default public Request<A> withoutTransientLang() {
        return this.removeAttr(Messages$Attrs$.MODULE$.CurrentLang());
    }

    public static Http.Request asJava$(Request $this) {
        return $this.asJava();
    }

    @Override
    default public Http.Request asJava() {
        A a = this.body();
        if (a == null) {
            return new Http.RequestImpl(this.withBody(null));
        }
        if (a instanceof Http.RequestBody) {
            Http.RequestBody rb = (Http.RequestBody)a;
            return new Http.RequestImpl(this.withBody(rb));
        }
        A rb = a;
        return new Http.RequestImpl(this.withBody(new Http.RequestBody(rb)));
    }

    private static boolean isEmptyBody$1(Object body) {
        Object unit;
        Object object;
        block7: {
            block5: {
                Object object2;
                BoxedUnit boxedUnit;
                block6: {
                    while ((object = body) instanceof Http.RequestBody) {
                        Http.RequestBody rb;
                        Http.RequestBody requestBody = rb = (Http.RequestBody)object;
                        if (rb.as(Optional.class) != null) {
                            return !rb.as(Optional.class).isPresent();
                        }
                        body = rb.as(Object.class);
                    }
                    if (AnyContentAsEmpty$.MODULE$.equals(object) || object == null) break block5;
                    boxedUnit = BoxedUnit.UNIT;
                    object2 = object;
                    if (boxedUnit != null) break block6;
                    if (object2 == null) break block5;
                    break block7;
                }
                if (!boxedUnit.equals(object2)) break block7;
            }
            return true;
        }
        return (unit = object) instanceof BoxedUnit;
    }
}

