/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import io.jsonwebtoken.SignatureAlgorithm;
import java.nio.charset.StandardCharsets;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.http.JWTConfiguration;
import play.api.http.SecretConfiguration;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.concurrent.duration.FiniteDuration;

public final class JWTConfigurationParser$ {
    public static final JWTConfigurationParser$ MODULE$ = new JWTConfigurationParser$();

    public JWTConfiguration apply(Configuration config, SecretConfiguration secretConfiguration, String parent) {
        return new JWTConfiguration(this.getSignatureAlgorithm(config, secretConfiguration, parent), (Option<FiniteDuration>)((Option)config.get(parent + ".expiresAfter", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.finiteDurationLoader()))), (FiniteDuration)config.get(parent + ".clockSkew", ConfigLoader$.MODULE$.finiteDurationLoader()), (String)config.get(parent + ".dataClaim", ConfigLoader$.MODULE$.stringLoader()));
    }

    private String getSignatureAlgorithm(Configuration config, SecretConfiguration secretConfiguration, String parent) {
        String signatureAlgorithmPath = parent + ".signatureAlgorithm";
        String signatureAlgorithm = (String)config.get(signatureAlgorithmPath, ConfigLoader$.MODULE$.stringLoader());
        int minKeyLengthBits = SignatureAlgorithm.forName((String)signatureAlgorithm).getMinKeyLength();
        int applicationSecretLengthBits = secretConfiguration.secret().getBytes(StandardCharsets.UTF_8).length * 8;
        if (applicationSecretLengthBits < minKeyLengthBits) {
            String message = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |The application secret is too short and does not have the recommended amount of entropy for algorithm " + signatureAlgorithm + " defined at " + signatureAlgorithmPath + ".\n           |Current application secret bits: " + applicationSecretLengthBits + ", minimal required bits for algorithm " + signatureAlgorithm + ": " + minKeyLengthBits + ".\n           |To set the application secret, please read https://playframework.com/documentation/latest/ApplicationSecret\n           |"));
            throw config.reportError("play.http.secret.key", message, config.reportError$default$3());
        }
        return signatureAlgorithm;
    }

    private JWTConfigurationParser$() {
    }
}

