/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import com.typesafe.config.ConfigFactory;
import java.util.function.Supplier;
import play.api.Configuration;
import play.api.http.DefaultFileMimeTypes;
import play.api.http.FileMimeTypesConfiguration;
import play.api.http.HttpConfiguration;
import play.libs.F;
import play.mvc.FileMimeTypes;

public class StaticFileMimeTypes {
    private static FileMimeTypes mimeTypes = null;
    private static Supplier<FileMimeTypes> defaultFileMimeTypes = F.LazySupplier.lazy(StaticFileMimeTypes::newDefaultFileMimeTypes);

    public static FileMimeTypes newDefaultFileMimeTypes() {
        Configuration configuration = new Configuration(ConfigFactory.load());
        FileMimeTypesConfiguration fileMimeTypesConfiguration = new FileMimeTypesConfiguration(HttpConfiguration.parseFileMimeTypes(configuration));
        return new FileMimeTypes(new DefaultFileMimeTypes(fileMimeTypesConfiguration));
    }

    public static void setFileMimeTypes(FileMimeTypes fileMimeTypes) {
        mimeTypes = fileMimeTypes;
    }

    public static FileMimeTypes fileMimeTypes() {
        if (mimeTypes == null) {
            return defaultFileMimeTypes.get();
        }
        return mimeTypes;
    }
}

