/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.common;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.util.Locale;
import play.api.Configuration;
import play.api.MarkerContext$;
import play.api.mvc.Headers;
import play.api.mvc.request.RemoteConnection;
import play.api.mvc.request.RemoteConnection$;
import play.core.server.common.ForwardedHeaderHandler$;
import play.core.server.common.ForwardedHeaderHandler$ForwardedEntry$;
import play.core.server.common.ForwardedHeaderHandler$ForwardedHeaderHandlerConfig$;
import play.core.server.common.ForwardedHeaderHandler$ParsedForwardedEntry$;
import play.core.server.common.ForwardedHeaderHandler$Rfc7239$;
import play.core.server.common.ForwardedHeaderHandler$Xforwarded$;
import play.core.server.common.NodeIdentifierParser;
import play.core.server.common.NodeIdentifierParser$Ip$;
import play.core.server.common.Subnet;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class ForwardedHeaderHandler {
    public final ForwardedHeaderHandlerConfig play$core$server$common$ForwardedHeaderHandler$$configuration;

    public ForwardedHeaderHandler(ForwardedHeaderHandlerConfig configuration) {
        this.play$core$server$common$ForwardedHeaderHandler$$configuration = configuration;
    }

    public RemoteConnection forwardedConnection(RemoteConnection rawConnection, Headers headers) {
        return new RemoteConnection(rawConnection, headers, this){
            private final RemoteConnection rawConnection$1;
            private final Headers headers$1;
            public static final long OFFSET$0;
            private volatile Object parsed$lzy1;
            private final /* synthetic */ ForwardedHeaderHandler $outer;
            {
                this.rawConnection$1 = rawConnection$2;
                this.headers$1 = headers$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            static {
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic($anon$1.class.getDeclaredField("parsed$lzy1"));
            }

            public InetAddress remoteAddress() {
                return this.parsed().remoteAddress();
            }

            public boolean secure() {
                return this.parsed().secure();
            }

            public Option clientCertificateChain() {
                return this.parsed().clientCertificateChain();
            }

            private RemoteConnection parsed() {
                Object object = this.parsed$lzy1;
                if (object instanceof RemoteConnection) {
                    return (RemoteConnection)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (RemoteConnection)this.parsed$lzyINIT1();
            }

            private Object parsed$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.parsed$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            RemoteConnection remoteConnection = null;
                            try {
                                Iterator headerEntries = this.$outer.play$core$server$common$ForwardedHeaderHandler$$configuration.forwardedHeaders(this.headers$1).reverseIterator();
                                remoteConnection = this.scan$1(headerEntries, this.rawConnection$1);
                                object2 = remoteConnection == null ? LazyVals.NullValue$.MODULE$ : remoteConnection;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.parsed$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return remoteConnection;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            private final RemoteConnection scan$1(Iterator headerEntries$1, RemoteConnection prev) {
                while (headerEntries$1.hasNext()) {
                    if (this.$outer.play$core$server$common$ForwardedHeaderHandler$$configuration.isTrustedProxy(prev.remoteAddress())) {
                        ForwardedEntry entry = (ForwardedEntry)headerEntries$1.next();
                        Either<String, ParsedForwardedEntry> either = this.$outer.play$core$server$common$ForwardedHeaderHandler$$configuration.parseEntry(entry);
                        if (either instanceof Left) {
                            String error = (String)((Left)either).value();
                            ForwardedHeaderHandler$.play$core$server$common$ForwardedHeaderHandler$$$logger.debug(() -> ForwardedHeaderHandler.play$core$server$common$ForwardedHeaderHandler$$anon$1$$_$scan$1$$anonfun$1(entry, error, prev), MarkerContext$.MODULE$.NoMarker());
                            return prev;
                        }
                        if (either instanceof Right) {
                            ParsedForwardedEntry parsedEntry = (ParsedForwardedEntry)((Right)either).value();
                            prev = RemoteConnection$.MODULE$.apply(parsedEntry.address(), parsedEntry.secure(), (Option)None$.MODULE$);
                            continue;
                        }
                        throw new MatchError(either);
                    }
                    return prev;
                }
                return prev;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$core$server$common$ForwardedHeaderHandler$$anon$1$$_$scan$1$$anonfun$1(play.core.server.common.ForwardedHeaderHandler$ForwardedEntry java.lang.String play.api.mvc.request.RemoteConnection )}, serializedLambda);
            }
        };
    }

    public static final String play$core$server$common$ForwardedHeaderHandler$$anon$1$$_$scan$1$$anonfun$1(ForwardedEntry entry$1, String error$1, RemoteConnection prev$tailLocal1$1) {
        return "Error with info in forwarding header " + entry$1 + ", using " + prev$tailLocal1$1 + " instead: " + error$1 + ".";
    }

    public static final class ForwardedEntry
    implements Product,
    Serializable {
        private final Option addressString;
        private final Option protoString;

        public static ForwardedEntry apply(Option<String> option, Option<String> option2) {
            return ForwardedHeaderHandler$ForwardedEntry$.MODULE$.apply(option, option2);
        }

        public static ForwardedEntry fromProduct(Product product) {
            return ForwardedHeaderHandler$ForwardedEntry$.MODULE$.fromProduct(product);
        }

        public static ForwardedEntry unapply(ForwardedEntry forwardedEntry) {
            return ForwardedHeaderHandler$ForwardedEntry$.MODULE$.unapply(forwardedEntry);
        }

        public ForwardedEntry(Option<String> addressString, Option<String> protoString) {
            this.addressString = addressString;
            this.protoString = protoString;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ForwardedEntry)) return false;
            ForwardedEntry forwardedEntry = (ForwardedEntry)object;
            Option<String> option = this.addressString();
            Option<String> option2 = forwardedEntry.addressString();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.protoString();
            Option<String> option4 = forwardedEntry.protoString();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ForwardedEntry;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ForwardedEntry";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "addressString";
            }
            if (1 == n2) {
                return "protoString";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<String> addressString() {
            return this.addressString;
        }

        public Option<String> protoString() {
            return this.protoString;
        }

        public ForwardedEntry copy(Option<String> addressString, Option<String> protoString) {
            return new ForwardedEntry(addressString, protoString);
        }

        public Option<String> copy$default$1() {
            return this.addressString();
        }

        public Option<String> copy$default$2() {
            return this.protoString();
        }

        public Option<String> _1() {
            return this.addressString();
        }

        public Option<String> _2() {
            return this.protoString();
        }
    }

    public static class ForwardedHeaderHandlerConfig
    implements Product,
    Serializable {
        private final ForwardedHeaderVersion version;
        private final List trustedProxies;
        private final NodeIdentifierParser nodeIdentifierParser;

        public static ForwardedHeaderHandlerConfig apply(ForwardedHeaderVersion forwardedHeaderVersion, List<Subnet> list) {
            return ForwardedHeaderHandler$ForwardedHeaderHandlerConfig$.MODULE$.apply(forwardedHeaderVersion, list);
        }

        public static ForwardedHeaderHandlerConfig apply(Option<Configuration> option) {
            return ForwardedHeaderHandler$ForwardedHeaderHandlerConfig$.MODULE$.apply(option);
        }

        public static ForwardedHeaderHandlerConfig fromProduct(Product product) {
            return ForwardedHeaderHandler$ForwardedHeaderHandlerConfig$.MODULE$.fromProduct(product);
        }

        public static ForwardedHeaderHandlerConfig unapply(ForwardedHeaderHandlerConfig forwardedHeaderHandlerConfig) {
            return ForwardedHeaderHandler$ForwardedHeaderHandlerConfig$.MODULE$.unapply(forwardedHeaderHandlerConfig);
        }

        public ForwardedHeaderHandlerConfig(ForwardedHeaderVersion version, List<Subnet> trustedProxies) {
            this.version = version;
            this.trustedProxies = trustedProxies;
            this.nodeIdentifierParser = new NodeIdentifierParser(version);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ForwardedHeaderHandlerConfig)) return false;
            ForwardedHeaderHandlerConfig forwardedHeaderHandlerConfig = (ForwardedHeaderHandlerConfig)object;
            ForwardedHeaderVersion forwardedHeaderVersion = this.version();
            ForwardedHeaderVersion forwardedHeaderVersion2 = forwardedHeaderHandlerConfig.version();
            if (forwardedHeaderVersion == null) {
                if (forwardedHeaderVersion2 != null) {
                    return false;
                }
            } else if (!forwardedHeaderVersion.equals(forwardedHeaderVersion2)) return false;
            List<Subnet> list = this.trustedProxies();
            List<Subnet> list2 = forwardedHeaderHandlerConfig.trustedProxies();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            if (!forwardedHeaderHandlerConfig.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ForwardedHeaderHandlerConfig;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ForwardedHeaderHandlerConfig";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "version";
            }
            if (1 == n2) {
                return "trustedProxies";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ForwardedHeaderVersion version() {
            return this.version;
        }

        public List<Subnet> trustedProxies() {
            return this.trustedProxies;
        }

        public NodeIdentifierParser nodeIdentifierParser() {
            return this.nodeIdentifierParser;
        }

        private String unquote(String s) {
            if (s.length() >= 2 && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
                return s.substring(1, s.length() - 1);
            }
            return s;
        }

        public Seq<ForwardedEntry> forwardedHeaders(Headers headers) {
            ForwardedHeaderVersion forwardedHeaderVersion = this.version();
            if (ForwardedHeaderHandler$Rfc7239$.MODULE$.equals(forwardedHeaderVersion)) {
                Seq params = (Seq)headers.getAll("Forwarded").flatMap((Function1 & Serializable)fhs -> {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])fhs.split(",\\s*"));
                    return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)fh -> {
                        Object object = Predef$.MODULE$.refArrayOps((Object[])fh.split(";"));
                        return ArrayOps$.MODULE$.iterator$extension(object).flatMap((Function1 & Serializable)_$1 -> {
                            Tuple2 tuple2 = StringOps$.MODULE$.span$extension(Predef$.MODULE$.augmentString(_$1), (Function1 & Serializable)_$2 -> this.$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$2)));
                            if (tuple2 != null) {
                                String string = (String)tuple2._2();
                                if ("".equals(string)) {
                                    return Option$.MODULE$.empty();
                                }
                                String rawName = (String)tuple2._1();
                                String v = string;
                                String name = rawName.toLowerCase(Locale.ENGLISH);
                                String value = this.unquote(StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString(v)));
                                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
                                return Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)value));
                            }
                            throw new MatchError((Object)tuple2);
                        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    }, ClassTag$.MODULE$.apply(Map.class)));
                });
                return (Seq)params.map((Function1 & Serializable)paramMap -> ForwardedHeaderHandler$ForwardedEntry$.MODULE$.apply((Option<String>)paramMap.get((Object)"for"), (Option<String>)paramMap.get((Object)"proto")));
            }
            if (ForwardedHeaderHandler$Xforwarded$.MODULE$.equals(forwardedHeaderVersion)) {
                Seq forHeaders = this.h$1(headers, "X-Forwarded-For");
                Seq protoHeaders = this.h$1(headers, "X-Forwarded-Proto");
                if (forHeaders.length() == protoHeaders.length()) {
                    return (Seq)forHeaders.lazyZip((Iterable)protoHeaders).map((Function2 & Serializable)(f, p) -> ForwardedHeaderHandler$ForwardedEntry$.MODULE$.apply((Option<String>)Some$.MODULE$.apply(f), (Option<String>)Some$.MODULE$.apply(p)), BuildFrom$.MODULE$.buildFromIterableOps());
                }
                return (Seq)forHeaders.map((Function1 & Serializable)x$1 -> {
                    String string;
                    String f = string = x$1;
                    return ForwardedHeaderHandler$ForwardedEntry$.MODULE$.apply((Option<String>)Some$.MODULE$.apply((Object)f), (Option<String>)None$.MODULE$);
                });
            }
            throw new MatchError((Object)forwardedHeaderVersion);
        }

        public Either<String, ParsedForwardedEntry> parseEntry(ForwardedEntry entry) {
            Option<String> option = entry.addressString();
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)"No address");
            }
            if (option instanceof Some) {
                NodeIdentifierParser.IpAddress ipAddress;
                Tuple2 tuple2;
                String addressString = (String)((Some)option).value();
                Either<String, Tuple2<NodeIdentifierParser.IpAddress, Option<NodeIdentifierParser.Port>>> either = this.nodeIdentifierParser().parseNode(addressString);
                if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null && (ipAddress = (NodeIdentifierParser.IpAddress)tuple2._1()) instanceof NodeIdentifierParser.Ip) {
                    InetAddress inetAddress;
                    NodeIdentifierParser.Ip ip = NodeIdentifierParser$Ip$.MODULE$.unapply((NodeIdentifierParser.Ip)ipAddress);
                    InetAddress address = inetAddress = ip._1();
                    boolean secure = BoxesRunTime.unboxToBoolean((Object)entry.protoString().fold(this::$anonfun$2, (Function1 & Serializable)_$3 -> {
                        String string = _$3;
                        String string2 = "https";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }));
                    ParsedForwardedEntry connection = ForwardedHeaderHandler$ParsedForwardedEntry$.MODULE$.apply(address, secure);
                    return package$.MODULE$.Right().apply((Object)connection);
                }
                Either<String, Tuple2<NodeIdentifierParser.IpAddress, Option<NodeIdentifierParser.Port>>> errorOrNonIp = either;
                return package$.MODULE$.Left().apply((Object)("Parse error: " + errorOrNonIp));
            }
            throw new MatchError(option);
        }

        public boolean isTrustedProxy(InetAddress address) {
            return this.trustedProxies().exists((Function1 & Serializable)_$4 -> _$4.isInRange(address));
        }

        public ForwardedHeaderHandlerConfig copy(ForwardedHeaderVersion version, List<Subnet> trustedProxies) {
            return new ForwardedHeaderHandlerConfig(version, trustedProxies);
        }

        public ForwardedHeaderVersion copy$default$1() {
            return this.version();
        }

        public List<Subnet> copy$default$2() {
            return this.trustedProxies();
        }

        public ForwardedHeaderVersion _1() {
            return this.version();
        }

        public List<Subnet> _2() {
            return this.trustedProxies();
        }

        private final /* synthetic */ boolean $anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(char _$2) {
            return _$2 != '=';
        }

        private final Seq h$1(Headers h, String key) {
            return (Seq)((IterableOps)h.getAll(key).flatMap((Function1 & Serializable)s -> Predef$.MODULE$.wrapRefArray((Object[])s.split(",\\s*")))).map((Function1 & Serializable)s -> this.unquote((String)s));
        }

        private final boolean $anonfun$2() {
            return false;
        }
    }

    public static interface ForwardedHeaderVersion {
    }

    public static final class ParsedForwardedEntry
    implements Product,
    Serializable {
        private final InetAddress address;
        private final boolean secure;

        public static ParsedForwardedEntry apply(InetAddress inetAddress, boolean bl) {
            return ForwardedHeaderHandler$ParsedForwardedEntry$.MODULE$.apply(inetAddress, bl);
        }

        public static ParsedForwardedEntry fromProduct(Product product) {
            return ForwardedHeaderHandler$ParsedForwardedEntry$.MODULE$.fromProduct(product);
        }

        public static ParsedForwardedEntry unapply(ParsedForwardedEntry parsedForwardedEntry) {
            return ForwardedHeaderHandler$ParsedForwardedEntry$.MODULE$.unapply(parsedForwardedEntry);
        }

        public ParsedForwardedEntry(InetAddress address, boolean secure) {
            this.address = address;
            this.secure = secure;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.address()));
            n = Statics.mix((int)n, (int)(this.secure() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ParsedForwardedEntry)) return false;
            ParsedForwardedEntry parsedForwardedEntry = (ParsedForwardedEntry)object;
            if (this.secure() != parsedForwardedEntry.secure()) return false;
            InetAddress inetAddress = this.address();
            InetAddress inetAddress2 = parsedForwardedEntry.address();
            if (inetAddress != null) {
                if (!((Object)inetAddress).equals(inetAddress2)) return false;
                return true;
            }
            if (inetAddress2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ParsedForwardedEntry;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ParsedForwardedEntry";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "address";
            }
            if (1 == n2) {
                return "secure";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public InetAddress address() {
            return this.address;
        }

        public boolean secure() {
            return this.secure;
        }

        public ParsedForwardedEntry copy(InetAddress address, boolean secure) {
            return new ParsedForwardedEntry(address, secure);
        }

        public InetAddress copy$default$1() {
            return this.address();
        }

        public boolean copy$default$2() {
            return this.secure();
        }

        public InetAddress _1() {
            return this.address();
        }

        public boolean _2() {
            return this.secure();
        }
    }
}

