/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.ssl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import javax.net.ssl.KeyManagerFactory;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.core.server.ssl.FakeKeyStore$;
import play.core.server.ssl.FakeKeyStore$KeystoreSettings$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]wAB\u00193\u0011\u0003!$H\u0002\u0004=e!\u0005A'\u0010\u0005\u0006\t\u0006!\tA\u0012\u0005\b\u000f\u0006\u0011\r\u0011\"\u0003I\u0011\u0019y\u0015\u0001)A\u0005\u0013\u001e)\u0001+\u0001E\u0001#\u001a)1+\u0001E\u0001)\")AI\u0002C\u0001+\u001e)aK\u0002E\u0001/\u001a)\u0011L\u0002E\u00015\")A)\u0003C\u00017\"9A,\u0003b\u0001\n\u0003i\u0006B\u00024\nA\u0003%a\fC\u0004h\u0013\t\u0007I\u0011A/\t\r!L\u0001\u0015!\u0003_\u0011\u001dIgA1A\u0005\u0002uCaA\u001b\u0004!\u0002\u0013q\u0006bB6\u0007\u0005\u0004%\t\u0001\u0013\u0005\u0007Y\u001a\u0001\u000b\u0011B%\b\u000b5\f\u0001\u0012\u00018\u0007\u000b=\f\u0001\u0012\u00019\t\u000b\u0011#B\u0011A9\t\u000fI$\"\u0019!C\u0001g\"1a\u0010\u0006Q\u0001\nQDqa \u000bC\u0002\u0013\u0005Q\fC\u0004\u0002\u0002Q\u0001\u000b\u0011\u00020\t\u0011\u0005\rAC1A\u0005\u0002uCq!!\u0002\u0015A\u0003%a\fC\u0005\u0002\bQ\u0011\r\u0011\"\u0001\u0002\n!A\u0011\u0011\u0003\u000b!\u0002\u0013\tY\u0001\u0003\u0005\u0002\u0014Q\u0011\r\u0011\"\u0001^\u0011\u001d\t)\u0002\u0006Q\u0001\nyC\u0001\"a\u0006\u0015\u0005\u0004%\t\u0001\u0013\u0005\b\u00033!\u0002\u0015!\u0003J\u0011\u001d\tY\"\u0001C\u0005\u0003;Aq!a\t\u0002\t\u0003\t)\u0003C\u0004\u00024\u0005!\t!!\u000e\u0007\rq\u0012$\u0001NA'\u0011\u0019!U\u0005\"\u0001\u0002P!I\u00111K\u0013C\u0002\u0013%\u0011Q\u000b\u0005\t\u0003G*\u0003\u0015!\u0003\u0002X!9\u0011QM\u0013\u0005\u0002\u0005\u001d\u0004\u0002CA=K\u0011\u0005!'a\u001f\t\u000f\u0005\u001dU\u0005\"\u0003\u0002\n\"A\u0011qR\u0013\u0005\u0002I\n\t\nC\u0004\u0002\u001e\u0016\"\t!a(\t\u000f\u0005\rV\u0005\"\u0003\u0002&\"9\u0011\u0011W\u0013\u0005\u0002\u0005M\u0006bBAeK\u0011\u0005\u00111Z\u0001\r\r\u0006\\WmS3z'R|'/\u001a\u0006\u0003gQ\n1a]:m\u0015\t)d'\u0001\u0004tKJ4XM\u001d\u0006\u0003oa\nAaY8sK*\t\u0011(\u0001\u0003qY\u0006L\bCA\u001e\u0002\u001b\u0005\u0011$\u0001\u0004$bW\u0016\\U-_*u_J,7CA\u0001?!\ty$)D\u0001A\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"A\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001;\u00039)U\n\u0015+Z?B\u000b5kU,P%\u0012+\u0012!\u0013\t\u0004\u007f)c\u0015BA&A\u0005\u0015\t%O]1z!\tyT*\u0003\u0002O\u0001\n!1\t[1s\u0003=)U\n\u0015+Z?B\u000b5kU,P%\u0012\u0003\u0013AC*fY\u001a\u001c\u0016n\u001a8fIB\u0011!KB\u0007\u0002\u0003\tQ1+\u001a7g'&<g.\u001a3\u0014\u0005\u0019qD#A)\u0002\u000b\u0005c\u0017.Y:\u0011\u0005aKQ\"\u0001\u0004\u0003\u000b\u0005c\u0017.Y:\u0014\u0005%qD#A,\u0002!Q\u0014Xo\u001d;fI\u000e+'\u000f^#oiJLX#\u00010\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017\u0001\u00027b]\u001eT\u0011aY\u0001\u0005U\u00064\u0018-\u0003\u0002fA\n11\u000b\u001e:j]\u001e\f\u0011\u0003\u001e:vgR,GmQ3si\u0016sGO]=!\u0003=\u0001&/\u001b<bi\u0016\\U-_#oiJL\u0018\u0001\u0005)sSZ\fG/Z&fs\u0016sGO]=!\u0003E!\u0015n\u001d;j]\u001e,\u0018n\u001d5fI:\u000bW.Z\u0001\u0013\t&\u001cH/\u001b8hk&\u001c\b.\u001a3OC6,\u0007%A\u0006lKf\u0004\u0016m]:x_J$\u0017\u0001D6fsB\u000b7o]<pe\u0012\u0004\u0013\u0001E&fsN$xN]3TKR$\u0018N\\4t!\t\u0011FC\u0001\tLKf\u001cHo\u001c:f'\u0016$H/\u001b8hgN\u0011AC\u0010\u000b\u0002]\u0006\tr)\u001a8fe\u0006$X\rZ&fsN#xN]3\u0016\u0003Q\u0004\"!\u001e?\u000f\u0005YT\bCA<A\u001b\u0005A(BA=F\u0003\u0019a$o\\8u}%\u00111\u0010Q\u0001\u0007!J,G-\u001a4\n\u0005\u0015l(BA>A\u0003I9UM\\3sCR,GmS3z'R|'/\u001a\u0011\u0002-MKwM\\1ukJ,\u0017\t\\4pe&$\b.\u001c(b[\u0016\fqcU5h]\u0006$XO]3BY\u001e|'/\u001b;i[:\u000bW.\u001a\u0011\u0002)-+\u0017\u0010U1je\u0006cwm\u001c:ji\"lg*Y7f\u0003UYU-\u001f)bSJ\fEnZ8sSRDWNT1nK\u0002\n\u0001cS3z!\u0006L'oS3z\u0019\u0016tw\r\u001e5\u0016\u0005\u0005-\u0001cA \u0002\u000e%\u0019\u0011q\u0002!\u0003\u0007%sG/A\tLKf\u0004\u0016-\u001b:LKfdUM\\4uQ\u0002\nAbS3zgR|'/\u001a+za\u0016\fQbS3zgR|'/\u001a+za\u0016\u0004\u0013\u0001E6fsN$xN]3QCN\u001cxo\u001c:e\u0003EYW-_:u_J,\u0007+Y:to>\u0014H\rI\u0001\u0011M&dW-\u00138EKZlu\u000eZ3ESJ$2\u0001^A\u0010\u0011\u0019\t\tC\ta\u0001i\u0006Aa-\u001b7f]\u0006lW-\u0001\thK:,'/\u0019;f\u0017\u0016L8\u000b^8sKV\u0011\u0011q\u0005\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011Q\u00062\u0002\u0011M,7-\u001e:jifLA!!\r\u0002,\tA1*Z=Ti>\u0014X-A\u000ede\u0016\fG/Z*fY\u001a\u001c\u0016n\u001a8fI\u000e+'\u000f^5gS\u000e\fG/\u001a\u000b\u0005\u0003o\t\u0019\u0005\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\u0011\ti$a\u000b\u0002\t\r,'\u000f^\u0005\u0005\u0003\u0003\nYDA\bYkAJ4)\u001a:uS\u001aL7-\u0019;f\u0011\u001d\t)\u0005\na\u0001\u0003\u000f\nqa[3z!\u0006L'\u000f\u0005\u0003\u0002*\u0005%\u0013\u0002BA&\u0003W\u0011qaS3z!\u0006L'o\u0005\u0002&}Q\u0011\u0011\u0011\u000b\t\u0003w\u0015\na\u0001\\8hO\u0016\u0014XCAA,!\u0011\tI&a\u0018\u000e\u0005\u0005m#bAA/q\u0005\u0019\u0011\r]5\n\t\u0005\u0005\u00141\f\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005\u0019r-\u001a;LKf\u001cFo\u001c:f\r&dW\rU1uQR!\u0011\u0011NA;!\u0011\tY'!\u001d\u000e\u0005\u00055$bAA8E\u0006\u0011\u0011n\\\u0005\u0005\u0003g\niG\u0001\u0003GS2,\u0007bBA<S\u0001\u0007\u0011\u0011N\u0001\bCB\u0004\b+\u0019;i\u00039\u0019\bn\\;mI\u001e+g.\u001a:bi\u0016$B!! \u0002\u0004B\u0019q(a \n\u0007\u0005\u0005\u0005IA\u0004C_>dW-\u00198\t\u000f\u0005\u0015%\u00061\u0001\u0002j\u0005a1.Z=Ti>\u0014XMR5mK\u0006aAn\\1e\u0017\u0016L8\u000b^8sKR!\u0011qEAF\u0011\u001d\tii\u000ba\u0001\u0003S\nAAZ5mK\u0006\u00112-\u001a:uS\u001aL7-\u0019;f)>|w+Z1l)\u0011\ti(a%\t\u000f\u0005UE\u00061\u0001\u0002\u0018\u0006\t1\r\u0005\u0003\u0002:\u0005e\u0015\u0002BAN\u0003w\u00111bQ3si&4\u0017nY1uK\u0006q1M]3bi\u0016\\U-_*u_J,G\u0003BA\u0014\u0003CCq!a\u001e.\u0001\u0004\tI'A\u000fde\u0016\fG/Z&fsN$xN]3QCJ,g\u000e\u001e#je\u0016\u001cGo\u001c:z)\u0011\t9+!,\u0011\u0007}\nI+C\u0002\u0002,\u0002\u0013A!\u00168ji\"9\u0011q\u0016\u0018A\u0002\u0005%\u0014aC6fsN#xN]3ESJ\f\u0011c[3z\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z)\u0011\t),a2\u0011\t\u0005]\u00161Y\u0007\u0003\u0003sS1aMA^\u0015\u0011\ti,a0\u0002\u00079,GO\u0003\u0002\u0002B\u0006)!.\u0019<bq&!\u0011QYA]\u0005EYU-_'b]\u0006<WM\u001d$bGR|'/\u001f\u0005\b\u0003oz\u0003\u0019AA5\u00031\u0019Gn\\:f#VLW\r\u001e7z)\u0011\t9+!4\t\u000f\u0005=\u0007\u00071\u0001\u0002R\u0006I1\r\\8tK\u0006\u0014G.\u001a\t\u0005\u0003W\n\u0019.\u0003\u0003\u0002V\u00065$!C\"m_N,\u0017M\u00197f\u0001")
public final class FakeKeyStore {
    private final Logger logger = Logger$.MODULE$.apply(this.getClass());

    public static X509Certificate createSelfSignedCertificate(KeyPair keyPair) {
        return FakeKeyStore$.MODULE$.createSelfSignedCertificate(keyPair);
    }

    public static KeyStore generateKeyStore() {
        return FakeKeyStore$.MODULE$.generateKeyStore();
    }

    private Logger logger() {
        return this.logger;
    }

    public File getKeyStoreFilePath(File appPath) {
        return new File(appPath, FakeKeyStore$KeystoreSettings$.MODULE$.GeneratedKeyStore());
    }

    public boolean shouldGenerate(File keyStoreFile) {
        if (!keyStoreFile.exists()) {
            return true;
        }
        KeyStore store = this.loadKeyStore(keyStoreFile);
        return CollectionConverters$.MODULE$.EnumerationHasAsScala(store.aliases()).asScala().exists((Function1 & Serializable)alias -> BoxesRunTime.boxToBoolean((boolean)FakeKeyStore.$anonfun$shouldGenerate$1(this, store, alias)));
    }

    private KeyStore loadKeyStore(File file) {
        KeyStore keyStore = KeyStore.getInstance(FakeKeyStore$KeystoreSettings$.MODULE$.KeystoreType());
        InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
        try {
            keyStore.load(in, "".toCharArray());
        }
        finally {
            this.closeQuietly(in);
        }
        return keyStore;
    }

    public boolean certificateTooWeak(Certificate c) {
        X509Certificate x509Certificate;
        PublicKey publicKey = c.getPublicKey();
        if (!(publicKey instanceof RSAPublicKey)) {
            return true;
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
        RSAPublicKey key = rSAPublicKey;
        boolean weakKey = key.getModulus().bitLength() < FakeKeyStore$KeystoreSettings$.MODULE$.KeyPairKeyLength();
        Certificate certificate = c;
        boolean wrongSigAlg = certificate instanceof X509Certificate ? !(x509Certificate = (X509Certificate)certificate).getSigAlgName().equalsIgnoreCase(FakeKeyStore$KeystoreSettings$.MODULE$.SignatureAlgorithmName()) : true;
        return weakKey || wrongSigAlg;
    }

    public KeyStore createKeyStore(File appPath) {
        KeyStore keyStore;
        File keyStoreFile = this.getKeyStoreFilePath(appPath);
        File keyStoreDir = keyStoreFile.getParentFile();
        this.createKeystoreParentDirectory(keyStoreDir);
        FakeKeyStore fakeKeyStore = this;
        synchronized (fakeKeyStore) {
            KeyStore keyStore2;
            if (this.shouldGenerate(keyStoreFile)) {
                this.logger().info((Function0 & Serializable)() -> "Generating HTTPS key pair in " + keyStoreFile.getAbsolutePath() + " - this may take some time. If nothing happens, try moving the mouse/typing on the keyboard to generate some entropy.", MarkerContext$.MODULE$.NoMarker());
                KeyStore freshKeyStore = FakeKeyStore$.MODULE$.generateKeyStore();
                OutputStream out = Files.newOutputStream(keyStoreFile.toPath(), new OpenOption[0]);
                try {
                    freshKeyStore.store(out, FakeKeyStore$KeystoreSettings$.MODULE$.keystorePassword());
                }
                finally {
                    this.closeQuietly(out);
                }
                keyStore2 = freshKeyStore;
            } else {
                KeyStore loadedKeyStore = this.loadKeyStore(keyStoreFile);
                this.logger().info((Function0 & Serializable)() -> "HTTPS key pair generated in " + keyStoreFile.getAbsolutePath() + ".", MarkerContext$.MODULE$.NoMarker());
                keyStore2 = loadedKeyStore;
            }
            keyStore = keyStore2;
        }
        KeyStore keyStore3 = keyStore;
        return keyStore3;
    }

    private void createKeystoreParentDirectory(File keyStoreDir) {
        if (keyStoreDir.mkdirs()) {
            this.logger().debug((Function0 & Serializable)() -> "Parent directory for keystore successfully created at " + keyStoreDir.getAbsolutePath(), MarkerContext$.MODULE$.NoMarker());
            return;
        }
        if (keyStoreDir.exists() && keyStoreDir.isDirectory()) {
            this.logger().debug((Function0 & Serializable)() -> "No need to create " + keyStoreDir + " since it already exists.", MarkerContext$.MODULE$.NoMarker());
            return;
        }
        if (keyStoreDir.exists() && keyStoreDir.isFile()) {
            throw new IllegalStateException(keyStoreDir + " exists, but it is NOT a directory, making it not possible to generate a key store file.");
        }
        throw new IllegalStateException("Failed to create " + keyStoreDir + ". Check if there is permission to create such folder.");
    }

    public KeyManagerFactory keyManagerFactory(File appPath) {
        KeyStore keyStore = this.createKeyStore(appPath);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keyStore, FakeKeyStore$KeystoreSettings$.MODULE$.keystorePassword());
        return kmf;
    }

    public void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            this.logger().warn((Function0 & Serializable)() -> "Error closing stream. Cause: " + e, MarkerContext$.MODULE$.NoMarker());
        }
    }

    public static final /* synthetic */ boolean $anonfun$shouldGenerate$1(FakeKeyStore $this, KeyStore store$1, String alias) {
        return Option$.MODULE$.apply((Object)store$1.getCertificate(alias)).exists((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)$this.certificateTooWeak(c)));
    }
}

