/*
 * Decompiled with CFR 0.152.
 */
package play.core.server;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMemorySize;
import com.typesafe.config.ConfigValue;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.ChannelMatchers;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.unix.UnixChannelOption;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutor;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Sink;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.playframework.netty.HandlerPublisher;
import org.playframework.netty.http.HttpStreamsServerHandler;
import org.reactivestreams.Publisher;
import play.api.Application;
import play.api.BuiltInComponents;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.http.HttpProtocol$;
import play.api.internal.libs.concurrent.CoordinatedShutdownSupport$;
import play.api.mvc.Handler;
import play.api.mvc.RequestHeader;
import play.core.ApplicationProvider;
import play.core.NamedThreadFactory;
import play.core.NamedThreadFactory$;
import play.core.server.Jdk$;
import play.core.server.Native$;
import play.core.server.NettyServer$;
import play.core.server.NettyServerProvider;
import play.core.server.NettyTransport;
import play.core.server.Server;
import play.core.server.Server$;
import play.core.server.ServerConfig;
import play.core.server.ServerEndpoint;
import play.core.server.ServerEndpoint$;
import play.core.server.ServerEndpoints;
import play.core.server.ServerEndpoints$;
import play.core.server.ServerListenException;
import play.core.server.ServerStartException$;
import play.core.server.netty.NettyIdleHandler;
import play.core.server.netty.PlayRequestHandler;
import play.core.server.ssl.ServerSSLEngine$;
import play.server.SSLEngineProvider;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.deriving.Mirror;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public class NettyServer
implements Server {
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(NettyServer.class.getDeclaredField("Http1Encrypted$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(NettyServer.class.getDeclaredField("Http1Plain$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(NettyServer.class.getDeclaredField("mainAddress$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(NettyServer.class.getDeclaredField("sslEngineProvider$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(NettyServer.class.getDeclaredField("transport$lzy1"));
    private final ServerConfig config;
    private final ApplicationProvider applicationProvider;
    private final Function0<Future<?>> stopHook;
    private final ActorSystem actorSystem;
    private final Materializer materializer;
    private final Configuration nettyConfig;
    private final Option<String> serverHeader;
    private final int maxInitialLineLength;
    private final int maxHeaderSize;
    private final long maxContentLength;
    private final int maxChunkSize;
    private final boolean logWire;
    private final Config bootstrapOption;
    private final Config channelOption;
    private final boolean httpsWantClientAuth;
    private final boolean httpsNeedClientAuth;
    private final Duration httpIdleTimeout;
    private final Duration httpsIdleTimeout;
    private final FiniteDuration shutdownQuietPeriod;
    private final FiniteDuration terminationDelay;
    private final Option<FiniteDuration> terminationTimeout;
    private final int wsBufferLimit;
    private final String wsKeepAliveMode;
    private final Duration wsKeepAliveMaxIdle;
    private final boolean deferBodyParsing;
    private volatile Object transport$lzy1;
    private final MultithreadEventLoopGroup eventLoop;
    private final DefaultChannelGroup allChannels;
    private volatile Object sslEngineProvider$lzy1;
    private final Option<Channel> httpChannel;
    private final Option<Channel> httpsChannel;
    private volatile Object mainAddress$lzy1;
    private volatile Object Http1Plain$lzy1;
    private volatile Object Http1Encrypted$lzy1;
    private final ServerEndpoints serverEndpoints;

    public static NettyServer fromApplication(Application application, ServerConfig serverConfig) {
        return NettyServer$.MODULE$.fromApplication(application, serverConfig);
    }

    public static Server fromRouter(ServerConfig serverConfig, PartialFunction<RequestHeader, Handler> partialFunction) {
        return NettyServer$.MODULE$.fromRouter(serverConfig, partialFunction);
    }

    public static Server fromRouterWithComponents(ServerConfig serverConfig, Function1<BuiltInComponents, PartialFunction<RequestHeader, Handler>> function1) {
        return NettyServer$.MODULE$.fromRouterWithComponents(serverConfig, function1);
    }

    public static void main(String[] stringArray) {
        NettyServer$.MODULE$.main(stringArray);
    }

    public static NettyServerProvider provider() {
        return NettyServer$.MODULE$.provider();
    }

    public static ServerConfig fromRouter$default$1() {
        return NettyServer$.MODULE$.fromRouter$default$1();
    }

    public static ServerConfig fromRouterWithComponents$default$1() {
        return NettyServer$.MODULE$.fromRouterWithComponents$default$1();
    }

    public static ServerConfig fromApplication$default$2() {
        return NettyServer$.MODULE$.fromApplication$default$2();
    }

    public NettyServer(ServerConfig config, ApplicationProvider applicationProvider, Function0<Future<?>> stopHook, ActorSystem actorSystem, Materializer materializer) {
        EpollEventLoopGroup epollEventLoopGroup;
        this.config = config;
        this.applicationProvider = applicationProvider;
        this.stopHook = stopHook;
        this.actorSystem = actorSystem;
        this.materializer = materializer;
        this.initializeChannelOptionsStaticMembers();
        Configuration serverConfig = (Configuration)config.configuration().get("play.server", ConfigLoader$.MODULE$.configurationLoader());
        this.nettyConfig = (Configuration)serverConfig.get("netty", ConfigLoader$.MODULE$.configurationLoader());
        this.serverHeader = ((Option)this.nettyConfig.get("server-header", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(String x) {
                String string = x;
                String s = string;
                return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s));
            }

            public final Object applyOrElse(String x, Function1 function1) {
                String string = x;
                String s = string;
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s))) {
                    return s;
                }
                return function1.apply((Object)x);
            }
        });
        this.maxInitialLineLength = BoxesRunTime.unboxToInt((Object)this.nettyConfig.get("maxInitialLineLength", ConfigLoader$.MODULE$.intLoader()));
        this.maxHeaderSize = (int)((ConfigMemorySize)serverConfig.getDeprecated("max-header-size", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"netty.maxHeaderSize"}), ConfigLoader$.MODULE$.bytesLoader())).toBytes();
        this.maxContentLength = Server$.MODULE$.getPossiblyInfiniteBytes(serverConfig.underlying(), "max-content-length", Server$.MODULE$.getPossiblyInfiniteBytes$default$3());
        this.maxChunkSize = BoxesRunTime.unboxToInt((Object)this.nettyConfig.get("maxChunkSize", ConfigLoader$.MODULE$.intLoader()));
        int threadCount = BoxesRunTime.unboxToInt((Object)this.nettyConfig.get("eventLoopThreads", ConfigLoader$.MODULE$.intLoader()));
        this.logWire = BoxesRunTime.unboxToBoolean((Object)this.nettyConfig.get("log.wire", ConfigLoader$.MODULE$.booleanLoader()));
        this.bootstrapOption = (Config)this.nettyConfig.get("option", ConfigLoader$.MODULE$.configLoader());
        this.channelOption = (Config)this.nettyConfig.get("option.child", ConfigLoader$.MODULE$.configLoader());
        this.httpsWantClientAuth = BoxesRunTime.unboxToBoolean((Object)serverConfig.get("https.wantClientAuth", ConfigLoader$.MODULE$.booleanLoader()));
        this.httpsNeedClientAuth = BoxesRunTime.unboxToBoolean((Object)serverConfig.get("https.needClientAuth", ConfigLoader$.MODULE$.booleanLoader()));
        this.httpIdleTimeout = (Duration)serverConfig.get("http.idleTimeout", ConfigLoader$.MODULE$.durationLoader());
        this.httpsIdleTimeout = (Duration)serverConfig.get("https.idleTimeout", ConfigLoader$.MODULE$.durationLoader());
        this.shutdownQuietPeriod = (FiniteDuration)this.nettyConfig.get("shutdownQuietPeriod", ConfigLoader$.MODULE$.finiteDurationLoader());
        this.terminationDelay = (FiniteDuration)serverConfig.get("waitBeforeTermination", ConfigLoader$.MODULE$.finiteDurationLoader());
        this.terminationTimeout = serverConfig.getOptional("terminationTimeout", ConfigLoader$.MODULE$.finiteDurationLoader());
        this.wsBufferLimit = (int)((ConfigMemorySize)serverConfig.get("websocket.frame.maxLength", ConfigLoader$.MODULE$.bytesLoader())).toBytes();
        this.wsKeepAliveMode = (String)serverConfig.get("websocket.periodic-keep-alive-mode", ConfigLoader$.MODULE$.stringLoader());
        this.wsKeepAliveMaxIdle = (Duration)serverConfig.get("websocket.periodic-keep-alive-max-idle", ConfigLoader$.MODULE$.durationLoader());
        this.deferBodyParsing = serverConfig.underlying().getBoolean("deferBodyParsing");
        this.registerShutdownTasks();
        NamedThreadFactory threadFactory = NamedThreadFactory$.MODULE$.apply("netty-event-loop");
        NettyTransport nettyTransport = this.transport();
        if (Native$.MODULE$.equals(nettyTransport)) {
            epollEventLoopGroup = new EpollEventLoopGroup(threadCount, (ThreadFactory)threadFactory);
        } else if (Jdk$.MODULE$.equals(nettyTransport)) {
            epollEventLoopGroup = new NioEventLoopGroup(threadCount, (ThreadFactory)threadFactory);
        } else {
            throw new MatchError((Object)nettyTransport);
        }
        this.eventLoop = epollEventLoopGroup;
        this.allChannels = new DefaultChannelGroup((EventExecutor)this.eventLoop.next());
        this.httpChannel = config.port().map((Function1 & Serializable)_$2 -> this.$init$$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$2)));
        this.httpsChannel = config.sslPort().map((Function1 & Serializable)_$3 -> this.$init$$$anonfun$2(BoxesRunTime.unboxToInt((Object)_$3)));
        this.serverEndpoints = ServerEndpoints$.MODULE$.apply((scala.collection.immutable.Seq)Option$.MODULE$.option2Iterable(this.Http1Plain()).toSeq().$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(this.Http1Encrypted()).toSeq()));
    }

    public ApplicationProvider applicationProvider() {
        return this.applicationProvider;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public Materializer materializer() {
        return this.materializer;
    }

    private NettyTransport transport() {
        Object object = this.transport$lzy1;
        if (object instanceof NettyTransport) {
            return (NettyTransport)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (NettyTransport)this.transport$lzyINIT1();
    }

    private Object transport$lzyINIT1() {
        Object object;
        block11: {
            while (true) {
                if ((object = this.transport$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    NettyTransport nettyTransport = null;
                    try {
                        Mirror.Singleton singleton;
                        String string = (String)this.nettyConfig.get("transport", ConfigLoader$.MODULE$.stringLoader());
                        if ("native".equals(string)) {
                            singleton = Native$.MODULE$;
                        } else if ("jdk".equals(string)) {
                            singleton = Jdk$.MODULE$;
                        } else {
                            throw ServerStartException$.MODULE$.apply("Netty transport configuration value should be either jdk or native", ServerStartException$.MODULE$.$lessinit$greater$default$2());
                        }
                        nettyTransport = singleton;
                        object2 = nettyTransport == null ? LazyVals.NullValue$.MODULE$ : nettyTransport;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.transport$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.transport$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return nettyTransport;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block11;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Mode mode() {
        return this.config.mode();
    }

    private Option<SSLEngineProvider> sslEngineProvider() {
        Object object = this.sslEngineProvider$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.sslEngineProvider$lzyINIT1();
    }

    private Object sslEngineProvider$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.sslEngineProvider$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = this.liftedTree1$1();
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.sslEngineProvider$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private void setOptions(Function2<ChannelOption<Object>, Object, Object> setOption, Config config, boolean bootstrapping) {
        ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(config.entrySet()).asScala().filterNot((Function1 & Serializable)_$1 -> ((String)_$1.getKey()).startsWith("child."))).foreach((Function1 & Serializable)option -> {
            String cleanKey = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString((String)option.getKey()), "\"")), "\"");
            if (ChannelOption.exists((String)cleanKey)) {
                NettyServer$.play$core$server$NettyServer$$$logger.debug(() -> NettyServer.setOptions$$anonfun$2$$anonfun$1(bootstrapping, option, cleanKey), MarkerContext$.MODULE$.NoMarker());
                return setOption.apply((Object)ChannelOption.valueOf((String)cleanKey), NettyServer.unwrap$1((ConfigValue)option.getValue()));
            }
            NettyServer$.play$core$server$NettyServer$$$logger.warn(() -> NettyServer.setOptions$$anonfun$2$$anonfun$2(cleanKey), MarkerContext$.MODULE$.NoMarker());
            NettyTransport nettyTransport = this.transport();
            if (Native$.MODULE$.equals(nettyTransport)) {
                NettyServer$.play$core$server$NettyServer$$$logger.warn(NettyServer::setOptions$$anonfun$2$$anonfun$3, MarkerContext$.MODULE$.NoMarker());
            } else if (Jdk$.MODULE$.equals(nettyTransport)) {
                NettyServer$.play$core$server$NettyServer$$$logger.warn(NettyServer::setOptions$$anonfun$2$$anonfun$4, MarkerContext$.MODULE$.NoMarker());
            } else {
                throw new MatchError((Object)nettyTransport);
            }
            return BoxedUnit.UNIT;
        });
    }

    private boolean setOptions$default$3() {
        return false;
    }

    private Tuple2<Channel, Source<Channel, ?>> bind(InetSocketAddress address) {
        Class<EpollServerSocketChannel> clazz;
        EventLoop serverChannelEventLoop = this.eventLoop.next();
        HandlerPublisher channelPublisher = new HandlerPublisher((EventExecutor)serverChannelEventLoop, Channel.class);
        NettyTransport nettyTransport = this.transport();
        if (Native$.MODULE$.equals(nettyTransport)) {
            clazz = EpollServerSocketChannel.class;
        } else if (Jdk$.MODULE$.equals(nettyTransport)) {
            clazz = NioServerSocketChannel.class;
        } else {
            throw new MatchError((Object)nettyTransport);
        }
        Class<EpollServerSocketChannel> channelClass = clazz;
        Bootstrap bootstrap = (Bootstrap)new Bootstrap().channel(channelClass).group((EventLoopGroup)serverChannelEventLoop).option(ChannelOption.AUTO_READ, (Object)Boolean.FALSE).handler((ChannelHandler)channelPublisher).localAddress((SocketAddress)address);
        this.setOptions((Function2<ChannelOption<Object>, Object, Object>)(Function2 & Serializable)(x$0, x$1) -> bootstrap.option(x$0, x$1), this.bootstrapOption, true);
        Channel channel = bootstrap.bind().await().channel();
        this.allChannels.add(channel);
        return Tuple2$.MODULE$.apply((Object)channel, (Object)Source$.MODULE$.fromPublisher((Publisher)channelPublisher));
    }

    public ChannelInboundHandler newRequestHandler() {
        return new PlayRequestHandler(this, this.serverHeader, this.maxContentLength, this.wsBufferLimit, this.wsKeepAliveMode, this.wsKeepAliveMaxIdle, this.deferBodyParsing);
    }

    private Sink<Channel, Future<Done>> channelSink(int port, boolean secure) {
        return Sink$.MODULE$.foreach((Function1)(JProcedure1 & Serializable)connChannel -> {
            Option option;
            BoxedUnit boxedUnit;
            Duration idleTimeout;
            connChannel.config().setOption(ChannelOption.AUTO_READ, (Object)Boolean.FALSE);
            ChannelConfig channelConfig = connChannel.config();
            this.setOptions((Function2<ChannelOption<Object>, Object, Object>)(Function2 & Serializable)(x$0, x$1) -> BoxesRunTime.boxToBoolean((boolean)channelConfig.setOption(x$0, x$1)), this.channelOption, this.setOptions$default$3());
            ChannelPipeline pipeline = connChannel.pipeline();
            if (secure) {
                this.sslEngineProvider().map((Function1 & Serializable)sslEngineProvider -> {
                    SSLEngine sslEngine = sslEngineProvider.createSSLEngine();
                    sslEngine.setUseClientMode(false);
                    if (this.httpsWantClientAuth) {
                        sslEngine.setWantClientAuth(true);
                    }
                    if (this.httpsNeedClientAuth) {
                        sslEngine.setNeedClientAuth(true);
                    }
                    return pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                });
            }
            pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(this.maxInitialLineLength, this.maxHeaderSize, this.maxChunkSize));
            pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            pipeline.addLast("decompressor", (ChannelHandler)new HttpContentDecompressor());
            if (this.logWire) {
                pipeline.addLast("logging", (ChannelHandler)new LoggingHandler(LogLevel.DEBUG));
            }
            Duration duration = idleTimeout = secure ? this.httpsIdleTimeout : this.httpIdleTimeout;
            Duration.Infinite infinite = Duration$.MODULE$.Inf();
            Duration duration2 = duration;
            if (!(infinite != null ? !infinite.equals(duration2) : duration2 != null)) {
                boxedUnit = BoxedUnit.UNIT;
            } else if (duration != null && !(option = Duration$.MODULE$.unapply(duration)).isEmpty()) {
                Tuple2 tuple2 = (Tuple2)option.get();
                long timeout = BoxesRunTime.unboxToLong((Object)tuple2._1());
                TimeUnit timeUnit = (TimeUnit)((Object)((Object)tuple2._2()));
                NettyServer$.play$core$server$NettyServer$$$logger.trace(() -> NettyServer.channelSink$$anonfun$1$$anonfun$3(port, timeout, timeUnit), MarkerContext$.MODULE$.NoMarker());
                pipeline.addLast("idle-handler", (ChannelHandler)new IdleStateHandler(0L, 0L, timeout, timeUnit));
                boxedUnit = pipeline.addLast("idle-handler-play", (ChannelHandler)new NettyIdleHandler());
            } else {
                throw new MatchError((Object)duration);
            }
            ChannelInboundHandler requestHandler = this.newRequestHandler();
            pipeline.addLast("http-handler", (ChannelHandler)new HttpStreamsServerHandler(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ChannelHandler[]{requestHandler}))).asJava()));
            pipeline.addLast("request-handler", (ChannelHandler)requestHandler);
            EventLoop childChannelEventLoop = this.eventLoop.next();
            childChannelEventLoop.register(connChannel);
            this.allChannels.add(connChannel);
        });
    }

    private Channel bindChannel(int port, boolean secure) {
        String protocolName = secure ? "HTTPS" : "HTTP";
        InetSocketAddress address = new InetSocketAddress(this.config.address(), port);
        Tuple2<Channel, Source<Channel, ?>> tuple2 = this.bind(address);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Channel serverChannel = (Channel)tuple2._1();
        Source channelSource = (Source)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)serverChannel, (Object)channelSource);
        Channel serverChannel2 = (Channel)tuple22._1();
        Source channelSource2 = (Source)tuple22._2();
        channelSource2.runWith(this.channelSink(port, secure), this.materializer());
        SocketAddress boundAddress = serverChannel2.localAddress();
        if (boundAddress == null) {
            ServerListenException e = new ServerListenException(protocolName, (SocketAddress)address);
            NettyServer$.play$core$server$NettyServer$$$logger.error(() -> NettyServer.bindChannel$$anonfun$1(e), MarkerContext$.MODULE$.NoMarker());
            throw e;
        }
        Mode mode = this.mode();
        Mode.Test$ test$ = Mode.Test$.MODULE$;
        if (mode == null ? test$ != null : !mode.equals(test$)) {
            NettyServer$.play$core$server$NettyServer$$$logger.info(() -> NettyServer.bindChannel$$anonfun$2(protocolName, boundAddress), MarkerContext$.MODULE$.NoMarker());
        }
        return serverChannel2;
    }

    public void stop() {
        CoordinatedShutdownSupport$.MODULE$.syncShutdown(this.actorSystem(), (CoordinatedShutdown.Reason)Server.ServerStoppedReason$.MODULE$);
    }

    private void registerShutdownTasks() {
        ExecutionContextExecutor ctx = this.actorSystem().dispatcher();
        CoordinatedShutdown cs = (CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this.actorSystem());
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseBeforeServiceUnbind(), "trace-server-stop-request", (Function0 & Serializable)() -> {
            block0: {
                Mode mode = this.mode();
                if (Mode.Test$.MODULE$.equals(mode)) break block0;
                NettyServer$.play$core$server$NettyServer$$$logger.info(NettyServer::registerShutdownTasks$$anonfun$1$$anonfun$1, MarkerContext$.MODULE$.NoMarker());
            }
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        });
        FiniteDuration serverTerminateTimeout = Server$.MODULE$.determineServerTerminateTimeout(this.terminationTimeout, this.terminationDelay, this.actorSystem());
        FiniteDuration unbindTimeout = cs.timeout(CoordinatedShutdown$.MODULE$.PhaseServiceUnbind());
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseServiceUnbind(), "netty-server-unbind", (Function0 & Serializable)() -> {
            ChannelGroupFuture serverChannelGroupFuture = this.allChannels.close(ChannelMatchers.isServerChannel());
            Iterator serverChannelIterator = serverChannelGroupFuture.iterator();
            while (serverChannelIterator.hasNext()) {
                SocketAddress localAddress = ((ChannelFuture)serverChannelIterator.next()).channel().localAddress();
                NettyServer$.play$core$server$NettyServer$$$logger.info(() -> NettyServer.registerShutdownTasks$$anonfun$2$$anonfun$1(localAddress), MarkerContext$.MODULE$.NoMarker());
            }
            serverChannelGroupFuture.awaitUninterruptibly(unbindTimeout.toMillis() - 100L);
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        });
        FiniteDuration serviceRequestsDoneTimeout = cs.timeout(CoordinatedShutdown$.MODULE$.PhaseServiceRequestsDone());
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseServiceRequestsDone(), "netty-server-terminate", () -> this.registerShutdownTasks$$anonfun$3((ExecutionContext)ctx, serverTerminateTimeout, serviceRequestsDoneTimeout));
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseBeforeActorSystemTerminate(), "user-provided-server-stop-hook", () -> this.registerShutdownTasks$$anonfun$4((ExecutionContext)ctx));
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseBeforeActorSystemTerminate(), "shutdown-logger", () -> this.registerShutdownTasks$$anonfun$5((ExecutionContext)ctx));
    }

    private void initializeChannelOptionsStaticMembers() {
        package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelOption.class, UnixChannelOption.class, EpollChannelOption.class})).foreach((Function1 & Serializable)clazz -> {
            NettyServer$.play$core$server$NettyServer$$$logger.debug(() -> NettyServer.initializeChannelOptionsStaticMembers$$anonfun$1$$anonfun$1(clazz), MarkerContext$.MODULE$.NoMarker());
            return Class.forName(clazz.getName());
        });
    }

    public InetSocketAddress mainAddress() {
        Object object = this.mainAddress$lzy1;
        if (object instanceof InetSocketAddress) {
            return (InetSocketAddress)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (InetSocketAddress)this.mainAddress$lzyINIT1();
    }

    private Object mainAddress$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.mainAddress$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    InetSocketAddress inetSocketAddress = null;
                    try {
                        inetSocketAddress = (InetSocketAddress)((Channel)this.httpChannel.orElse(this::mainAddress$lzyINIT1$$anonfun$1).get()).localAddress();
                        object2 = inetSocketAddress == null ? LazyVals.NullValue$.MODULE$ : inetSocketAddress;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.mainAddress$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return inetSocketAddress;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Option<ServerEndpoint> Http1Plain() {
        Object object = this.Http1Plain$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.Http1Plain$lzyINIT1();
    }

    private Object Http1Plain$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Http1Plain$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = this.httpChannel.map((Function1 & Serializable)_$6 -> (InetSocketAddress)_$6.localAddress()).map((Function1 & Serializable)address -> ServerEndpoint$.MODULE$.apply("Netty HTTP/1.1 (plaintext)", "http", this.config.address(), address.getPort(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HttpProtocol$.MODULE$.HTTP_1_0(), HttpProtocol$.MODULE$.HTTP_1_1()})), this.serverHeader, (Option)None$.MODULE$));
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Http1Plain$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Option<ServerEndpoint> Http1Encrypted() {
        Object object = this.Http1Encrypted$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.Http1Encrypted$lzyINIT1();
    }

    private Object Http1Encrypted$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Http1Encrypted$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = this.httpsChannel.map((Function1 & Serializable)_$7 -> (InetSocketAddress)_$7.localAddress()).map((Function1 & Serializable)address -> ServerEndpoint$.MODULE$.apply("Netty HTTP/1.1 (encrypted)", "https", this.config.address(), address.getPort(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HttpProtocol$.MODULE$.HTTP_1_0(), HttpProtocol$.MODULE$.HTTP_1_1()})), this.serverHeader, this.sslEngineProvider().map((Function1 & Serializable)_$8 -> _$8.sslContext())));
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Http1Encrypted$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ServerEndpoints serverEndpoints() {
        return this.serverEndpoints;
    }

    private final /* synthetic */ Channel $init$$$anonfun$1(int _$2) {
        return this.bindChannel(_$2, false);
    }

    private final /* synthetic */ Channel $init$$$anonfun$2(int _$3) {
        return this.bindChannel(_$3, true);
    }

    private static final String liftedTree1$1$$anonfun$1() {
        return "cannot load SSL context";
    }

    private static final Throwable liftedTree1$1$$anonfun$2(Throwable e$1) {
        return e$1;
    }

    private final Option liftedTree1$1() {
        Some some;
        try {
            some = Some$.MODULE$.apply((Object)ServerSSLEngine$.MODULE$.createSSLEngineProvider(this.config, this.applicationProvider()));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                NettyServer$.play$core$server$NettyServer$$$logger.error(NettyServer::liftedTree1$1$$anonfun$1, () -> NettyServer.liftedTree1$1$$anonfun$2(e), MarkerContext$.MODULE$.NoMarker());
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    private static final Object unwrap$1(ConfigValue value) {
        Object object = value.unwrapped();
        if (object instanceof Number) {
            Number number = (Number)object;
            return BoxesRunTime.boxToInteger((int)number.intValue());
        }
        Object other = object;
        return other;
    }

    private static final String setOptions$$anonfun$2$$anonfun$1(boolean bootstrapping$1, Map.Entry option$1, String cleanKey$1) {
        return "Setting Netty channel option " + cleanKey$1 + " to " + NettyServer.unwrap$1((ConfigValue)option$1.getValue()) + (bootstrapping$1 ? " at bootstrapping" : "");
    }

    private static final String setOptions$$anonfun$2$$anonfun$2(String cleanKey$2) {
        return "Ignoring unknown Netty channel option: " + cleanKey$2;
    }

    private static final String setOptions$$anonfun$2$$anonfun$3() {
        return "Valid values can be found at http://netty.io/4.1/api/io/netty/channel/ChannelOption.html, https://netty.io/4.1/api/io/netty/channel/unix/UnixChannelOption.html and http://netty.io/4.1/api/io/netty/channel/epoll/EpollChannelOption.html";
    }

    private static final String setOptions$$anonfun$2$$anonfun$4() {
        return "Valid values can be found at http://netty.io/4.1/api/io/netty/channel/ChannelOption.html";
    }

    private static final String channelSink$$anonfun$1$$anonfun$3(int port$2, long timeout$1, TimeUnit timeUnit$1) {
        return "using idle timeout of " + timeout$1 + " " + timeUnit$1 + " on port " + port$2;
    }

    private static final String bindChannel$$anonfun$1(ServerListenException e$2) {
        return e$2.getMessage();
    }

    private static final String bindChannel$$anonfun$2(String protocolName$1, SocketAddress boundAddress$1) {
        return "Listening for " + protocolName$1 + " on " + boundAddress$1;
    }

    private static final String registerShutdownTasks$$anonfun$1$$anonfun$1() {
        return "Stopping server...";
    }

    private static final String registerShutdownTasks$$anonfun$2$$anonfun$1(SocketAddress localAddress$1) {
        return "Closing server channel " + localAddress$1;
    }

    private static final String registerShutdownTasks$$anonfun$3$$anonfun$1(SocketAddress localAddress$2) {
        return "Closing (non server) channel " + localAddress$2;
    }

    private static final String registerShutdownTasks$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$1() {
        return "Shutting down event loop";
    }

    private final boolean registerShutdownTasks$$anonfun$3$$anonfun$2$$anonfun$1(long remainingServiceRequestsDoneTimeout$2, long remainingServerTerminateTimeout$2) {
        NettyServer$.play$core$server$NettyServer$$$logger.info(NettyServer::registerShutdownTasks$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$1, MarkerContext$.MODULE$.NoMarker());
        return this.eventLoop.shutdownGracefully(this.shutdownQuietPeriod.toMillis(), remainingServerTerminateTimeout$2 - 100L, TimeUnit.MILLISECONDS).awaitUninterruptibly(remainingServiceRequestsDoneTimeout$2 - 100L);
    }

    private final Future registerShutdownTasks$$anonfun$3$$anonfun$2(ExecutionContext ctx$2, long remainingServiceRequestsDoneTimeout$1, long remainingServerTerminateTimeout$1) {
        return Future$.MODULE$.apply(() -> this.registerShutdownTasks$$anonfun$3$$anonfun$2$$anonfun$1(remainingServiceRequestsDoneTimeout$1, remainingServerTerminateTimeout$1), ctx$2);
    }

    private static final /* synthetic */ Done$ registerShutdownTasks$$anonfun$3$$anonfun$3(boolean _$4) {
        return Done$.MODULE$;
    }

    private final /* synthetic */ Future registerShutdownTasks$$anonfun$3(ExecutionContext ctx$1, FiniteDuration serverTerminateTimeout$1, FiniteDuration serviceRequestsDoneTimeout$1) {
        ChannelGroupFuture nonServerChannelGroupFuture = this.allChannels.close(ChannelMatchers.isNonServerChannel());
        Iterator nonServerChannelIterator = nonServerChannelGroupFuture.iterator();
        while (nonServerChannelIterator.hasNext()) {
            SocketAddress localAddress = ((ChannelFuture)nonServerChannelIterator.next()).channel().localAddress();
            NettyServer$.play$core$server$NettyServer$$$logger.info(() -> NettyServer.registerShutdownTasks$$anonfun$3$$anonfun$1(localAddress), MarkerContext$.MODULE$.NoMarker());
        }
        long startTime = System.currentTimeMillis();
        nonServerChannelGroupFuture.awaitUninterruptibly(serviceRequestsDoneTimeout$1.toMillis() - 100L);
        long elapsedTime = System.currentTimeMillis() - startTime;
        long remainingServiceRequestsDoneTimeout = serviceRequestsDoneTimeout$1.toMillis() - elapsedTime;
        long remainingServerTerminateTimeout = serverTerminateTimeout$1.toMillis() - elapsedTime;
        return org.apache.pekko.pattern.package$.MODULE$.after(this.terminationDelay, () -> this.registerShutdownTasks$$anonfun$3$$anonfun$2(ctx$1, remainingServiceRequestsDoneTimeout, remainingServerTerminateTimeout), (ClassicActorSystemProvider)this.actorSystem()).map((Function1 & Serializable)_$4 -> NettyServer.registerShutdownTasks$$anonfun$3$$anonfun$3(BoxesRunTime.unboxToBoolean((Object)_$4)), ctx$1);
    }

    private static final String registerShutdownTasks$$anonfun$4$$anonfun$1() {
        return "Running provided shutdown stop hooks";
    }

    private final /* synthetic */ Future registerShutdownTasks$$anonfun$4(ExecutionContext ctx$3) {
        NettyServer$.play$core$server$NettyServer$$$logger.info(NettyServer::registerShutdownTasks$$anonfun$4$$anonfun$1, MarkerContext$.MODULE$.NoMarker());
        return ((Future)this.stopHook.apply()).map((Function1 & Serializable)_$5 -> Done$.MODULE$, ctx$3);
    }

    private final Done$ registerShutdownTasks$$anonfun$5$$anonfun$1() {
        Server.stop$((Server)this);
        return Done$.MODULE$;
    }

    private final /* synthetic */ Future registerShutdownTasks$$anonfun$5(ExecutionContext ctx$4) {
        return Future$.MODULE$.apply(this::registerShutdownTasks$$anonfun$5$$anonfun$1, ctx$4);
    }

    private static final String initializeChannelOptionsStaticMembers$$anonfun$1$$anonfun$1(Class clazz$1) {
        return "Class " + clazz$1.getName() + " will be initialized (if it hasn't been initialized already)";
    }

    private final Option mainAddress$lzyINIT1$$anonfun$1() {
        return this.httpsChannel;
    }
}

