/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.evolutions;

import play.api.PlayException;
import play.api.db.evolutions.InconsistentDatabase$;
import scala.Product;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

public class InconsistentDatabase
extends PlayException.RichDescription
implements Product {
    private final String db;
    private final String script;
    private final String error;
    private final int rev;
    private final boolean autocommit;
    private final String redirectJavascript;
    private final String sentenceEnd;
    private final String buttonLabel;

    public static InconsistentDatabase apply(String string, String string2, String string3, int n, boolean bl) {
        return InconsistentDatabase$.MODULE$.apply(string, string2, string3, n, bl);
    }

    public static InconsistentDatabase fromProduct(Product product) {
        return InconsistentDatabase$.MODULE$.fromProduct(product);
    }

    public static InconsistentDatabase unapply(InconsistentDatabase inconsistentDatabase) {
        return InconsistentDatabase$.MODULE$.unapply(inconsistentDatabase);
    }

    public InconsistentDatabase(String db, String script, String error, int rev, boolean autocommit) {
        this.db = db;
        this.script = script;
        this.error = error;
        this.rev = rev;
        this.autocommit = autocommit;
        super("Database '" + db + "' is in an inconsistent state!", "An evolution has not been applied properly. Please check the problem and resolve it manually" + (autocommit ? " before marking it as resolved." : "."));
        String resolvePathJavascript = autocommit ? "'/@evolutions/resolve/" + db + "/" + rev + "?redirect=' + encodeURIComponent(window.location)" : "'/@evolutions'";
        this.redirectJavascript = "window.location = window.location.href.split(/[?#]/)[0].replace(/\\/@evolutions.*$|\\/$/, '') + " + resolvePathJavascript;
        this.sentenceEnd = autocommit ? " before marking it as resolved." : ".";
        this.buttonLabel = autocommit ? "Mark it resolved" : "Try again";
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.db()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.script()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.error()));
        n = Statics.mix((int)n, (int)this.rev());
        n = Statics.mix((int)n, (int)(this.autocommit() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof InconsistentDatabase)) return false;
        InconsistentDatabase inconsistentDatabase = (InconsistentDatabase)((Object)object);
        if (this.rev() != inconsistentDatabase.rev()) return false;
        if (this.autocommit() != inconsistentDatabase.autocommit()) return false;
        String string = this.db();
        String string2 = inconsistentDatabase.db();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.script();
        String string4 = inconsistentDatabase.script();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.error();
        String string6 = inconsistentDatabase.error();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        if (!inconsistentDatabase.canEqual((Object)this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof InconsistentDatabase;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "InconsistentDatabase";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this._4());
            }
            case 4: {
                return BoxesRunTime.boxToBoolean((boolean)this._5());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "db";
            }
            case 1: {
                return "script";
            }
            case 2: {
                return "error";
            }
            case 3: {
                return "rev";
            }
            case 4: {
                return "autocommit";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String db() {
        return this.db;
    }

    public String script() {
        return this.script;
    }

    public String error() {
        return this.error;
    }

    public int rev() {
        return this.rev;
    }

    public boolean autocommit() {
        return this.autocommit;
    }

    public String subTitle() {
        return "We got the following error: " + this.error() + ", while trying to run this SQL script:";
    }

    public String content() {
        return this.script();
    }

    public String htmlDescription() {
        NodeBuffer $buf = new NodeBuffer();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("An evolution has not been applied properly. Please check the problem and resolve it manually"));
        $buf2.$amp$plus((Object)this.sentenceEnd);
        $buf2.$amp$plus((Object)new Text(" -"));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("onclick", this.redirectJavascript, (MetaData)$md);
        $md = new UnprefixedAttribute("value", this.buttonLabel, (MetaData)$md);
        $md = new UnprefixedAttribute("type", (Seq)new Text("button"), (MetaData)$md);
        $md = new UnprefixedAttribute("name", (Seq)new Text("evolution-button"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "input", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        return $buf.mkString();
    }

    public InconsistentDatabase copy(String db, String script, String error, int rev, boolean autocommit) {
        return new InconsistentDatabase(db, script, error, rev, autocommit);
    }

    public String copy$default$1() {
        return this.db();
    }

    public String copy$default$2() {
        return this.script();
    }

    public String copy$default$3() {
        return this.error();
    }

    public int copy$default$4() {
        return this.rev();
    }

    public boolean copy$default$5() {
        return this.autocommit();
    }

    public String _1() {
        return this.db();
    }

    public String _2() {
        return this.script();
    }

    public String _3() {
        return this.error();
    }

    public int _4() {
        return this.rev();
    }

    public boolean _5() {
        return this.autocommit();
    }
}

