/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.evolutions;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import play.api.Environment;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.db.Database;
import play.api.db.evolutions.DatabaseEvolutions;
import play.api.db.evolutions.DownScript;
import play.api.db.evolutions.Evolution;
import play.api.db.evolutions.EvolutionsReader;
import play.api.db.evolutions.Script;
import play.api.db.evolutions.ThisClassLoaderEvolutionsReader$;
import play.api.db.evolutions.UpScript;
import play.utils.PlayIO$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Evolutions$ {
    public static final Evolutions$ MODULE$ = new Evolutions$();
    private static Charset utf8;
    private static final Logger logger;
    private static volatile boolean bitmap$0;

    static {
        logger = Logger$.MODULE$.apply(MODULE$.getClass());
    }

    private Logger logger() {
        return logger;
    }

    public String directoryName(String db, String path) {
        Path p = Path.of(path, new String[0]);
        if (p.startsWith(".") || p.startsWith("..") || p.isAbsolute()) {
            return path + "/" + db;
        }
        return "conf/" + path + "/" + db;
    }

    public String directoryName$default$2() {
        return "evolutions";
    }

    public String fileName(String db, int revision) {
        return this.fileName(db, revision, "evolutions");
    }

    public String fileName(String db, int revision, String path) {
        return this.fileName(db, Integer.toString(revision), path);
    }

    public String fileName(String db, String revision, String path) {
        return this.directoryName(db, path) + "/" + revision + ".sql";
    }

    public String fileName$default$3() {
        return "evolutions";
    }

    public String resourceName(String db, int revision) {
        return this.resourceName(db, revision, "evolutions");
    }

    public String resourceName(String db, int revision, String path) {
        return this.resourceName(db, Integer.toString(revision), path);
    }

    public String resourceName(String db, String revision, String path) {
        return path + "/" + db + "/" + revision + ".sql";
    }

    public String resourceName$default$3() {
        return "evolutions";
    }

    public void updateEvolutionScript(String db, String path, int revision, String comment, String ups, String downs, Environment environment) {
        File evolutions = environment.getFile(this.fileName(db, revision, path));
        Files.createDirectory(environment.getFile(this.directoryName(db, path)).toPath(), new FileAttribute[0]);
        this.writeFileIfChanged(evolutions, StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|-- %s\n         |\n         |-- !Ups\n         |%s\n         |\n         |-- !Downs\n         |%s\n         |\n         |"))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{comment, ups, downs})));
    }

    public String updateEvolutionScript$default$1() {
        return "default";
    }

    public String updateEvolutionScript$default$2() {
        return "evolutions";
    }

    public int updateEvolutionScript$default$3() {
        return 1;
    }

    public String updateEvolutionScript$default$4() {
        return "Generated";
    }

    private void writeFileIfChanged(File path, String content) {
        String string = content;
        String string2 = PlayIO$.MODULE$.readFileAsString(path.toPath(), Codec$.MODULE$.fallbackSystemCodec());
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.writeFile(path, content);
            return;
        }
    }

    private void writeFile(File destination, String content) {
        Files.write(destination.toPath(), content.getBytes(this.utf8()), new OpenOption[0]);
    }

    private Charset utf8$lzycompute() {
        Evolutions$ evolutions$ = this;
        synchronized (evolutions$) {
            if (!bitmap$0) {
                utf8 = Charset.forName("UTF8");
                bitmap$0 = true;
            }
        }
        return utf8;
    }

    private Charset utf8() {
        if (!bitmap$0) {
            return this.utf8$lzycompute();
        }
        return utf8;
    }

    public String toHumanReadableScript(Seq<Script> scripts) {
        String txt = ((IterableOnceOps)scripts.map((Function1 & Serializable)x0$1 -> {
            Script script = x0$1;
            if (script instanceof UpScript) {
                UpScript upScript = (UpScript)script;
                Evolution ev = upScript.evolution();
                return "-- Rev:" + ev.revision() + ",Ups - " + StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(ev.hash()), 7) + "\n" + ev.sql_up() + "\n";
            }
            if (script instanceof DownScript) {
                DownScript downScript = (DownScript)script;
                Evolution ev = downScript.evolution();
                return "-- Rev:" + ev.revision() + ",Downs - " + StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(ev.hash()), 7) + "\n" + ev.sql_down() + "\n";
            }
            throw new MatchError((Object)script);
        })).mkString("\n");
        String hasDownWarning = "-- !!! WARNING! This script contains DOWNS evolutions that are likely destructive\n\n";
        if (scripts.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Evolutions$.$anonfun$toHumanReadableScript$2(x$3)))) {
            return hasDownWarning + txt;
        }
        return txt;
    }

    public Tuple2<Seq<Evolution>, Seq<Evolution>> conflictings(Seq<Evolution> downs, Seq<Evolution> ups) {
        return ((IterableOps)((SeqOps)((IterableOps)((SeqOps)downs.zip(ups)).reverse()).dropWhile((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Evolutions$.$anonfun$conflictings$1(x0$1)))).reverse()).unzip(Predef$.MODULE$.$conforms());
    }

    public void applyEvolutions(Database database, EvolutionsReader evolutionsReader, boolean autocommit, String schema, String metaTable, Map<String, String> substitutionsMappings, String substitutionsPrefix, String substitutionsSuffix, boolean substitutionsEscape) {
        DatabaseEvolutions dbEvolutions = new DatabaseEvolutions(database, schema, metaTable, substitutionsMappings, substitutionsPrefix, substitutionsSuffix, substitutionsEscape);
        Seq<Script> evolutions = dbEvolutions.scripts(evolutionsReader);
        dbEvolutions.evolve(evolutions, autocommit);
    }

    public EvolutionsReader applyEvolutions$default$2() {
        return ThisClassLoaderEvolutionsReader$.MODULE$;
    }

    public boolean applyEvolutions$default$3() {
        return true;
    }

    public String applyEvolutions$default$4() {
        return "";
    }

    public String applyEvolutions$default$5() {
        return "play_evolutions";
    }

    public Map<String, String> applyEvolutions$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    public String applyEvolutions$default$7() {
        return "$evolutions{{{";
    }

    public String applyEvolutions$default$8() {
        return "}}}";
    }

    public boolean applyEvolutions$default$9() {
        return true;
    }

    public void cleanupEvolutions(Database database, boolean autocommit, String schema, String metaTable, Map<String, String> substitutionsMappings, String substitutionsPrefix, String substitutionsSuffix, boolean substitutionsEscape) {
        DatabaseEvolutions dbEvolutions = new DatabaseEvolutions(database, schema, metaTable, substitutionsMappings, substitutionsPrefix, substitutionsSuffix, substitutionsEscape);
        Seq<Script> evolutions = dbEvolutions.resetScripts();
        dbEvolutions.evolve(evolutions, autocommit);
    }

    public boolean cleanupEvolutions$default$2() {
        return true;
    }

    public String cleanupEvolutions$default$3() {
        return "";
    }

    public String cleanupEvolutions$default$4() {
        return "play_evolutions";
    }

    public Map<String, String> cleanupEvolutions$default$5() {
        return Predef$.MODULE$.Map().empty();
    }

    public String cleanupEvolutions$default$6() {
        return "$evolutions{{{";
    }

    public String cleanupEvolutions$default$7() {
        return "}}}";
    }

    public boolean cleanupEvolutions$default$8() {
        return true;
    }

    public <T> T withEvolutions(Database database, EvolutionsReader evolutionsReader, boolean autocommit, String schema, String metaTable, Map<String, String> substitutionsMappings, String substitutionsPrefix, String substitutionsSuffix, boolean substitutionsEscape, Function0<T> block) {
        Object object;
        this.applyEvolutions(database, evolutionsReader, autocommit, schema, metaTable, substitutionsMappings, substitutionsPrefix, substitutionsSuffix, substitutionsEscape);
        try {
            object = block.apply();
        }
        catch (Throwable throwable) {
            try {
                this.cleanupEvolutions(database, autocommit, schema, metaTable, substitutionsMappings, substitutionsPrefix, substitutionsSuffix, substitutionsEscape);
            }
            catch (Exception e) {
                this.logger().warn((Function0 & Serializable)() -> "Error resetting evolutions", (Function0 & Serializable)() -> e, MarkerContext$.MODULE$.NoMarker());
            }
            throw throwable;
        }
        Object object2 = object;
        try {
            this.cleanupEvolutions(database, autocommit, schema, metaTable, substitutionsMappings, substitutionsPrefix, substitutionsSuffix, substitutionsEscape);
        }
        catch (Exception e) {
            this.logger().warn((Function0 & Serializable)() -> "Error resetting evolutions", (Function0 & Serializable)() -> e, MarkerContext$.MODULE$.NoMarker());
        }
        return (T)object2;
    }

    public <T> EvolutionsReader withEvolutions$default$2() {
        return ThisClassLoaderEvolutionsReader$.MODULE$;
    }

    public <T> boolean withEvolutions$default$3() {
        return true;
    }

    public <T> String withEvolutions$default$4() {
        return "";
    }

    public <T> String withEvolutions$default$5() {
        return "play_evolutions";
    }

    public <T> Map<String, String> withEvolutions$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    public <T> String withEvolutions$default$7() {
        return "$evolutions{{{";
    }

    public <T> String withEvolutions$default$8() {
        return "}}}";
    }

    public <T> boolean withEvolutions$default$9() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$toHumanReadableScript$2(Script x$3) {
        return x$3 instanceof DownScript;
    }

    public static final /* synthetic */ boolean $anonfun$conflictings$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Evolution down = (Evolution)tuple2._1();
            Evolution up = (Evolution)tuple2._2();
            String string = down.hash();
            String string2 = up.hash();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    private Evolutions$() {
    }
}

