/*
 * Decompiled with CFR 0.152.
 */
package play.db.jpa;

import com.typesafe.config.Config;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Persistence;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.db.DBApi;
import play.db.jpa.JPAApi;
import play.db.jpa.JPAConfig;
import play.inject.ApplicationLifecycle;

public class DefaultJPAApi
implements JPAApi {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJPAApi.class);
    private final JPAConfig jpaConfig;
    private final Map<String, EntityManagerFactory> emfs = new HashMap<String, EntityManagerFactory>();

    public DefaultJPAApi(JPAConfig jPAConfig) {
        this.jpaConfig = jPAConfig;
    }

    @Override
    public JPAApi start() {
        this.jpaConfig.persistenceUnits().forEach(persistenceUnit -> this.emfs.put(persistenceUnit.name, Persistence.createEntityManagerFactory((String)persistenceUnit.unitName)));
        return this;
    }

    @Override
    public EntityManager em(String string) {
        EntityManagerFactory entityManagerFactory = this.emfs.get(string);
        if (entityManagerFactory == null) {
            return null;
        }
        return entityManagerFactory.createEntityManager();
    }

    @Override
    public <T> T withTransaction(Function<EntityManager, T> function) {
        return this.withTransaction("default", function);
    }

    @Override
    public void withTransaction(Consumer<EntityManager> consumer) {
        this.withTransaction((EntityManager entityManager) -> {
            consumer.accept((EntityManager)entityManager);
            return null;
        });
    }

    @Override
    public <T> T withTransaction(String string, Function<EntityManager, T> function) {
        return this.withTransaction(string, false, function);
    }

    @Override
    public void withTransaction(String string, Consumer<EntityManager> consumer) {
        this.withTransaction(string, (EntityManager entityManager) -> {
            consumer.accept((EntityManager)entityManager);
            return null;
        });
    }

    @Override
    public <T> T withTransaction(String string, boolean bl, Function<EntityManager, T> function) {
        EntityTransaction entityTransaction = null;
        try (EntityManager entityManager = null;){
            entityManager = this.em(string);
            if (entityManager == null) {
                throw new RuntimeException("Could not create JPA entity manager for '" + string + "'");
            }
            if (!bl) {
                entityTransaction = entityManager.getTransaction();
                entityTransaction.begin();
            }
            T t = function.apply(entityManager);
            if (entityTransaction != null) {
                if (entityTransaction.getRollbackOnly()) {
                    entityTransaction.rollback();
                } else {
                    entityTransaction.commit();
                }
            }
            T t2 = t;
            return t2;
        }
    }

    @Override
    public void withTransaction(String string, boolean bl, Consumer<EntityManager> consumer) {
        this.withTransaction(string, bl, (EntityManager entityManager) -> {
            consumer.accept((EntityManager)entityManager);
            return null;
        });
    }

    @Override
    public void shutdown() {
        this.emfs.values().forEach(EntityManagerFactory::close);
    }

    @Singleton
    public static class JPAApiProvider
    implements Provider<JPAApi> {
        private final JPAApi jpaApi;

        @Deprecated
        public JPAApiProvider(JPAConfig jPAConfig, ApplicationLifecycle applicationLifecycle, DBApi dBApi, Config config) {
            this(jPAConfig, applicationLifecycle, dBApi);
        }

        @Inject
        public JPAApiProvider(JPAConfig jPAConfig, ApplicationLifecycle applicationLifecycle, DBApi dBApi) {
            this.jpaApi = new DefaultJPAApi(jPAConfig);
            applicationLifecycle.addStopHook(() -> {
                this.jpaApi.shutdown();
                return CompletableFuture.completedFuture(null);
            });
            this.jpaApi.start();
        }

        public JPAApi get() {
            return this.jpaApi;
        }
    }
}

