/*
 * Decompiled with CFR 0.152.
 */
package play.db.ebean;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EbeanParsedConfig {
    private final String defaultDatasource;
    private final Map<String, List<String>> datasourceModels;
    private final boolean generateEvolutionsScripts;

    public EbeanParsedConfig(String string, Map<String, List<String>> map, boolean bl) {
        this.defaultDatasource = string;
        this.datasourceModels = map;
        this.generateEvolutionsScripts = bl;
    }

    public EbeanParsedConfig(String string, Map<String, List<String>> map) {
        this(string, map, true);
    }

    public String getDefaultDatasource() {
        return this.defaultDatasource;
    }

    public Map<String, List<String>> getDatasourceModels() {
        return this.datasourceModels;
    }

    public boolean generateEvolutionsScripts() {
        return this.generateEvolutionsScripts;
    }

    public static EbeanParsedConfig parseFromConfig(Config config) {
        Config config2 = config.getConfig("play.ebean");
        String string2 = config2.getString("defaultDatasource");
        String string3 = config2.getString("config");
        boolean bl = config2.getBoolean("generateEvolutionsScripts");
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (config.hasPath(string3)) {
            Config config3 = config.getConfig(string3);
            config3.root().forEach((string, configValue) -> {
                List<String> list = configValue.valueType() == ConfigValueType.STRING ? Arrays.asList(((String)configValue.unwrapped()).split(",")) : config3.getStringList(string);
                hashMap.put((String)string, list);
            });
        }
        return new EbeanParsedConfig(string2, hashMap, bl);
    }
}

