/*
 * Decompiled with CFR 0.152.
 */
package play.cache;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.Done;
import play.cache.AsyncCacheApi;
import play.cache.SyncCacheApi;
import play.cache.SyncCacheApiAdapter;
import play.libs.Scala;
import scala.concurrent.duration.Duration;
import scala.jdk.javaapi.FutureConverters;
import scala.jdk.javaapi.OptionConverters;

@Singleton
public class DefaultAsyncCacheApi
implements AsyncCacheApi {
    private final play.api.cache.AsyncCacheApi asyncCacheApi;

    @Inject
    public DefaultAsyncCacheApi(play.api.cache.AsyncCacheApi asyncCacheApi) {
        this.asyncCacheApi = asyncCacheApi;
    }

    @Override
    public SyncCacheApi sync() {
        return new SyncCacheApiAdapter(this.asyncCacheApi.sync());
    }

    @Override
    public <T> CompletionStage<Optional<T>> get(String string) {
        return FutureConverters.asJava(this.asyncCacheApi.get(string, Scala.classTag())).thenApply(OptionConverters::toJava);
    }

    @Override
    public <T> CompletionStage<T> getOrElseUpdate(String string, Callable<CompletionStage<T>> callable, int n) {
        return FutureConverters.asJava(this.asyncCacheApi.getOrElseUpdate(string, this.intToDuration(n), Scala.asScalaWithFuture(callable), Scala.classTag()));
    }

    @Override
    public <T> CompletionStage<T> getOrElseUpdate(String string, Callable<CompletionStage<T>> callable) {
        return FutureConverters.asJava(this.asyncCacheApi.getOrElseUpdate(string, (Duration)Duration.Inf(), Scala.asScalaWithFuture(callable), Scala.classTag()));
    }

    @Override
    public CompletionStage<Done> set(String string, Object object, int n) {
        return FutureConverters.asJava(this.asyncCacheApi.set(string, object, this.intToDuration(n)));
    }

    @Override
    public CompletionStage<Done> set(String string, Object object) {
        return FutureConverters.asJava(this.asyncCacheApi.set(string, object, (Duration)Duration.Inf()));
    }

    @Override
    public CompletionStage<Done> remove(String string) {
        return FutureConverters.asJava(this.asyncCacheApi.remove(string));
    }

    @Override
    public CompletionStage<Done> removeAll() {
        return FutureConverters.asJava(this.asyncCacheApi.removeAll());
    }

    private Duration intToDuration(int n) {
        return n == 0 ? Duration.Inf() : Duration.apply((long)n, (TimeUnit)TimeUnit.SECONDS);
    }
}

