/*
 * Decompiled with CFR 0.152.
 */
package play.api.cache;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import play.api.cache.SerializableResult$;
import play.api.http.HttpEntity;
import play.api.mvc.ResponseHeader$;
import play.api.mvc.Result;
import play.api.mvc.Result$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005\t4Q\u0001E\t\u0003+]A\u0001B\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006]\u0001!\ta\f\u0005\u0006]\u0001!\ta\r\u0005\bi\u0001\u0001\r\u0011\"\u00036\u0011\u001d1\u0004\u00011A\u0005\n]Ba\u0001\u0011\u0001!B\u0013A\u0003\"B!\u0001\t\u0003)\u0004\"\u0002\"\u0001\t\u0003\u001a\u0005\"B%\u0001\t\u0003RuA\u0002)\u0012\u0011\u0003)\u0012K\u0002\u0004\u0011#!\u0005QC\u0015\u0005\u0006]-!\t!\u0017\u0005\b5.\u0011\r\u0011\"\u0001\\\u0011\u0019y6\u0002)A\u00059\"9\u0001mCA\u0001\n\u0013\t'AE*fe&\fG.\u001b>bE2,'+Z:vYRT!AE\n\u0002\u000b\r\f7\r[3\u000b\u0005Q)\u0012aA1qS*\ta#\u0001\u0003qY\u0006L8c\u0001\u0001\u0019AA\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\u0005Y\u0006twMC\u0001\u001e\u0003\u0011Q\u0017M^1\n\u0005}Q\"AB(cU\u0016\u001cG\u000f\u0005\u0002\"I5\t!E\u0003\u0002$9\u0005\u0011\u0011n\\\u0005\u0003K\t\u0012a\"\u0012=uKJt\u0017\r\\5{C\ndW-A\td_:\u001cHO];di>\u0014(+Z:vYR\u001c\u0001\u0001\u0005\u0002*Y5\t!F\u0003\u0002,'\u0005\u0019QN^2\n\u00055R#A\u0002*fgVdG/\u0001\u0004=S:LGO\u0010\u000b\u0003aI\u0002\"!\r\u0001\u000e\u0003EAQA\n\u0002A\u0002!\"\u0012\u0001M\u0001\rG\u0006\u001c\u0007.\u001a3SKN,H\u000e^\u000b\u0002Q\u0005\u00012-Y2iK\u0012\u0014Vm];mi~#S-\u001d\u000b\u0003qy\u0002\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012A!\u00168ji\"9q(BA\u0001\u0002\u0004A\u0013a\u0001=%c\u0005i1-Y2iK\u0012\u0014Vm];mi\u0002\naA]3tk2$\u0018\u0001\u0004:fC\u0012,\u0005\u0010^3s]\u0006dGC\u0001\u001dE\u0011\u0015)\u0005\u00021\u0001G\u0003\tIg\u000e\u0005\u0002\"\u000f&\u0011\u0001J\t\u0002\f\u001f\nTWm\u0019;J]B,H/A\u0007xe&$X-\u0012=uKJt\u0017\r\u001c\u000b\u0003q-CQ\u0001T\u0005A\u00025\u000b1a\\;u!\t\tc*\u0003\u0002PE\taqJ\u00196fGR|U\u000f\u001e9vi\u0006\u00112+\u001a:jC2L'0\u00192mKJ+7/\u001e7u!\t\t4bE\u0002\f'Z\u0003\"!\u000f+\n\u0005US$AB!osJ+g\r\u0005\u0002\"/&\u0011\u0001L\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0002#\u0006yQM\\2pI&twMV3sg&|g.F\u0001]!\tIT,\u0003\u0002_u\t!!)\u001f;f\u0003A)gnY8eS:<g+\u001a:tS>t\u0007%\u0001\u0007xe&$XMU3qY\u0006\u001cW\rF\u0001\u0019\u0001")
public final class SerializableResult
implements Externalizable {
    private Result cachedResult;

    public static byte encodingVersion() {
        return SerializableResult$.MODULE$.encodingVersion();
    }

    private Result cachedResult() {
        return this.cachedResult;
    }

    private void cachedResult_$eq(Result x$1) {
        this.cachedResult = x$1;
    }

    public Result result() {
        Predef$.MODULE$.assert(this.cachedResult() != null, (Function0 & Serializable)() -> "Result should have been provided in constructor or when deserializing");
        return this.cachedResult();
    }

    @Override
    public void readExternal(ObjectInput in) {
        Predef$.MODULE$.assert(in.readByte() == SerializableResult$.MODULE$.encodingVersion(), (Function0 & Serializable)() -> "Result was serialised from a different version of Play");
        int status = in.readInt();
        int headerLength = in.readInt();
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), headerLength).foreach((Function1 & Serializable)x$2 -> SerializableResult.$anonfun$readExternal$2(in, mapBuilder, BoxesRunTime.unboxToInt((Object)x$2)));
        Map headerMap = (Map)mapBuilder.result();
        boolean hasContentType = in.readBoolean();
        None$ contentType = hasContentType ? new Some((Object)in.readUTF()) : None$.MODULE$;
        int sizeOfBody = in.readInt();
        byte[] buffer = new byte[sizeOfBody];
        this.readBytes$1(0, sizeOfBody, in, buffer);
        HttpEntity.Strict body = new HttpEntity.Strict(ByteString$.MODULE$.fromArrayUnsafe(buffer), (Option)contentType);
        this.cachedResult_$eq(new Result(ResponseHeader$.MODULE$.apply(status, headerMap, ResponseHeader$.MODULE$.apply$default$3()), (HttpEntity)body, Result$.MODULE$.apply$default$3(), Result$.MODULE$.apply$default$4(), Result$.MODULE$.apply$default$5(), Result$.MODULE$.apply$default$6()));
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        out.writeByte(SerializableResult$.MODULE$.encodingVersion());
        out.writeInt(this.cachedResult().header().status());
        Map headerMap = this.cachedResult().header().headers();
        out.writeInt(headerMap.size());
        headerMap.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SerializableResult.$anonfun$writeExternal$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            SerializableResult.$anonfun$writeExternal$2(out, x$3);
            return BoxedUnit.UNIT;
        });
        out.writeBoolean(this.cachedResult().body().contentType().nonEmpty());
        this.cachedResult().body().contentType().foreach((Function1 & Serializable)ct -> {
            out.writeUTF(ct);
            return BoxedUnit.UNIT;
        });
        HttpEntity httpEntity = this.cachedResult().body();
        if (!(httpEntity instanceof HttpEntity.Strict)) {
            throw new IllegalStateException("Non strict body cannot be materialized");
        }
        HttpEntity.Strict strict = (HttpEntity.Strict)httpEntity;
        ByteString data = strict.data();
        ByteString body = data;
        out.writeInt(body.length());
        out.write(body.toArrayUnsafe());
    }

    public static final /* synthetic */ boolean $anonfun$new$1(Result x$1) {
        return x$1.body() instanceof HttpEntity.Strict;
    }

    public static final /* synthetic */ Builder $anonfun$readExternal$2(ObjectInput in$1, Builder mapBuilder$1, int x$2) {
        int n = x$2;
        String name = in$1.readUTF();
        String value = in$1.readUTF();
        return (Builder)mapBuilder$1.$plus$eq((Object)new Tuple2((Object)name, (Object)value));
    }

    private final void readBytes$1(int offset, int length, ObjectInput in$1, byte[] buffer$1) {
        while (length > 0) {
            int readLength = in$1.read(buffer$1, offset, length);
            length -= readLength;
            offset += readLength;
        }
    }

    public static final /* synthetic */ boolean $anonfun$writeExternal$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$writeExternal$2(ObjectOutput out$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            String value = (String)tuple2._2();
            out$1.writeUTF(name);
            out$1.writeUTF(value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public SerializableResult(Result constructorResult) {
        Predef$.MODULE$.assert(Option$.MODULE$.apply((Object)constructorResult).forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SerializableResult.$anonfun$new$1(x$1))), (Function0 & Serializable)() -> "Only strict entities can be cached, streamed entities cannot be cached");
        this.cachedResult = constructorResult;
    }

    public SerializableResult() {
        this(null);
    }
}

