/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.java.tracking;

import java.io.IOException;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.piwik.java.tracking.PiwikRequest;

public class PiwikTracker {
    private static final String AUTH_TOKEN = "token_auth";
    private static final String REQUESTS = "requests";
    private final UriBuilder uriBuilder;
    private String proxyHost = null;
    private int proxyPort = 0;

    public PiwikTracker(String hostUrl) {
        this.uriBuilder = UriBuilder.fromPath((String)hostUrl);
    }

    public PiwikTracker(String hostUrl, String proxyHost, int proxyPort) {
        this.uriBuilder = UriBuilder.fromPath((String)hostUrl);
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public HttpResponse sendRequest(PiwikRequest request) throws IOException {
        HttpClient client = this.getHttpClient();
        this.uriBuilder.replaceQuery(request.getUrlEncodedQueryString());
        HttpGet get = new HttpGet(this.uriBuilder.build(new Object[0]));
        return client.execute((HttpUriRequest)get);
    }

    public HttpResponse sendBulkRequest(Iterable<PiwikRequest> requests) throws IOException {
        return this.sendBulkRequest(requests, null);
    }

    public HttpResponse sendBulkRequest(Iterable<PiwikRequest> requests, String authToken) throws IOException {
        if (authToken != null && authToken.length() != 32) {
            throw new IllegalArgumentException(authToken + " is not " + 32 + " characters long.");
        }
        JsonObjectBuilder ob = Json.createObjectBuilder();
        JsonArrayBuilder ab = Json.createArrayBuilder();
        for (PiwikRequest request : requests) {
            ab.add("?" + request.getQueryString());
        }
        ob.add(REQUESTS, ab);
        if (authToken != null) {
            ob.add(AUTH_TOKEN, authToken);
        }
        HttpClient client = this.getHttpClient();
        HttpPost post = new HttpPost(this.uriBuilder.build(new Object[0]));
        post.setEntity((HttpEntity)new StringEntity(ob.build().toString(), ContentType.APPLICATION_JSON));
        return client.execute((HttpUriRequest)post);
    }

    protected HttpClient getHttpClient() {
        CloseableHttpClient client;
        if (this.proxyHost != null && this.proxyPort != 0) {
            HttpHost proxy = new HttpHost(this.proxyHost, this.proxyPort);
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            client = HttpClientBuilder.create().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
        } else {
            client = HttpClientBuilder.create().build();
        }
        return client;
    }
}

