/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.java.tracking;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import org.piwik.java.tracking.CustomVariable;

class CustomVariableList {
    private final Map<Integer, CustomVariable> map = new HashMap<Integer, CustomVariable>();

    CustomVariableList() {
    }

    void add(CustomVariable cv) {
        boolean found = false;
        for (Map.Entry<Integer, CustomVariable> entry : this.map.entrySet()) {
            if (!entry.getValue().getKey().equals(cv.getKey())) continue;
            this.map.put(entry.getKey(), cv);
            found = true;
        }
        if (!found) {
            int i = 1;
            while (this.map.putIfAbsent(i++, cv) != null) {
            }
        }
    }

    void add(CustomVariable cv, int index) {
        if (index <= 0) {
            throw new IllegalArgumentException("Index must be greater than 0.");
        }
        this.map.put(index, cv);
    }

    CustomVariable get(int index) {
        if (index <= 0) {
            throw new IllegalArgumentException("Index must be greater than 0.");
        }
        return this.map.get(index);
    }

    String get(String key) {
        Iterator<Map.Entry<Integer, CustomVariable>> i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            CustomVariable value = i.next().getValue();
            if (!value.getKey().equals(key)) continue;
            return value.getValue();
        }
        return null;
    }

    void remove(int index) {
        this.map.remove(index);
    }

    void remove(String key) {
        Iterator<Map.Entry<Integer, CustomVariable>> i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Integer, CustomVariable> entry = i.next();
            if (!entry.getValue().getKey().equals(key)) continue;
            i.remove();
        }
    }

    boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        JsonObjectBuilder ob = Json.createObjectBuilder();
        for (Map.Entry<Integer, CustomVariable> entry : this.map.entrySet()) {
            JsonArrayBuilder ab = Json.createArrayBuilder();
            ab.add(entry.getValue().getKey());
            ab.add(entry.getValue().getValue());
            ob.add(entry.getKey().toString(), ab);
        }
        return ob.build().toString();
    }
}

