/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.java.tracking;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Future;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.piwik.java.tracking.PiwikRequest;

public class PiwikTracker {
    private static final String AUTH_TOKEN = "token_auth";
    private static final String REQUESTS = "requests";
    private static final int DEFAULT_TIMEOUT = 5000;
    private final URIBuilder uriBuilder;
    private final int timeout;
    private String proxyHost = null;
    private int proxyPort = 0;

    public PiwikTracker(String hostUrl) {
        this(hostUrl, 5000);
    }

    public PiwikTracker(String hostUrl, int timeout) {
        this.uriBuilder = new URIBuilder(URI.create(hostUrl));
        this.timeout = timeout;
    }

    public PiwikTracker(String hostUrl, String proxyHost, int proxyPort) {
        this(hostUrl, proxyHost, proxyPort, 5000);
    }

    public PiwikTracker(String hostUrl, String proxyHost, int proxyPort, int timeout) {
        this.uriBuilder = new URIBuilder(URI.create(hostUrl));
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.timeout = timeout;
    }

    @Deprecated
    public HttpResponse sendRequest(PiwikRequest request) throws IOException {
        HttpClient client = this.getHttpClient();
        this.uriBuilder.setCustomQuery(request.getQueryString());
        HttpGet get = null;
        try {
            get = new HttpGet(this.uriBuilder.build());
            return client.execute((HttpUriRequest)get);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public Future<HttpResponse> sendRequestAsync(PiwikRequest request) throws IOException {
        CloseableHttpAsyncClient client = this.getHttpAsyncClient();
        client.start();
        this.uriBuilder.setCustomQuery(request.getQueryString());
        HttpGet get = null;
        try {
            get = new HttpGet(this.uriBuilder.build());
            return client.execute((HttpUriRequest)get, null);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Deprecated
    public HttpResponse sendBulkRequest(Iterable<PiwikRequest> requests) throws IOException {
        return this.sendBulkRequest(requests, null);
    }

    public Future<HttpResponse> sendBulkRequestAsync(Iterable<PiwikRequest> requests) throws IOException {
        return this.sendBulkRequestAsync(requests, null);
    }

    @Deprecated
    public HttpResponse sendBulkRequest(Iterable<PiwikRequest> requests, String authToken) throws IOException {
        if (authToken != null && authToken.length() != 32) {
            throw new IllegalArgumentException(authToken + " is not " + 32 + " characters long.");
        }
        JsonObjectBuilder ob = Json.createObjectBuilder();
        JsonArrayBuilder ab = Json.createArrayBuilder();
        for (PiwikRequest request : requests) {
            ab.add("?" + request.getQueryString());
        }
        ob.add(REQUESTS, ab);
        if (authToken != null) {
            ob.add(AUTH_TOKEN, authToken);
        }
        HttpClient client = this.getHttpClient();
        HttpPost post = null;
        try {
            post = new HttpPost(this.uriBuilder.build());
            post.setEntity((HttpEntity)new StringEntity(ob.build().toString(), ContentType.APPLICATION_JSON));
            return client.execute((HttpUriRequest)post);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public Future<HttpResponse> sendBulkRequestAsync(Iterable<PiwikRequest> requests, String authToken) throws IOException {
        if (authToken != null && authToken.length() != 32) {
            throw new IllegalArgumentException(authToken + " is not " + 32 + " characters long.");
        }
        JsonObjectBuilder ob = Json.createObjectBuilder();
        JsonArrayBuilder ab = Json.createArrayBuilder();
        for (PiwikRequest request : requests) {
            ab.add("?" + request.getQueryString());
        }
        ob.add(REQUESTS, ab);
        if (authToken != null) {
            ob.add(AUTH_TOKEN, authToken);
        }
        CloseableHttpAsyncClient client = this.getHttpAsyncClient();
        client.start();
        HttpPost post = null;
        try {
            post = new HttpPost(this.uriBuilder.build());
            post.setEntity((HttpEntity)new StringEntity(ob.build().toString(), ContentType.APPLICATION_JSON));
            return client.execute((HttpUriRequest)post, null);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    protected HttpClient getHttpClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (this.proxyHost != null && this.proxyPort != 0) {
            HttpHost proxy = new HttpHost(this.proxyHost, this.proxyPort);
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            builder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        }
        RequestConfig.Builder config = RequestConfig.custom().setConnectTimeout(this.timeout).setConnectionRequestTimeout(this.timeout).setSocketTimeout(this.timeout);
        builder.setDefaultRequestConfig(config.build());
        return builder.build();
    }

    protected CloseableHttpAsyncClient getHttpAsyncClient() {
        HttpAsyncClientBuilder builder = HttpAsyncClientBuilder.create();
        if (this.proxyHost != null && this.proxyPort != 0) {
            HttpHost proxy = new HttpHost(this.proxyHost, this.proxyPort);
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            builder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        }
        RequestConfig.Builder config = RequestConfig.custom().setConnectTimeout(this.timeout).setConnectionRequestTimeout(this.timeout).setSocketTimeout(this.timeout);
        builder.setDefaultRequestConfig(config.build());
        return builder.build();
    }
}

