/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.api.parallel.ResourceAccessMode;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.junit.jupiter.engine.execution.ConditionEvaluator;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.Node;

@API(status=API.Status.INTERNAL, since="5.0")
public abstract class JupiterTestDescriptor
extends AbstractTestDescriptor
implements Node<JupiterEngineExecutionContext> {
    private static final Logger logger = LoggerFactory.getLogger(JupiterTestDescriptor.class);
    private static final ConditionEvaluator conditionEvaluator = new ConditionEvaluator();

    JupiterTestDescriptor(UniqueId uniqueId, String displayName, TestSource source) {
        super(uniqueId, displayName, source);
    }

    protected static Set<TestTag> getTags(AnnotatedElement element) {
        return AnnotationUtils.findRepeatableAnnotations(element, Tag.class).stream().map(Tag::value).filter(tag -> {
            boolean isValid = TestTag.isValid(tag);
            if (!isValid) {
                logger.warn(() -> String.format("Configuration error: invalid tag syntax in @Tag(\"%s\") declaration on [%s]. Tag will be ignored.", tag, element));
            }
            return isValid;
        }).map(TestTag::create).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
    }

    protected static <E extends AnnotatedElement> String determineDisplayName(E element, Function<E, String> defaultDisplayNameGenerator) {
        Optional<DisplayName> displayNameAnnotation = AnnotationUtils.findAnnotation(element, DisplayName.class);
        if (displayNameAnnotation.isPresent()) {
            String displayName = displayNameAnnotation.get().value().trim();
            if (StringUtils.isBlank(displayName)) {
                logger.warn(() -> String.format("Configuration error: @DisplayName on [%s] must be declared with a non-empty value.", element));
            } else {
                return displayName;
            }
        }
        return defaultDisplayNameGenerator.apply(element);
    }

    @Override
    public final Node.ExecutionMode getExecutionMode() {
        Optional<Node.ExecutionMode> executionMode = this.getExplicitExecutionMode();
        if (executionMode.isPresent()) {
            return executionMode.get();
        }
        Optional<TestDescriptor> parent = this.getParent();
        while (parent.isPresent() && parent.get() instanceof JupiterTestDescriptor) {
            JupiterTestDescriptor jupiterParent = (JupiterTestDescriptor)parent.get();
            executionMode = jupiterParent.getExplicitExecutionMode();
            if (executionMode.isPresent()) {
                return executionMode.get();
            }
            executionMode = jupiterParent.getDefaultChildExecutionMode();
            if (executionMode.isPresent()) {
                return executionMode.get();
            }
            parent = jupiterParent.getParent();
        }
        return Node.ExecutionMode.CONCURRENT;
    }

    protected Optional<Node.ExecutionMode> getExplicitExecutionMode() {
        return Optional.empty();
    }

    protected Optional<Node.ExecutionMode> getDefaultChildExecutionMode() {
        return Optional.empty();
    }

    protected Optional<Node.ExecutionMode> getExecutionModeFromAnnotation(AnnotatedElement element) {
        return AnnotationUtils.findAnnotation(element, Execution.class).map(Execution::value).map(JupiterTestDescriptor::toExecutionMode);
    }

    private static Node.ExecutionMode toExecutionMode(ExecutionMode mode) {
        switch (mode) {
            case CONCURRENT: {
                return Node.ExecutionMode.CONCURRENT;
            }
            case SAME_THREAD: {
                return Node.ExecutionMode.SAME_THREAD;
            }
        }
        throw new JUnitException("Unknown ExecutionMode: " + mode);
    }

    protected Set<ExclusiveResource> getExclusiveResourcesFromAnnotation(AnnotatedElement element) {
        return AnnotationUtils.findRepeatableAnnotations(element, ResourceLock.class).stream().map(resource -> new ExclusiveResource(resource.value(), JupiterTestDescriptor.toLockMode(resource.mode()))).collect(Collectors.toSet());
    }

    private static ExclusiveResource.LockMode toLockMode(ResourceAccessMode mode) {
        switch (mode) {
            case READ: {
                return ExclusiveResource.LockMode.READ;
            }
            case READ_WRITE: {
                return ExclusiveResource.LockMode.READ_WRITE;
            }
        }
        throw new JUnitException("Unknown ResourceAccessMode: " + mode);
    }

    @Override
    public Node.SkipResult shouldBeSkipped(JupiterEngineExecutionContext context) throws Exception {
        ConditionEvaluationResult evaluationResult = conditionEvaluator.evaluate(context.getExtensionRegistry(), context.getConfigurationParameters(), context.getExtensionContext());
        return this.toSkipResult(evaluationResult);
    }

    private Node.SkipResult toSkipResult(ConditionEvaluationResult evaluationResult) {
        if (evaluationResult.isDisabled()) {
            return Node.SkipResult.skip(evaluationResult.getReason().orElse("<unknown>"));
        }
        return Node.SkipResult.doNotSkip();
    }

    @Override
    public abstract JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext var1) throws Exception;

    @Override
    public void cleanUp(JupiterEngineExecutionContext context) throws Exception {
        context.close();
    }

    protected void executeAndMaskThrowable(Executable executable) {
        try {
            executable.execute();
        }
        catch (Throwable throwable) {
            ExceptionUtils.throwAsUncheckedException(throwable);
        }
    }
}

