/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.execution.ExtensionValuesStore;
import org.junit.jupiter.engine.execution.NamespaceAwareStore;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.reporting.ReportEntry;

abstract class AbstractExtensionContext<T extends TestDescriptor>
implements ExtensionContext,
AutoCloseable {
    private final ExtensionContext parent;
    private final EngineExecutionListener engineExecutionListener;
    private final T testDescriptor;
    private final Set<String> tags;
    private final ConfigurationParameters configurationParameters;
    private final ExtensionValuesStore valuesStore;

    AbstractExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, T testDescriptor, ConfigurationParameters configurationParameters) {
        Preconditions.notNull(testDescriptor, "TestDescriptor must not be null");
        Preconditions.notNull(configurationParameters, "ConfigurationParameters must not be null");
        this.parent = parent;
        this.engineExecutionListener = engineExecutionListener;
        this.testDescriptor = testDescriptor;
        this.configurationParameters = configurationParameters;
        this.valuesStore = this.createStore(parent);
        this.tags = testDescriptor.getTags().stream().map(TestTag::getName).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
    }

    private ExtensionValuesStore createStore(ExtensionContext parent) {
        ExtensionValuesStore parentStore = null;
        if (parent != null) {
            parentStore = ((AbstractExtensionContext)parent).valuesStore;
        }
        return new ExtensionValuesStore(parentStore);
    }

    @Override
    public void close() {
        this.valuesStore.closeAllStoredCloseableValues();
    }

    public String getUniqueId() {
        return this.getTestDescriptor().getUniqueId().toString();
    }

    public String getDisplayName() {
        return this.getTestDescriptor().getDisplayName();
    }

    public void publishReportEntry(Map<String, String> values) {
        this.engineExecutionListener.reportingEntryPublished((TestDescriptor)this.testDescriptor, ReportEntry.from(values));
    }

    public Optional<ExtensionContext> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public ExtensionContext getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    protected T getTestDescriptor() {
        return this.testDescriptor;
    }

    public ExtensionContext.Store getStore(ExtensionContext.Namespace namespace) {
        Preconditions.notNull(namespace, "Namespace must not be null");
        return new NamespaceAwareStore(this.valuesStore, namespace);
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(this.tags);
    }

    public Optional<String> getConfigurationParameter(String key) {
        return this.configurationParameters.get(key);
    }
}

