/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit5;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.PreconditionViolationException;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.pitest.junit5.JUnit5TestUnit;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.testapi.TestUnit;
import org.pitest.testapi.TestUnitFinder;

public class JUnit5TestUnitFinder
implements TestUnitFinder {
    private final TestGroupConfig testGroupConfig;
    private final Collection<String> includedTestMethods;
    private final Launcher launcher;

    public JUnit5TestUnitFinder(TestGroupConfig testGroupConfig, Collection<String> includedTestMethods) {
        this.testGroupConfig = testGroupConfig;
        this.includedTestMethods = includedTestMethods;
        this.launcher = LauncherFactory.create();
    }

    public List<TestUnit> findTestUnits(Class<?> clazz) {
        if (clazz.getEnclosingClass() != null) {
            return Collections.emptyList();
        }
        ArrayList<PostDiscoveryFilter> filters = new ArrayList<PostDiscoveryFilter>(2);
        try {
            List includedGroups;
            List excludedGroups = this.testGroupConfig.getExcludedGroups();
            if (excludedGroups != null && !excludedGroups.isEmpty()) {
                filters.add(TagFilter.excludeTags(excludedGroups));
            }
            if ((includedGroups = this.testGroupConfig.getIncludedGroups()) != null && !includedGroups.isEmpty()) {
                filters.add(TagFilter.includeTags(includedGroups));
            }
        }
        catch (PreconditionViolationException e) {
            throw new IllegalArgumentException("Error creating tag filter", e);
        }
        TestIdentifierListener listener = new TestIdentifierListener();
        this.launcher.execute(LauncherDiscoveryRequestBuilder.request().selectors(DiscoverySelectors.selectClass(clazz)).filters(filters.toArray(new Filter[filters.size()])).build(), listener);
        return listener.getIdentifiers().stream().map(testIdentifier -> new JUnit5TestUnit(clazz, (TestIdentifier)testIdentifier)).collect(Collectors.toList());
    }

    private class TestIdentifierListener
    extends SummaryGeneratingListener {
        private final List<TestIdentifier> identifiers = new ArrayList<TestIdentifier>();

        private TestIdentifierListener() {
        }

        List<TestIdentifier> getIdentifiers() {
            return Collections.unmodifiableList(this.identifiers);
        }

        @Override
        public void executionStarted(TestIdentifier testIdentifier) {
            if (testIdentifier.isTest()) {
                if (JUnit5TestUnitFinder.this.includedTestMethods != null && !JUnit5TestUnitFinder.this.includedTestMethods.isEmpty() && testIdentifier.getSource().isPresent() && testIdentifier.getSource().get() instanceof MethodSource && !JUnit5TestUnitFinder.this.includedTestMethods.contains(((MethodSource)testIdentifier.getSource().get()).getMethodName())) {
                    return;
                }
                this.identifiers.add(testIdentifier);
            }
        }
    }
}

