/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.DiscoveryFilter;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.core.DefaultDiscoveryRequest;
import org.junit.platform.launcher.core.LauncherConfigurationParameters;

@API(status=API.Status.STABLE, since="1.0")
public final class LauncherDiscoveryRequestBuilder {
    private List<DiscoverySelector> selectors = new ArrayList<DiscoverySelector>();
    private List<EngineFilter> engineFilters = new ArrayList<EngineFilter>();
    private List<DiscoveryFilter<?>> discoveryFilters = new ArrayList();
    private List<PostDiscoveryFilter> postDiscoveryFilters = new ArrayList<PostDiscoveryFilter>();
    private Map<String, String> configurationParameters = new HashMap<String, String>();

    public static LauncherDiscoveryRequestBuilder request() {
        return new LauncherDiscoveryRequestBuilder();
    }

    public LauncherDiscoveryRequestBuilder selectors(DiscoverySelector ... selectors) {
        Preconditions.notNull(selectors, "selectors array must not be null");
        this.selectors(Arrays.asList(selectors));
        return this;
    }

    public LauncherDiscoveryRequestBuilder selectors(List<? extends DiscoverySelector> selectors) {
        Preconditions.notNull(selectors, "selectors list must not be null");
        Preconditions.containsNoNullElements(selectors, "individual selectors must not be null");
        this.selectors.addAll(selectors);
        return this;
    }

    public LauncherDiscoveryRequestBuilder filters(Filter<?> ... filters) {
        Preconditions.notNull(filters, "filters array must not be null");
        Preconditions.containsNoNullElements(filters, "individual filters must not be null");
        Arrays.stream(filters).forEach(this::storeFilter);
        return this;
    }

    public LauncherDiscoveryRequestBuilder configurationParameter(String key, String value) {
        Preconditions.notBlank(key, "configuration parameter key must not be null or blank");
        this.configurationParameters.put(key, value);
        return this;
    }

    public LauncherDiscoveryRequestBuilder configurationParameters(Map<String, String> configurationParameters) {
        Preconditions.notNull(configurationParameters, "configuration parameters map must not be null");
        configurationParameters.forEach(this::configurationParameter);
        return this;
    }

    private void storeFilter(Filter<?> filter) {
        if (filter instanceof EngineFilter) {
            this.engineFilters.add((EngineFilter)filter);
        } else if (filter instanceof PostDiscoveryFilter) {
            this.postDiscoveryFilters.add((PostDiscoveryFilter)filter);
        } else if (filter instanceof DiscoveryFilter) {
            this.discoveryFilters.add((DiscoveryFilter)filter);
        } else {
            throw new PreconditionViolationException(String.format("Filter [%s] must implement %s, %s, or %s.", filter, EngineFilter.class.getSimpleName(), PostDiscoveryFilter.class.getSimpleName(), DiscoveryFilter.class.getSimpleName()));
        }
    }

    public LauncherDiscoveryRequest build() {
        LauncherConfigurationParameters launcherConfigurationParameters = new LauncherConfigurationParameters(this.configurationParameters);
        return new DefaultDiscoveryRequest(this.selectors, this.engineFilters, this.discoveryFilters, this.postDiscoveryFilters, launcherConfigurationParameters);
    }
}

