/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.config;

import java.util.ArrayList;
import java.util.Collection;
import org.pitest.mutationtest.MutationEngineFactory;
import org.pitest.mutationtest.MutationResultListenerFactory;
import org.pitest.mutationtest.build.MutationGrouperFactory;
import org.pitest.mutationtest.build.TestPrioritiserFactory;
import org.pitest.mutationtest.filter.MutationFilterFactory;
import org.pitest.plugin.ClientClasspathPlugin;
import org.pitest.plugin.ToolClasspathPlugin;
import org.pitest.testapi.TestPluginFactory;
import org.pitest.util.IsolationUtils;
import org.pitest.util.ServiceLoader;

public class PluginServices {
    private final ClassLoader loader;

    public PluginServices(ClassLoader loader) {
        this.loader = loader;
    }

    public static PluginServices makeForContextLoader() {
        return new PluginServices(IsolationUtils.getContextClassLoader());
    }

    public Iterable<? extends ToolClasspathPlugin> findToolClasspathPlugins() {
        ArrayList<Object> l = new ArrayList<Object>();
        l.addAll(this.findListeners());
        l.addAll(this.findGroupers());
        l.addAll(this.findFilters());
        l.addAll(this.findTestPrioritisers());
        return l;
    }

    public Iterable<? extends ClientClasspathPlugin> findClientClasspathPlugins() {
        ArrayList<Object> l = new ArrayList<Object>();
        l.addAll(this.findMutationEngines());
        l.addAll(this.findTestFrameworkPlugins());
        l.addAll(this.nullPlugins());
        return l;
    }

    Collection<? extends TestPluginFactory> findTestFrameworkPlugins() {
        return ServiceLoader.load(TestPluginFactory.class, this.loader);
    }

    Collection<? extends MutationGrouperFactory> findGroupers() {
        return ServiceLoader.load(MutationGrouperFactory.class, this.loader);
    }

    Collection<? extends MutationFilterFactory> findFilters() {
        return ServiceLoader.load(MutationFilterFactory.class, this.loader);
    }

    Collection<? extends MutationResultListenerFactory> findListeners() {
        return ServiceLoader.load(MutationResultListenerFactory.class, this.loader);
    }

    Collection<? extends MutationEngineFactory> findMutationEngines() {
        return ServiceLoader.load(MutationEngineFactory.class, this.loader);
    }

    Collection<? extends TestPrioritiserFactory> findTestPrioritisers() {
        return ServiceLoader.load(TestPrioritiserFactory.class, this.loader);
    }

    private Collection<ClientClasspathPlugin> nullPlugins() {
        return ServiceLoader.load(ClientClasspathPlugin.class, this.loader);
    }
}

