/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.ClassName;
import org.pitest.coverage.TestInfo;
import org.pitest.mutationtest.MutationConfig;
import org.pitest.mutationtest.build.TestPrioritiser;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.filter.MutationFilter;
import org.pitest.util.Log;

public class MutationSource {
    private static final Logger LOG = Log.getLogger();
    private final MutationConfig mutationConfig;
    private final TestPrioritiser testPrioritiser;
    private final MutationFilter filter;
    private final ClassByteArraySource source;

    public MutationSource(MutationConfig mutationConfig, MutationFilter filter, TestPrioritiser testPrioritiser, ClassByteArraySource source) {
        this.mutationConfig = mutationConfig;
        this.testPrioritiser = testPrioritiser;
        this.filter = filter;
        this.source = source;
    }

    public Collection<MutationDetails> createMutations(ClassName clazz) {
        Mutater m = this.mutationConfig.createMutator(this.source);
        Collection<MutationDetails> availableMutations = this.filter.filter(m.findMutations(clazz));
        this.assignTestsToMutations(availableMutations);
        return availableMutations;
    }

    private void assignTestsToMutations(Collection<MutationDetails> availableMutations) {
        for (MutationDetails mutation : availableMutations) {
            List<TestInfo> testDetails = this.testPrioritiser.assignTests(mutation);
            if (testDetails.isEmpty()) {
                LOG.fine("According to coverage no tests hit the mutation " + mutation);
            }
            mutation.addTestsInOrder(testDetails);
        }
    }
}

