/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.SideEffect1;
import org.pitest.functional.predicate.Predicate;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.MutationDetails;

public class MutationStatusMap {
    private final Map<MutationDetails, MutationStatusTestPair> mutationMap = new HashMap<MutationDetails, MutationStatusTestPair>();

    public void setStatusForMutation(MutationDetails mutation, DetectionStatus status) {
        this.setStatusForMutations(Collections.singleton(mutation), status);
    }

    public void setStatusForMutation(MutationDetails mutation, MutationStatusTestPair status) {
        this.mutationMap.put(mutation, status);
    }

    public void setStatusForMutations(Collection<MutationDetails> mutations, DetectionStatus status) {
        FCollection.forEach(mutations, (SideEffect1)Prelude.putToMap(this.mutationMap, (Object)new MutationStatusTestPair(0, status)));
    }

    public List<MutationResult> createMutationResults() {
        return FCollection.map(this.mutationMap.entrySet(), MutationStatusMap.detailsToMutationResults());
    }

    public boolean hasUnrunMutations() {
        return !this.getUnrunMutations().isEmpty();
    }

    public Collection<MutationDetails> getUnrunMutations() {
        return FCollection.filter(this.mutationMap.entrySet(), MutationStatusMap.hasStatus(DetectionStatus.NOT_STARTED)).map(MutationStatusMap.toMutationDetails());
    }

    public Collection<MutationDetails> getUnfinishedRuns() {
        return FCollection.filter(this.mutationMap.entrySet(), MutationStatusMap.hasStatus(DetectionStatus.STARTED)).map(MutationStatusMap.toMutationDetails());
    }

    public Set<MutationDetails> allMutations() {
        return this.mutationMap.keySet();
    }

    private static F<Map.Entry<MutationDetails, MutationStatusTestPair>, MutationResult> detailsToMutationResults() {
        return new F<Map.Entry<MutationDetails, MutationStatusTestPair>, MutationResult>(){

            public MutationResult apply(Map.Entry<MutationDetails, MutationStatusTestPair> a) {
                return new MutationResult(a.getKey(), a.getValue());
            }
        };
    }

    private static F<Map.Entry<MutationDetails, MutationStatusTestPair>, MutationDetails> toMutationDetails() {
        return new F<Map.Entry<MutationDetails, MutationStatusTestPair>, MutationDetails>(){

            public MutationDetails apply(Map.Entry<MutationDetails, MutationStatusTestPair> a) {
                return a.getKey();
            }
        };
    }

    private static Predicate<Map.Entry<MutationDetails, MutationStatusTestPair>> hasStatus(final DetectionStatus status) {
        return new Predicate<Map.Entry<MutationDetails, MutationStatusTestPair>>(){

            public Boolean apply(Map.Entry<MutationDetails, MutationStatusTestPair> a) {
                return a.getValue().getStatus().equals((Object)status);
            }
        };
    }

    public void markUncoveredMutations() {
        this.setStatusForMutations((Collection<MutationDetails>)FCollection.filter(this.mutationMap.keySet(), MutationStatusMap.hasNoCoverage()), DetectionStatus.NO_COVERAGE);
    }

    private static F<MutationDetails, Boolean> hasNoCoverage() {
        return new F<MutationDetails, Boolean>(){

            public Boolean apply(MutationDetails a) {
                return a.getTestsInOrder().isEmpty();
            }
        };
    }
}

