/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.commandline;

import java.util.HashSet;
import java.util.Set;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.predicate.Predicate;
import org.pitest.mutationtest.config.PluginServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginFilter
implements Predicate<String> {
    private final Set<String> includedClassPathElement = new HashSet<String>();

    public PluginFilter(PluginServices plugin) {
        FCollection.mapTo((Iterable)plugin.findClientClasspathPlugins(), PluginFilter.classToLocation(), this.includedClassPathElement);
    }

    private static F<Object, String> classToLocation() {
        return new F<Object, String>(){

            public String apply(Object a) {
                return a.getClass().getProtectionDomain().getCodeSource().getLocation().getFile();
            }
        };
    }

    public Boolean apply(String a) {
        return this.includedClassPathElement.contains(a);
    }
}

