/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.script.bsh;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.adapters.AbstractAdapter;
import org.picocontainer.script.bsh.BeanShellScriptCompositionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanShellAdapter
extends AbstractAdapter {
    private final Parameter[] parameters;
    private Object instance = null;
    private final ClassLoader classLoader;

    public BeanShellAdapter(Object componentKey, Class<?> componentImplementation, Parameter[] parameters, ClassLoader classLoader) {
        super(componentKey, componentImplementation);
        this.parameters = parameters;
        this.classLoader = classLoader;
    }

    public BeanShellAdapter(Object componentKey, Class<?> componentImplementation, Parameter ... parameters) {
        this(componentKey, componentImplementation, parameters, BeanShellAdapter.class.getClassLoader());
    }

    public Object getComponentInstance(PicoContainer pico, Type into) throws PicoCompositionException {
        if (this.instance == null) {
            try {
                Interpreter i = new Interpreter();
                i.setClassLoader(this.classLoader);
                i.set("addAdapter", (Object)this);
                i.set("picoContainer", (Object)pico);
                i.set("componentKey", this.getComponentKey());
                i.set("componentImplementation", (Object)this.getComponentImplementation());
                i.set("parameters", (Object)(this.parameters != null ? Arrays.asList(this.parameters) : Collections.EMPTY_LIST));
                i.eval("import " + this.getComponentImplementation().getName() + ";");
                String scriptPath = "/" + this.getComponentImplementation().getName().replace('.', '/') + ".bsh";
                URL scriptURL = this.getComponentImplementation().getResource(scriptPath);
                if (scriptURL == null) {
                    throw new BeanShellScriptCompositionException("Couldn't load script at path " + scriptPath);
                }
                InputStreamReader sourceReader = new InputStreamReader(scriptURL.openStream());
                i.eval((Reader)sourceReader, i.getNameSpace(), scriptURL.toExternalForm());
                this.instance = i.get("instance");
                if (this.instance == null) {
                    throw new BeanShellScriptCompositionException("The 'instance' variable was not instantiated");
                }
            }
            catch (EvalError e) {
                throw new BeanShellScriptCompositionException(e);
            }
            catch (IOException e) {
                throw new BeanShellScriptCompositionException(e);
            }
        }
        return this.instance;
    }

    public void verify(PicoContainer pico) {
    }

    public String getDescriptor() {
        return "BeanShellConsole";
    }
}

