/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.scim.providers;

import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jboss.logging.Logger;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.internal.DefaultPartitionManager;
import org.picketlink.idm.jpa.model.sample.simple.AccountTypeEntity;
import org.picketlink.idm.jpa.model.sample.simple.AttributeTypeEntity;
import org.picketlink.idm.jpa.model.sample.simple.GroupTypeEntity;
import org.picketlink.idm.jpa.model.sample.simple.IdentityTypeEntity;
import org.picketlink.idm.jpa.model.sample.simple.PartitionTypeEntity;
import org.picketlink.idm.jpa.model.sample.simple.PasswordCredentialTypeEntity;
import org.picketlink.idm.jpa.model.sample.simple.RelationshipIdentityTypeEntity;
import org.picketlink.idm.jpa.model.sample.simple.RelationshipTypeEntity;
import org.picketlink.idm.jpa.model.sample.simple.RoleTypeEntity;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.basic.BasicModel;
import org.picketlink.idm.model.basic.Group;
import org.picketlink.idm.model.basic.Realm;
import org.picketlink.idm.model.basic.User;
import org.picketlink.idm.query.Condition;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.IdentityQueryBuilder;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.scim.DataProvider;
import org.picketlink.scim.model.v11.SCIMGroups;
import org.picketlink.scim.model.v11.SCIMResource;
import org.picketlink.scim.model.v11.SCIMUser;
import org.picketlink.scim.model.v11.UserName;

public class PicketLinkIDMDataProvider
implements DataProvider {
    private static Logger log = Logger.getLogger(PicketLinkIDMDataProvider.class);
    protected EntityManagerFactory entityManagerFactory;
    protected ThreadLocal<EntityManager> entityManagerThreadLocal = new ThreadLocal();
    @Inject
    private IdentityManager identityManager;

    @Override
    public SCIMUser getUser(String id) {
        this.verifyIdentityManager();
        SCIMUser scimUser = new SCIMUser();
        IdentityQueryBuilder queryBuilder = this.identityManager.getQueryBuilder();
        IdentityQuery query = queryBuilder.createIdentityQuery(User.class);
        query.where(new Condition[]{queryBuilder.equal(AttributedType.ID, (Object)id)});
        List result = query.getResultList();
        User user = null;
        if (result.size() > 0) {
            user = (User)result.get(0);
            scimUser.setId(id);
            UserName userName = new UserName();
            userName.setGivenName(user.getFirstName());
            userName.setFamilyName(user.getLastName());
            scimUser.setName(userName);
        }
        return scimUser;
    }

    @Override
    public SCIMGroups getGroups(String id) {
        this.verifyIdentityManager();
        SCIMGroups scimGroup = new SCIMGroups();
        IdentityQuery query = this.identityManager.createIdentityQuery(Group.class);
        query.setParameter(AttributedType.ID, new Object[]{id});
        List result = query.getResultList();
        Group group = null;
        if (result.size() == 1) {
            group = (Group)result.get(0);
        } else if (result.size() == 0) {
            log.error((Object)("No group instances with id:" + id));
        } else {
            log.error((Object)("Multiple group instances with id:" + id));
        }
        if (group != null) {
            scimGroup.setDisplayName(group.getName());
            scimGroup.setId(id);
        }
        return scimGroup;
    }

    @Override
    public boolean deleteUser(String id) {
        this.verifyIdentityManager();
        IdentityQuery query = this.identityManager.createIdentityQuery(User.class);
        query.setParameter(AttributedType.ID, new Object[]{id});
        List result = query.getResultList();
        User user = null;
        if (result.size() == 1) {
            user = (User)result.get(0);
        } else if (result.size() == 0) {
            log.error((Object)("No user instances with id:" + id));
        } else {
            log.error((Object)("Multiple user instances with id:" + id));
        }
        if (user != null) {
            this.identityManager.remove((AttributedType)user);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteGroup(String id) {
        this.verifyIdentityManager();
        IdentityQuery query = this.identityManager.createIdentityQuery(Group.class);
        query.setParameter(AttributedType.ID, new Object[]{id});
        List result = query.getResultList();
        Group group = null;
        if (result.size() == 1) {
            group = (Group)result.get(0);
        } else if (result.size() == 0) {
            log.error((Object)("No group instances with id:" + id));
        } else {
            log.error((Object)("Multiple group instances with id:" + id));
        }
        if (group != null) {
            this.identityManager.remove((AttributedType)group);
            return true;
        }
        return false;
    }

    @Override
    public SCIMResource getResource(String id) {
        SCIMResource scimResource = new SCIMResource();
        return scimResource;
    }

    @Override
    public String createUser(SCIMUser user) {
        this.verifyIdentityManager();
        User simpleUser = new User();
        simpleUser.setLoginName(user.getDisplayName());
        UserName userName = user.getName();
        if (userName != null) {
            simpleUser.setFirstName(userName.getGivenName());
            simpleUser.setLastName(userName.getFamilyName());
            simpleUser.setAttribute(new Attribute("FullName", (Serializable)((Object)userName.getFormatted())));
        }
        this.identityManager.add((AttributedType)simpleUser);
        User storedUser = BasicModel.getUser((IdentityManager)this.identityManager, (String)user.getDisplayName());
        String id = storedUser.getId();
        return id;
    }

    @Override
    public String createGroup(SCIMGroups group) {
        this.verifyIdentityManager();
        Group simpleGroup = new Group(group.getDisplayName());
        if (group.getId() != null) {
            simpleGroup.setId(group.getId());
        }
        this.identityManager.add((AttributedType)simpleGroup);
        Group storedGroup = BasicModel.getGroup((IdentityManager)this.identityManager, (String)group.getDisplayName());
        String id = storedGroup.getId();
        return id;
    }

    public PicketLinkIDMDataProvider setIdentityManager(IdentityManager im) {
        this.identityManager = im;
        return this;
    }

    @Override
    public void initializeConnection() {
        this.verifyIdentityManager();
        if (this.entityManagerFactory != null) {
            EntityManager entityManager = this.entityManagerThreadLocal.get();
            if (entityManager == null) {
                entityManager = this.entityManagerFactory.createEntityManager();
                this.entityManagerThreadLocal.set(entityManager);
            }
            entityManager.getTransaction().begin();
        }
    }

    @Override
    public void closeConnection() {
        if (this.entityManagerFactory != null) {
            EntityManager entityManager = this.entityManagerThreadLocal.get();
            if (entityManager != null) {
                entityManager.getTransaction().commit();
                entityManager.close();
            }
            this.entityManagerThreadLocal.remove();
            this.identityManager = null;
        }
    }

    protected void verifyIdentityManager() {
        if (this.identityManager == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Identity Manager not injected. Creating JPA based Identity Manager");
            }
            this.createJPADrivenIdentityManager();
        }
    }

    protected void createJPADrivenIdentityManager() {
        final EntityManager entityManager = this.createEntityManager();
        this.entityManagerThreadLocal.set(entityManager);
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        builder.named("default").stores().jpa().mappedEntity(new Class[]{AccountTypeEntity.class, RoleTypeEntity.class, GroupTypeEntity.class, IdentityTypeEntity.class, RelationshipTypeEntity.class, RelationshipIdentityTypeEntity.class, PartitionTypeEntity.class, PasswordCredentialTypeEntity.class, AttributeTypeEntity.class}).supportGlobalRelationship(new Class[]{Relationship.class}).addContextInitializer(new ContextInitializer(){

            public void initContextForStore(IdentityContext context, IdentityStore<?> store) {
                context.setParameter("CTX_ENTITY_MANAGER", (Object)entityManager);
            }
        }).supportAllFeatures();
        DefaultPartitionManager partitionManager = new DefaultPartitionManager(builder.build());
        List partitions = partitionManager.getPartitions(Realm.class);
        boolean foundPartition = false;
        if (partitions != null) {
            for (Partition partition : partitions) {
                if (!partition.getName().equalsIgnoreCase("default")) continue;
                foundPartition = true;
            }
        }
        if (!foundPartition) {
            partitionManager.add((AttributedType)new Realm("default"));
        }
        this.identityManager = partitionManager.createIdentityManager();
    }

    private EntityManager createEntityManager() {
        this.entityManagerFactory = Persistence.createEntityManagerFactory((String)"picketlink-scim-pu");
        return this.entityManagerFactory.createEntityManager();
    }
}

