/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.picketlink.common.exceptions.NotImplementedException;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.OperationNotSupportedException;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Token;
import org.picketlink.idm.credential.encoder.PasswordEncoder;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.RelationshipQuery;

public class IDMInternalMessages_$bundle
implements Serializable,
IDMInternalMessages,
IDMMessages {
    private static final long serialVersionUID = 1L;
    public static final IDMInternalMessages_$bundle INSTANCE = new IDMInternalMessages_$bundle();
    private static final String storeNotFound = "PLIDM000300: No store [%s] found that supports the given type [%s]. Check if the type was specified in your configuration.";
    private static final String storeJpaCouldNotGetEntityManagerFromStoreContext = "PLIDM000301: Error while trying to determine EntityManager - context parameter not set.";
    private static final String storeLdapCouldNotCreateContext = "PLIDM000302: Could not create context.";
    private static final String storeLdapEntryNotFoundWithId = "Entry not found with ID [%s] using baseDN [%s].";
    private static final String storeLdapCouldNotLoadAttributesForEntry = "Could not load attributes for entry with ID [%s] using baseDN [%s].";
    private static final String storeUnexpectedType = "Unexpected IdentityStore type. Expected [%s]. Actual [%s].";
    private static final String partitionAddFailed = "PLIDM000401: Could not create partition [%s] using configuration [%s].";
    private static final String partitionUpdateFailed = "PLIDM000402: Could not update partition [%s].";
    private static final String partitionRemoveFailed = "PLIDM000403: Could not remove partition [%s].";
    private static final String partitionGetFailed = "PLIDM000404: Could not load partition for type [%s] and name [%s].";
    private static final String partitionCouldNotCreateIdentityManager = "PLIDM000405: Could not create contextual IdentityManager for Partition [%s]. Partition not found or it was null.";
    private static final String partitionNotFoundWithName = "PLIDM000406: Partition [%s] not found with the given name [%s].";
    private static final String partitionNoConfigurationFound = "PLIDM000407: No configuration found with the given name [%s].";
    private static final String partitionReferencesInvalidConfiguration = "PLIDM000408: Partition [%s] references an invalid or non-existent configuration.";
    private static final String partitionManagementNoSupported = "PLIDM000409: Partition management is not supported by the current configuration.";
    private static final String partitionCouldNotCreatePermissionManager = "PLIDM000410: Could not create contextual PermissionManager for Partition [%s].";
    private static final String partitionUnsupportedType = "PLIDM000411: Partition [%s] does not support type [%s].";
    private static final String partitionFoundWithSameNameAndType = "PLIDM000412: More than one partitions have been found with the given name [%s] and type [%s].";
    private static final String partitionAlreadyExistsWithName = "A Partition [%s] with name [%s] already exists.";
    private static final String partitionWithNoConfigurationName = "No configuration name defined for partition [%s].";
    private static final String queryRelationshipFailed = "PLIDM000500: Could not query Relationship using query [%s].";
    private static final String queryIdentityTypeFailed = "PLIDM000501: Could not query IdentityType using query [%s].";
    private static final String queryUnsupportedParameterValue = "Unsupported value for Query Parameter [%s]. Value: %s.";
    private static final String attributedTypeAddFailed = "PLIDM000600: Could not add AttributedType [%s].";
    private static final String attributedTypeRemoveFailed = "PLIDM000601: Could not remove AttributedType [%s].";
    private static final String attributedTypeUpdateFailed = "PLIDM000602: Could not update AttributedType [%s].";
    private static final String identityTypeAlreadyExists = "IdentityType [%s] already exists with the given identifier [%s] for the given Partition [%s].";
    private static final String attributedTypeAmbiguosFoundWithId = "PLIDM000603: Ambiguous AttributedType found with identifier [%s].";
    private static final String attributedTypeUnsupportedOperation = "PLIDM000604: No identity store configuration found for requested type operation [%s.%s].";
    private static final String attributedUndefinedPartition = "PLIDM000605: Undefined partition for identity type [%s].";
    private static final String attributedTypeNotFoundWithId = "Could not find AttributedType [%s] with the given identifier [%s] for Partition [%s]";
    private static final String permissionUnsupportedOperation = "PLIDM000800: No PermissionStore configuration found for requested permission operation.";
    private static final String configJpaStoreNoPermissionEntityClassProvided = "PLIDM000801: No @Entity class found to store permissions. Check if you have an @Entity class annotated with @PermissionManaged.";
    private static final String instantiationError = "PLIDM000001: Error creating instance for type [%s].";
    private static final String nullArgument = "PLIDM000002: Null argument: [%s].";
    private static final String unmarshallingError = "PLIDM000003: Error unmarshalling object.";
    private static final String marshallingError = "PLIDM000004: Error marshalling object.";
    private static final String unexpectedType = "PLIDM000005: Unexpected type [%s].";
    private static final String partitionManagerInitializationFailed = "PLIDM000006: Could not initialize Partition Manager [%s].";
    private static final String notImplemented = "PLIDM000007: Not implemented.";
    private static final String credentialValidationFailed = "PLIDM000200: Credential validation failed [%s].";
    private static final String credentialUpdateFailed = "PLIDM000201: Credential update failed for account [%s] and type [%s].";
    private static final String credentialNoStoreForCredentials = "PLIDM000202: No IdentityStore found for credential class [%s]";
    private static final String credentialUnsupportedType = "PLIDM000203: Credentials class [%s] not supported by this handler [%s].";
    private static final String credentialRetrievalFailed = "PLIDM000204: Credentials could not be retrieved for account [%s] and storage [%s].";
    private static final String credentialInvalidAccountType = "PLIDM000205: The IdentityType returned is not an Account: [%s]";
    private static final String credentialMultipleAccountsFoundForType = "PLIDM000206: Multiple Account objects found with same login name [%s] for account type [%s].";
    private static final String credentialNoAccountTypeProvided = "PLIDM000207: No Account type provided. You must provide at least one Account type in order to support credential management.";
    private static final String credentialUnknownUserNameProperty = "PLIDM000208: Account type [%s] does not provide a property annotated with @StereotypeProperty(IDENTITY_USER_NAME). Without this the account can not be retrieved from the store based on the user name.";
    private static final String credentialDigestInvalidRealm = "Invalid Realm or it was not provided.";
    private static final String credentialInvalidPassword = "Invalid Password or it was not provided.";
    private static final String credentialCouldNotEncodePassword = "Could not encode password.";
    private static final String credentialHandlerNotFoundForCredentialType = "No suitable CredentialHandler available for validating Credentials of type [%s].";
    private static final String credentialInvalidEncodingAlgorithm = "No such algorithm [%s] for encoding passwords. Using PasswordEncoder [%s].";
    private static final String credentialNoConsumerForToken = "There is no Token.Consumer that supports this token [%s].";
    private static final String configCouldNotCreateConfiguration = "PLIDM000700: Could not create configuration.";
    private static final String configInvalidConfiguration = "PLIDM000701: Invalid configuration [%s].";
    private static final String configNoConfigurationProvided = "PLIDM000702: You must provide at least one configuration.";
    private static final String configBuildMultipleConfigurationExists = "PLIDM000703: You have provided more than one configuration. Use the buildAll method instead.";
    private static final String configNoIdentityConfigurationProvided = "PLIDM000704: At least one IdentityConfiguration must be provided";
    private static final String configStoreNoIdentityStoreConfigProvided = "PLIDM000705: You must configure at least one identity store.";
    private static final String configStoreDuplicatedSupportedType = "PLIDM000706: Duplicated supported types [%s] found for identity store configuration. Check your identity store configuration for duplicated types, considering their hierarchy.";
    private static final String configMultipleConfigurationsFoundWithCredentialSupport = "PLIDM000707: Multiple configuration with credential support.";
    private static final String configJpaStoreNoEntityClassesProvided = "Error initializing JpaIdentityStore - no entity classes configured.";
    private static final String configJpaStoreRequiredMappingAnnotation = "Entity [%s] must have a field annotated with %s.";
    private static final String configJpaStoreRequiredMappingAnnotationForAttributedType = "Invalid mapping for type [%s]. No entity found with a field annotated with %s. Do you have an entity mapping this type?";
    private static final String configJpaStoreMappedNoAttributeMappingFound = "Attribute support is enabled (ad-hoc). But no entity was found with the necessary mapping to store attributes.";
    private static final String configJpaStoreMappedNoCredentialStorageMappingFound = "Credential support is enabled. But no entity was found with the necessary mapping to store any CredentialStorage.";
    private static final String configJpaStoreMappedPropertyNotFound = "Mapped attribute [%s.%s] does not map to any field for type [%s].";
    private static final String configUnknownStoreForConfiguration = "Unknown IdentityStore class for configuration [%s].";
    private static final String configCouldNotCreateStore = "Error while creating IdentityStore [%s] instance for configuration [%s].";
    private static final String configStoreMultiplePartitionConfigExists = "Only a single identity store config can support partitions. Found [%s] and [%s].";
    private static final String configMultipleConfigurationsFoundWithSameName = "Multiple configuration with the same name [%s].";
    private static final String permissionGrantFailed = "Could not grant permission to [%s] for resource [%s], operation [%s].";
    private static final String permissionsGrantFailed = "Could not grant Permissions [%s].";
    private static final String permissionRevokeFailed = "Could not revoke permission granted to [%s] for resource [%s], operation [%s].";
    private static final String permissionsRevokeFailed = "Could not revoke Permissions [%s].";
    private static final String permissionRevokeAllFailed = "Failed to revoke all permissions for resource [%s].";

    protected IDMInternalMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    public final IdentityManagementException storeNotFound(Class partitionStoreClass, Class partitionClass) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.storeNotFound$str(), partitionStoreClass, partitionClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String storeNotFound$str() {
        return storeNotFound;
    }

    @Override
    public final IdentityManagementException storeJpaCouldNotGetEntityManagerFromStoreContext() {
        IdentityManagementException result = new IdentityManagementException(String.format(this.storeJpaCouldNotGetEntityManagerFromStoreContext$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String storeJpaCouldNotGetEntityManagerFromStoreContext$str() {
        return storeJpaCouldNotGetEntityManagerFromStoreContext;
    }

    @Override
    public final IdentityManagementException storeLdapCouldNotCreateContext(Throwable e) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.storeLdapCouldNotCreateContext$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String storeLdapCouldNotCreateContext$str() {
        return storeLdapCouldNotCreateContext;
    }

    @Override
    public final IdentityManagementException storeLdapEntryNotFoundWithId(String entryUUID, String baseDN) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.storeLdapEntryNotFoundWithId$str(), entryUUID, baseDN));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String storeLdapEntryNotFoundWithId$str() {
        return storeLdapEntryNotFoundWithId;
    }

    @Override
    public final IdentityManagementException storeLdapCouldNotLoadAttributesForEntry(String entryUUID, String baseDN) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.storeLdapCouldNotLoadAttributesForEntry$str(), entryUUID, baseDN));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String storeLdapCouldNotLoadAttributesForEntry$str() {
        return storeLdapCouldNotLoadAttributesForEntry;
    }

    public final IdentityManagementException storeUnexpectedType(Class expectedType, Class actualType) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.storeUnexpectedType$str(), expectedType, actualType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String storeUnexpectedType$str() {
        return storeUnexpectedType;
    }

    @Override
    public final IdentityManagementException partitionAddFailed(Partition partition, String configurationName, Exception e) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.partitionAddFailed$str(), partition, configurationName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionAddFailed$str() {
        return partitionAddFailed;
    }

    @Override
    public final IdentityManagementException partitionUpdateFailed(Partition partition, Exception e) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.partitionUpdateFailed$str(), partition), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionUpdateFailed$str() {
        return partitionUpdateFailed;
    }

    @Override
    public final IdentityManagementException partitionRemoveFailed(Partition partition, Exception e) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.partitionRemoveFailed$str(), partition), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionRemoveFailed$str() {
        return partitionRemoveFailed;
    }

    public final IdentityManagementException partitionGetFailed(Class partitionClass, String name, Exception e) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.partitionGetFailed$str(), partitionClass, name), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionGetFailed$str() {
        return partitionGetFailed;
    }

    @Override
    public final IdentityManagementException partitionCouldNotCreateIdentityManager(Partition partition, Throwable t) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.partitionCouldNotCreateIdentityManager$str(), partition), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionCouldNotCreateIdentityManager$str() {
        return partitionCouldNotCreateIdentityManager;
    }

    public final IdentityManagementException partitionNotFoundWithName(Class type, String name) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.partitionNotFoundWithName$str(), type, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionNotFoundWithName$str() {
        return partitionNotFoundWithName;
    }

    @Override
    public final IdentityManagementException partitionNoConfigurationFound(String name) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.partitionNoConfigurationFound$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionNoConfigurationFound$str() {
        return partitionNoConfigurationFound;
    }

    @Override
    public final IdentityManagementException partitionReferencesInvalidConfiguration(Partition partition) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.partitionReferencesInvalidConfiguration$str(), partition));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionReferencesInvalidConfiguration$str() {
        return partitionReferencesInvalidConfiguration;
    }

    public final OperationNotSupportedException partitionManagementNoSupported(Class partitionClass, IdentityStoreConfiguration.IdentityOperation create) {
        OperationNotSupportedException result = new OperationNotSupportedException(String.format(this.partitionManagementNoSupported$str(), new Object[0]), partitionClass, create);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionManagementNoSupported$str() {
        return partitionManagementNoSupported;
    }

    @Override
    public final IdentityManagementException partitionCouldNotCreatePermissionManager(Partition partition) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.partitionCouldNotCreatePermissionManager$str(), partition));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionCouldNotCreatePermissionManager$str() {
        return partitionCouldNotCreatePermissionManager;
    }

    public final IdentityManagementException partitionUnsupportedType(Partition partition, Class type) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.partitionUnsupportedType$str(), partition, type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionUnsupportedType$str() {
        return partitionUnsupportedType;
    }

    public final IdentityManagementException partitionFoundWithSameNameAndType(String name, Class partitionClass) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.partitionFoundWithSameNameAndType$str(), name, partitionClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionFoundWithSameNameAndType$str() {
        return partitionFoundWithSameNameAndType;
    }

    public final IdentityManagementException partitionAlreadyExistsWithName(Class type, String name) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.partitionAlreadyExistsWithName$str(), type, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionAlreadyExistsWithName$str() {
        return partitionAlreadyExistsWithName;
    }

    @Override
    public final IdentityManagementException partitionWithNoConfigurationName(Partition partition) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.partitionWithNoConfigurationName$str(), partition));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionWithNoConfigurationName$str() {
        return partitionWithNoConfigurationName;
    }

    public final IdentityManagementException queryRelationshipFailed(RelationshipQuery query, Throwable t) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.queryRelationshipFailed$str(), query), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queryRelationshipFailed$str() {
        return queryRelationshipFailed;
    }

    public final IdentityManagementException queryIdentityTypeFailed(IdentityQuery query, Throwable t) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.queryIdentityTypeFailed$str(), query), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queryIdentityTypeFailed$str() {
        return queryIdentityTypeFailed;
    }

    @Override
    public final IdentityManagementException queryUnsupportedParameterValue(String parameterName, Object parameterValue) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.queryUnsupportedParameterValue$str(), parameterName, parameterValue));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queryUnsupportedParameterValue$str() {
        return queryUnsupportedParameterValue;
    }

    @Override
    public final IdentityManagementException attributedTypeAddFailed(AttributedType identityType, Throwable t) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.attributedTypeAddFailed$str(), identityType), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedTypeAddFailed$str() {
        return attributedTypeAddFailed;
    }

    @Override
    public final IdentityManagementException attributedTypeRemoveFailed(AttributedType identityType, Throwable t) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.attributedTypeRemoveFailed$str(), identityType), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedTypeRemoveFailed$str() {
        return attributedTypeRemoveFailed;
    }

    @Override
    public final IdentityManagementException attributedTypeUpdateFailed(AttributedType identityType, Throwable t) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.attributedTypeUpdateFailed$str(), identityType), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedTypeUpdateFailed$str() {
        return attributedTypeUpdateFailed;
    }

    public final IdentityManagementException identityTypeAlreadyExists(Class type, String identifier, Partition partition) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.identityTypeAlreadyExists$str(), type, identifier, partition));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String identityTypeAlreadyExists$str() {
        return identityTypeAlreadyExists;
    }

    @Override
    public final IdentityManagementException attributedTypeAmbiguosFoundWithId(String id) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.attributedTypeAmbiguosFoundWithId$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedTypeAmbiguosFoundWithId$str() {
        return attributedTypeAmbiguosFoundWithId;
    }

    public final OperationNotSupportedException attributedTypeUnsupportedOperation(Class type, IdentityStoreConfiguration.IdentityOperation operation, Class typeToDisplay, IdentityStoreConfiguration.IdentityOperation operationToDisplay) {
        OperationNotSupportedException result = new OperationNotSupportedException(String.format(this.attributedTypeUnsupportedOperation$str(), typeToDisplay, operationToDisplay), type, operation);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedTypeUnsupportedOperation$str() {
        return attributedTypeUnsupportedOperation;
    }

    @Override
    public final IdentityManagementException attributedUndefinedPartition(IdentityType identityType) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.attributedUndefinedPartition$str(), identityType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedUndefinedPartition$str() {
        return attributedUndefinedPartition;
    }

    public final IdentityManagementException attributedTypeNotFoundWithId(Class type, String id, Partition partition) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.attributedTypeNotFoundWithId$str(), type, id, partition));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedTypeNotFoundWithId$str() {
        return attributedTypeNotFoundWithId;
    }

    @Override
    public final IdentityManagementException permissionUnsupportedOperation() {
        IdentityManagementException result = new IdentityManagementException(String.format(this.permissionUnsupportedOperation$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionUnsupportedOperation$str() {
        return permissionUnsupportedOperation;
    }

    @Override
    public final IdentityManagementException configJpaStoreNoPermissionEntityClassProvided() {
        IdentityManagementException result = new IdentityManagementException(String.format(this.configJpaStoreNoPermissionEntityClassProvided$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configJpaStoreNoPermissionEntityClassProvided$str() {
        return configJpaStoreNoPermissionEntityClassProvided;
    }

    public final IdentityManagementException instantiationError(Class arg0, Throwable arg1) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.instantiationError$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String instantiationError$str() {
        return instantiationError;
    }

    public final IdentityManagementException nullArgument(String arg0) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.nullArgument$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullArgument$str() {
        return nullArgument;
    }

    public final IdentityManagementException unmarshallingError(Throwable arg0) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.unmarshallingError$str(), new Object[0]), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unmarshallingError$str() {
        return unmarshallingError;
    }

    public final IdentityManagementException marshallingError(Throwable arg0) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.marshallingError$str(), new Object[0]), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String marshallingError$str() {
        return marshallingError;
    }

    public final IdentityManagementException unexpectedType(Class arg0) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.unexpectedType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedType$str() {
        return unexpectedType;
    }

    public final IdentityManagementException partitionManagerInitializationFailed(Class arg0, Throwable arg1) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.partitionManagerInitializationFailed$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionManagerInitializationFailed$str() {
        return partitionManagerInitializationFailed;
    }

    public final NotImplementedException notImplemented() {
        NotImplementedException result = new NotImplementedException(String.format(this.notImplemented$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notImplemented$str() {
        return notImplemented;
    }

    public final IdentityManagementException credentialValidationFailed(Credentials arg0, Throwable arg1) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialValidationFailed$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialValidationFailed$str() {
        return credentialValidationFailed;
    }

    public final IdentityManagementException credentialUpdateFailed(Account arg0, Object arg1, Throwable arg2) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialUpdateFailed$str(), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialUpdateFailed$str() {
        return credentialUpdateFailed;
    }

    public final IdentityManagementException credentialNoStoreForCredentials(Class arg0) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialNoStoreForCredentials$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialNoStoreForCredentials$str() {
        return credentialNoStoreForCredentials;
    }

    public final IdentityManagementException credentialUnsupportedType(Class arg0, CredentialHandler arg1) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialUnsupportedType$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialUnsupportedType$str() {
        return credentialUnsupportedType;
    }

    public final IdentityManagementException credentialRetrievalFailed(Account arg0, Class arg1, Throwable arg2) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialRetrievalFailed$str(), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialRetrievalFailed$str() {
        return credentialRetrievalFailed;
    }

    public final IdentityManagementException credentialInvalidAccountType(Class arg0) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialInvalidAccountType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialInvalidAccountType$str() {
        return credentialInvalidAccountType;
    }

    public final IdentityManagementException credentialMultipleAccountsFoundForType(String arg0, Class arg1) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialMultipleAccountsFoundForType$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialMultipleAccountsFoundForType$str() {
        return credentialMultipleAccountsFoundForType;
    }

    public final IdentityManagementException credentialNoAccountTypeProvided() {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialNoAccountTypeProvided$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialNoAccountTypeProvided$str() {
        return credentialNoAccountTypeProvided;
    }

    public final IdentityManagementException credentialUnknownUserNameProperty(Class arg0) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialUnknownUserNameProperty$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialUnknownUserNameProperty$str() {
        return credentialUnknownUserNameProperty;
    }

    public final IdentityManagementException credentialDigestInvalidRealm() {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialDigestInvalidRealm$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialDigestInvalidRealm$str() {
        return credentialDigestInvalidRealm;
    }

    public final IdentityManagementException credentialInvalidPassword() {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialInvalidPassword$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialInvalidPassword$str() {
        return credentialInvalidPassword;
    }

    public final IdentityManagementException credentialCouldNotEncodePassword(UnsupportedEncodingException arg0) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialCouldNotEncodePassword$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialCouldNotEncodePassword$str() {
        return credentialCouldNotEncodePassword;
    }

    public final IdentityManagementException credentialHandlerNotFoundForCredentialType(Class arg0) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialHandlerNotFoundForCredentialType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialHandlerNotFoundForCredentialType$str() {
        return credentialHandlerNotFoundForCredentialType;
    }

    public final IdentityManagementException credentialInvalidEncodingAlgorithm(String arg0, PasswordEncoder arg1, Throwable arg2) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialInvalidEncodingAlgorithm$str(), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialInvalidEncodingAlgorithm$str() {
        return credentialInvalidEncodingAlgorithm;
    }

    public final IdentityManagementException credentialNoConsumerForToken(Token arg0) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialNoConsumerForToken$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialNoConsumerForToken$str() {
        return credentialNoConsumerForToken;
    }

    public final SecurityConfigurationException configCouldNotCreateConfiguration(Exception arg0) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configCouldNotCreateConfiguration$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configCouldNotCreateConfiguration$str() {
        return configCouldNotCreateConfiguration;
    }

    public final SecurityConfigurationException configInvalidConfiguration(String arg0, Throwable arg1) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configInvalidConfiguration$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configInvalidConfiguration$str() {
        return configInvalidConfiguration;
    }

    public final SecurityConfigurationException configNoConfigurationProvided() {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configNoConfigurationProvided$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configNoConfigurationProvided$str() {
        return configNoConfigurationProvided;
    }

    public final SecurityConfigurationException configBuildMultipleConfigurationExists() {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configBuildMultipleConfigurationExists$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configBuildMultipleConfigurationExists$str() {
        return configBuildMultipleConfigurationExists;
    }

    public final SecurityConfigurationException configNoIdentityConfigurationProvided() {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configNoIdentityConfigurationProvided$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configNoIdentityConfigurationProvided$str() {
        return configNoIdentityConfigurationProvided;
    }

    public final SecurityConfigurationException configStoreNoIdentityStoreConfigProvided() {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configStoreNoIdentityStoreConfigProvided$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configStoreNoIdentityStoreConfigProvided$str() {
        return configStoreNoIdentityStoreConfigProvided;
    }

    public final SecurityConfigurationException configStoreDuplicatedSupportedType(Class arg0) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configStoreDuplicatedSupportedType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configStoreDuplicatedSupportedType$str() {
        return configStoreDuplicatedSupportedType;
    }

    public final SecurityConfigurationException configMultipleConfigurationsFoundWithCredentialSupport() {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configMultipleConfigurationsFoundWithCredentialSupport$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configMultipleConfigurationsFoundWithCredentialSupport$str() {
        return configMultipleConfigurationsFoundWithCredentialSupport;
    }

    public final SecurityConfigurationException configJpaStoreNoEntityClassesProvided() {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configJpaStoreNoEntityClassesProvided$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configJpaStoreNoEntityClassesProvided$str() {
        return configJpaStoreNoEntityClassesProvided;
    }

    public final SecurityConfigurationException configJpaStoreRequiredMappingAnnotation(Class arg0, Class arg1) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configJpaStoreRequiredMappingAnnotation$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configJpaStoreRequiredMappingAnnotation$str() {
        return configJpaStoreRequiredMappingAnnotation;
    }

    public final SecurityConfigurationException configJpaStoreRequiredMappingAnnotationForAttributedType(Class arg0, Class arg1) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configJpaStoreRequiredMappingAnnotationForAttributedType$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configJpaStoreRequiredMappingAnnotationForAttributedType$str() {
        return configJpaStoreRequiredMappingAnnotationForAttributedType;
    }

    public final SecurityConfigurationException configJpaStoreMappedNoAttributeMappingFound() {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configJpaStoreMappedNoAttributeMappingFound$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configJpaStoreMappedNoAttributeMappingFound$str() {
        return configJpaStoreMappedNoAttributeMappingFound;
    }

    public final SecurityConfigurationException configJpaStoreMappedNoCredentialStorageMappingFound() {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configJpaStoreMappedNoCredentialStorageMappingFound$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configJpaStoreMappedNoCredentialStorageMappingFound$str() {
        return configJpaStoreMappedNoCredentialStorageMappingFound;
    }

    public final SecurityConfigurationException configJpaStoreMappedPropertyNotFound(Class arg0, String arg1, Class arg2) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configJpaStoreMappedPropertyNotFound$str(), arg0, arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configJpaStoreMappedPropertyNotFound$str() {
        return configJpaStoreMappedPropertyNotFound;
    }

    public final SecurityConfigurationException configUnknownStoreForConfiguration(IdentityStoreConfiguration arg0) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configUnknownStoreForConfiguration$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configUnknownStoreForConfiguration$str() {
        return configUnknownStoreForConfiguration;
    }

    public final SecurityConfigurationException configCouldNotCreateStore(Class arg0, IdentityStoreConfiguration arg1, Exception arg2) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configCouldNotCreateStore$str(), arg0, arg1), (Throwable)arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configCouldNotCreateStore$str() {
        return configCouldNotCreateStore;
    }

    public final SecurityConfigurationException configStoreMultiplePartitionConfigExists(IdentityStoreConfiguration arg0, IdentityStoreConfiguration arg1) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configStoreMultiplePartitionConfigExists$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configStoreMultiplePartitionConfigExists$str() {
        return configStoreMultiplePartitionConfigExists;
    }

    public final SecurityConfigurationException configMultipleConfigurationsFoundWithSameName(String arg0) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configMultipleConfigurationsFoundWithSameName$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configMultipleConfigurationsFoundWithSameName$str() {
        return configMultipleConfigurationsFoundWithSameName;
    }

    public final IdentityManagementException permissionGrantFailed(IdentityType arg0, Object arg1, String arg2, Throwable arg3) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.permissionGrantFailed$str(), arg0, arg1, arg2), arg3);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionGrantFailed$str() {
        return permissionGrantFailed;
    }

    public final IdentityManagementException permissionsGrantFailed(String arg0, Throwable arg1) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.permissionsGrantFailed$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionsGrantFailed$str() {
        return permissionsGrantFailed;
    }

    public final IdentityManagementException permissionRevokeFailed(IdentityType arg0, Object arg1, String arg2, Throwable arg3) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.permissionRevokeFailed$str(), arg0, arg1, arg2), arg3);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionRevokeFailed$str() {
        return permissionRevokeFailed;
    }

    public final IdentityManagementException permissionsRevokeFailed(String arg0, Throwable arg1) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.permissionsRevokeFailed$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionsRevokeFailed$str() {
        return permissionsRevokeFailed;
    }

    public final IdentityManagementException permissionRevokeAllFailed(Object arg0, Throwable arg1) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.permissionRevokeAllFailed$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionRevokeAllFailed$str() {
        return permissionRevokeAllFailed;
    }
}

