/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.identity.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.plugins.PersistenceStrategy;

public class FilePersistenceStrategy
implements PersistenceStrategy {
    private String path;

    public FilePersistenceStrategy(String path) {
        this.path = path;
    }

    @Override
    public Identity persistIdentity(Identity identity) {
        File file;
        FileOutputStream fos;
        ObjectOutputStream oos;
        block5: {
            oos = null;
            fos = null;
            file = new File(this.path + File.separator + identity.getName());
            if (!file.exists()) break block5;
            Identity identity2 = null;
            this.safeClose(oos);
            this.safeClose(fos);
            return identity2;
        }
        try {
            fos = new FileOutputStream(file);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(identity);
            Identity identity3 = identity;
            this.safeClose(oos);
            this.safeClose(fos);
            return identity3;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(oos);
                this.safeClose(fos);
                throw throwable;
            }
        }
    }

    @Override
    public Identity getIdentity(String name) {
        ObjectInputStream ois = null;
        FileInputStream fis = null;
        try {
            Identity identity;
            fis = new FileInputStream(this.path + File.separator + name);
            ois = new ObjectInputStream(fis);
            Identity identity2 = identity = (Identity)ois.readObject();
            this.safeClose(ois);
            this.safeClose(fis);
            return identity2;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(ois);
                this.safeClose(fis);
                throw throwable;
            }
        }
    }

    @Override
    public boolean removeIdentity(Identity identity) {
        File file = new File(this.path + File.separator + identity.getName());
        return file.delete();
    }

    @Override
    public Identity updateIdentity(Identity identity) {
        if (this.removeIdentity(identity)) {
            return this.persistIdentity(identity);
        }
        return null;
    }

    private void safeClose(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeClose(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

