/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.acl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.acl.ACL;
import org.jboss.security.acl.ACLEntry;
import org.jboss.security.acl.ACLPermission;
import org.jboss.security.acl.ACLProviderImpl;
import org.jboss.security.acl.EntitlementEntry;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.Resource;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;

public class RoleBasedACLProviderImpl
extends ACLProviderImpl {
    @Override
    public <T> Set<T> getEntitlements(Class<T> clazz, Resource resource, Identity identity) throws AuthorizationException {
        if (identity.getRole() == null) {
            return super.getEntitlements(clazz, resource, identity);
        }
        if (!EntitlementEntry.class.equals(clazz)) {
            return null;
        }
        HashSet<EntitlementEntry> entitlements = new HashSet<EntitlementEntry>();
        ArrayList<Role> roles = new ArrayList<Role>();
        this.getAllRoles(identity.getRole(), roles);
        for (Role role : roles) {
            ACLPermission permission = super.getInitialPermissions(resource, role.getRoleName());
            if (permission == null) continue;
            super.fillEntitlements(entitlements, resource, role.getRoleName(), permission);
        }
        return entitlements;
    }

    @Override
    public boolean isAccessGranted(Resource resource, Identity identity, ACLPermission permission) throws AuthorizationException {
        if (identity.getRole() == null) {
            return super.isAccessGranted(resource, identity, permission);
        }
        if (this.strategy != null) {
            ACL acl = this.strategy.getACL(resource);
            if (acl != null) {
                ArrayList<Role> roles = new ArrayList<Role>();
                this.getAllRoles(identity.getRole(), roles);
                for (Role role : roles) {
                    ACLEntry entry = acl.getEntry(role.getRoleName());
                    if (entry == null || !entry.checkPermission(permission)) continue;
                    return true;
                }
                return false;
            }
            throw new AuthorizationException(PicketBoxMessages.MESSAGES.unableToLocateACLForResourceMessage(resource != null ? resource.toString() : null));
        }
        throw new AuthorizationException(PicketBoxMessages.MESSAGES.unableToLocateACLWithNoStrategyMessage());
    }

    protected void getAllRoles(Role role, List<Role> roles) {
        if (role instanceof RoleGroup) {
            RoleGroup group = (RoleGroup)role;
            for (Role nestedRole : group.getRoles()) {
                this.getAllRoles(nestedRole, roles);
            }
        } else {
            roles.add(role);
        }
    }
}

