/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.acl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.persistence.Id;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.authorization.Resource;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.plugins.IdentityFactory;

public class Util {
    public static String getResourceAsString(Resource resource) {
        String resourceString = null;
        if (resource != null) {
            String resourceClass = resource.getClass().getCanonicalName();
            resourceString = String.valueOf(resourceClass) + ":" + Util.getResourceKey(resource);
        }
        return resourceString;
    }

    public static String getIdentityAsString(Identity identity) {
        String identityString = null;
        if (identity != null) {
            identityString = String.valueOf(identity.getClass().getCanonicalName()) + ":" + identity.getName();
        }
        return identityString;
    }

    public static Identity getIdentityFromString(String identityString) {
        Identity identity = null;
        if (identityString != null) {
            String[] identityParts = identityString.split(":");
            if (identityParts.length != 2) {
                throw PicketBoxMessages.MESSAGES.malformedIdentityString(identityString);
            }
            try {
                identity = IdentityFactory.createIdentity((String)identityParts[0], (String)identityParts[1]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return identity;
    }

    private static Object getResourceKey(Resource resource) {
        Class<?> resourceClass = resource.getClass();
        Object resourceKey = null;
        Field[] fieldArray = resourceClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getAnnotation(Id.class) != null) {
                try {
                    resourceKey = field.get(resource);
                }
                catch (Exception e) {
                    String fieldName = field.getName();
                    String methodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    resourceKey = Util.executeNoArgMethod(resource, methodName);
                }
                break;
            }
            ++n2;
        }
        if (resourceKey == null) {
            resourceKey = Util.executeNoArgMethod(resource, "getId");
        }
        return resourceKey;
    }

    private static Object executeNoArgMethod(Object target, String methodName) {
        Class<?> targetClass = target.getClass();
        try {
            Method method = targetClass.getMethod(methodName, null);
            return method.invoke(target, null);
        }
        catch (Exception e) {
            return null;
        }
    }
}

