/*
  * JBoss, Home of Professional Open Source
  * Copyright 2007, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.security;


//$Id$

/**
 *  Interface that defines common behavior among
 *  the various Security Managers
 *  @author Anil.Saldhana@redhat.com
 *  @since  Sep 10, 2007 
 *  @version $Revision$
 */
public interface BaseSecurityManager
{
   /** Get the security domain from which the security manager is from. Every
   security manager belongs to a named domain. The meaning of the security
   domain name depends on the implementation. Examples range from as fine
   grained as the name of EJBs to J2EE application names to DNS domain names.
   @return the security domain name. May be null in which case the security
   manager belongs to the logical default domain.
    */
   String getSecurityDomain();  
}
