/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.fixjaxb1058;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.generator.bean.field.DummyListField;
import com.sun.tools.xjc.generator.bean.field.IsSetField;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import org.jvnet.jaxb2_commons.reflection.util.Accessor;
import org.jvnet.jaxb2_commons.reflection.util.FieldAccessor;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class FixJAXB1058Plugin
extends Plugin {
    private Accessor<JMethod> DummyListField_$get;
    private Accessor<FieldOutline> IsSetField_core;
    private Accessor<JFieldVar> AbstractListField_field;
    private Accessor<JClass> AbstractListField_listT;
    private Accessor<JClass> DummyListField_coreList;

    public String getOptionName() {
        return "XfixJAXB1058";
    }

    public String getUsage() {
        return "  -XfixJAXB1058      :  Fixes JAXB-1058 (see https://github.com/highsource/jaxb2-basics/issues/14)";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) throws SAXException {
        try {
            this.DummyListField_$get = new FieldAccessor(DummyListField.class, "$get", JMethod.class);
            this.IsSetField_core = new FieldAccessor(IsSetField.class, "core", FieldOutline.class);
            this.AbstractListField_field = new FieldAccessor(DummyListField.class.getSuperclass(), "field", JFieldVar.class);
            this.AbstractListField_listT = new FieldAccessor(DummyListField.class.getSuperclass(), "listT", JClass.class);
            this.DummyListField_coreList = new FieldAccessor(DummyListField.class, "coreList", JClass.class);
        }
        catch (Exception ex) {
            throw new SAXException("Could not create field accessors. This plugin can not be used in this environment.", ex);
        }
        for (ClassOutline classOutline : outline.getClasses()) {
            for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
                this.fixFieldOutline(fieldOutline);
            }
        }
        return false;
    }

    private void fixFieldOutline(FieldOutline fieldOutline) {
        if (fieldOutline instanceof DummyListField) {
            this.fixDummyListField((DummyListField)fieldOutline);
        } else if (fieldOutline instanceof IsSetField) {
            this.fixIsSetField((IsSetField)fieldOutline);
        }
    }

    private void fixDummyListField(DummyListField fieldOutline) {
        if (this.DummyListField_$get.get((Object)fieldOutline) == null) {
            JFieldVar field = (JFieldVar)this.AbstractListField_field.get((Object)fieldOutline);
            JType listT = (JType)this.AbstractListField_listT.get((Object)fieldOutline);
            JClass coreList = (JClass)this.DummyListField_coreList.get((Object)fieldOutline);
            JMethod $get = fieldOutline.parent().implClass.method(1, listT, "get" + fieldOutline.getPropertyInfo().getName(true));
            JBlock block = $get.body();
            block._if(field.eq(JExpr._null()))._then().assign((JAssignmentTarget)field, (JExpression)JExpr._new((JClass)coreList));
            block._return((JExpression)JExpr._this().ref((JVar)field));
            this.DummyListField_$get.set((Object)fieldOutline, (Object)$get);
        }
    }

    private void fixIsSetField(IsSetField isSetField) {
        FieldOutline core = (FieldOutline)this.IsSetField_core.get((Object)isSetField);
        this.fixFieldOutline(core);
    }
}

