/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.equals;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.locator.DefaultRootObjectLocator;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.plugin.Customizations;
import org.jvnet.jaxb2_commons.plugin.CustomizedIgnoring;
import org.jvnet.jaxb2_commons.plugin.Ignoring;
import org.jvnet.jaxb2_commons.plugin.util.FieldOutlineUtils;
import org.jvnet.jaxb2_commons.plugin.util.StrategyClassUtils;
import org.jvnet.jaxb2_commons.util.ClassUtils;
import org.jvnet.jaxb2_commons.util.FieldAccessorFactory;
import org.jvnet.jaxb2_commons.util.PropertyFieldAccessorFactory;
import org.jvnet.jaxb2_commons.xjc.outline.FieldAccessorEx;
import org.xml.sax.ErrorHandler;

public class EqualsPlugin
extends AbstractParameterizablePlugin {
    private FieldAccessorFactory fieldAccessorFactory = PropertyFieldAccessorFactory.INSTANCE;
    private String equalsStrategyClass = JAXBEqualsStrategy.class.getName();
    private Ignoring ignoring = new CustomizedIgnoring(org.jvnet.jaxb2_commons.plugin.equals.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);

    public String getOptionName() {
        return "Xequals";
    }

    public String getUsage() {
        return "  -Xequals           :  generates reflection-free 'equals' methods";
    }

    public FieldAccessorFactory getFieldAccessorFactory() {
        return this.fieldAccessorFactory;
    }

    public void setFieldAccessorFactory(FieldAccessorFactory fieldAccessorFactory) {
        this.fieldAccessorFactory = fieldAccessorFactory;
    }

    public void setEqualsStrategyClass(String equalsStrategyClass) {
        this.equalsStrategyClass = equalsStrategyClass;
    }

    public String getEqualsStrategyClass() {
        return this.equalsStrategyClass;
    }

    public JExpression createEqualsStrategy(JCodeModel codeModel) {
        return StrategyClassUtils.createStrategyInstanceExpression(codeModel, EqualsStrategy2.class, this.getEqualsStrategyClass());
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(org.jvnet.jaxb2_commons.plugin.equals.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        for (ClassOutline classOutline : outline.getClasses()) {
            if (this.getIgnoring().isIgnored(classOutline)) continue;
            this.processClassOutline(classOutline);
        }
        return true;
    }

    protected void processClassOutline(ClassOutline classOutline) {
        JDefinedClass theClass = classOutline.implClass;
        ClassUtils._implements((JDefinedClass)theClass, (JClass)theClass.owner().ref(Equals2.class));
        JMethod equals = this.generateEquals$equals(classOutline, theClass);
        JMethod objectEquals = this.generateObject$equals(classOutline, theClass);
    }

    protected JMethod generateObject$equals(ClassOutline classOutline, JDefinedClass theClass) {
        JCodeModel codeModel = theClass.owner();
        JMethod objectEquals = theClass.method(1, (JType)codeModel.BOOLEAN, "equals");
        objectEquals.annotate(Override.class);
        JVar that = objectEquals.param(Object.class, "object");
        JBlock body = objectEquals.body();
        JVar thisLocator = body.decl(0, (JType)codeModel.ref(ObjectLocator.class), "thisLocator", JExpr._null());
        JVar thatLocator = body.decl(0, (JType)codeModel.ref(ObjectLocator.class), "thatLocator", JExpr._null());
        JVar equalsStrategy = body.decl(8, (JType)codeModel.ref(EqualsStrategy2.class), "strategy", this.createEqualsStrategy(codeModel));
        JInvocation thisRootLocator = JExpr._new((JClass)codeModel.ref(DefaultRootObjectLocator.class)).arg(JExpr._this());
        JInvocation thatRootLocator = JExpr._new((JClass)codeModel.ref(DefaultRootObjectLocator.class)).arg((JExpression)that);
        JConditional ifTraceEnabled = body._if((JExpression)equalsStrategy.invoke("isTraceEnabled"));
        ifTraceEnabled._then().assign((JAssignmentTarget)thisLocator, (JExpression)thisRootLocator).assign((JAssignmentTarget)thatLocator, (JExpression)thatRootLocator);
        body._return((JExpression)JExpr.invoke((String)"equals").arg((JExpression)thisLocator).arg((JExpression)thatLocator).arg((JExpression)that).arg((JExpression)equalsStrategy));
        return objectEquals;
    }

    protected JMethod generateEquals$equals(ClassOutline classOutline, JDefinedClass theClass) {
        JCodeModel codeModel = theClass.owner();
        JMethod equals = theClass.method(1, (JType)codeModel.BOOLEAN, "equals");
        equals.annotate(Override.class);
        JBlock body = equals.body();
        JVar leftLocator = equals.param(ObjectLocator.class, "thisLocator");
        JVar rightLocator = equals.param(ObjectLocator.class, "thatLocator");
        JVar object = equals.param(Object.class, "object");
        JVar equalsStrategy = equals.param(EqualsStrategy2.class, "strategy");
        JExpression objectIsNull = object.eq(JExpr._null());
        JExpression notTheSameType = JExpr._this().invoke("getClass").ne((JExpression)object.invoke("getClass"));
        body._if(JOp.cor((JExpression)objectIsNull, (JExpression)notTheSameType))._then()._return(JExpr.FALSE);
        body._if(JExpr._this().eq((JExpression)object))._then()._return(JExpr.TRUE);
        Boolean superClassImplementsEquals = StrategyClassUtils.superClassImplements(classOutline, this.getIgnoring(), Equals2.class);
        if (superClassImplementsEquals != null) {
            if (superClassImplementsEquals.booleanValue()) {
                body._if(JOp.not((JExpression)JExpr._super().invoke("equals").arg((JExpression)leftLocator).arg((JExpression)rightLocator).arg((JExpression)object).arg((JExpression)equalsStrategy)))._then()._return(JExpr.FALSE);
            } else {
                body._if(JOp.not((JExpression)JExpr._super().invoke("equals").arg((JExpression)object)))._then()._return(JExpr.FALSE);
            }
        }
        JExpression _this = JExpr._this();
        FieldOutline[] declaredFields = FieldOutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring());
        if (declaredFields.length > 0) {
            JVar _that = body.decl(8, (JType)theClass, "that", (JExpression)JExpr.cast((JType)theClass, (JExpression)object));
            for (FieldOutline fieldOutline : declaredFields) {
                FieldAccessorEx leftFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, _this);
                FieldAccessorEx rightFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, (JExpression)_that);
                if (leftFieldAccessor.isConstant() || rightFieldAccessor.isConstant()) continue;
                JBlock block = body.block();
                String name = fieldOutline.getPropertyInfo().getName(true);
                JExpression leftFieldHasSetValue = leftFieldAccessor.isAlwaysSet() || leftFieldAccessor.hasSetValue() == null ? JExpr.TRUE : leftFieldAccessor.hasSetValue();
                JExpression rightFieldHasSetValue = rightFieldAccessor.isAlwaysSet() || rightFieldAccessor.hasSetValue() == null ? JExpr.TRUE : rightFieldAccessor.hasSetValue();
                JVar lhsValue = block.decl(leftFieldAccessor.getType(), "lhs" + name);
                leftFieldAccessor.toRawValue(block, lhsValue);
                JVar rhsValue = block.decl(rightFieldAccessor.getType(), "rhs" + name);
                rightFieldAccessor.toRawValue(block, rhsValue);
                JInvocation leftFieldLocator = codeModel.ref(LocatorUtils.class).staticInvoke("property").arg((JExpression)leftLocator).arg(fieldOutline.getPropertyInfo().getName(false)).arg((JExpression)lhsValue);
                JInvocation rightFieldLocator = codeModel.ref(LocatorUtils.class).staticInvoke("property").arg((JExpression)rightLocator).arg(fieldOutline.getPropertyInfo().getName(false)).arg((JExpression)rhsValue);
                block._if(JOp.not((JExpression)JExpr.invoke((JExpression)equalsStrategy, (String)"equals").arg((JExpression)leftFieldLocator).arg((JExpression)rightFieldLocator).arg((JExpression)lhsValue).arg((JExpression)rhsValue).arg(leftFieldHasSetValue).arg(rightFieldHasSetValue)))._then()._return(JExpr.FALSE);
            }
        }
        body._return(JExpr.TRUE);
        return equals;
    }
}

